/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.migration.internal.ui.wizard;

import com.nxp.s32ds.cle.ide.migration.internal.ui.wizard.MigrationListInputElement;
import com.nxp.s32ds.cle.runtime.migration.core.Migrations;
import com.nxp.s32ds.cle.runtime.migration.diagnostic.MigrationDiagnostic;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;

public class MigrationListInput {
    private final List<IProject> projects = new ArrayList<IProject>();
    private final Map<IProject, Map<String, Boolean>> projectToMigrationsCache = new HashMap<IProject, Map<String, Boolean>>();
    private final TreeViewer viewer;
    private final MigrationListInputElement[] elements;
    private boolean applicableOnly = true;

    public MigrationListInput(TreeViewer viewer, boolean applicableOnly) {
        this.viewer = viewer;
        this.applicableOnly = applicableOnly;
        this.elements = (MigrationListInputElement[])Migrations.getUserSequenceDescriptors().stream().map(d -> new MigrationListInputElement(this, (MigrationSequenceDescriptor)d)).toArray(MigrationListInputElement[]::new);
    }

    public boolean isApplicableOnly() {
        return this.applicableOnly;
    }

    public void setApplicableOnly(boolean applicableOnly) {
        if (this.applicableOnly == applicableOnly) {
            return;
        }
        this.applicableOnly = applicableOnly;
        ISelection selection = this.viewer.getSelection();
        this.viewer.refresh(true);
        this.viewer.setSelection(selection);
    }

    public void setProjects(Collection<IProject> collection) {
        this.projects.clear();
        this.projects.addAll(collection);
        ISelection selection = this.viewer.getSelection();
        this.viewer.refresh(true);
        this.viewer.setSelection(selection);
    }

    private boolean match(MigrationSequenceDescriptor descriptor, IProject project) {
        return this.projectToMigrationsCache.computeIfAbsent(project, p -> new HashMap()).computeIfAbsent(descriptor.getId(), id -> descriptor.getSequence().match(project, new MigrationDiagnostic(project)));
    }

    public boolean isApplicable(MigrationSequenceDescriptor descriptor) {
        return this.projects.stream().allMatch(p -> this.match(descriptor, (IProject)p));
    }

    public MigrationListInputElement[] getElements() {
        if (this.projects.isEmpty()) {
            return new MigrationListInputElement[0];
        }
        if (!this.applicableOnly) {
            return this.elements;
        }
        return (MigrationListInputElement[])Arrays.stream(this.elements).filter(e -> e.isApplicable()).toArray(MigrationListInputElement[]::new);
    }
}

