/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import com.freescale.s32ds.cdt.core.internal.commanderview.handlers.BaseLaunchConfigContextHandler;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.CommandManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.ContextManager;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.Messages;
import com.freescale.s32ds.cdt.core.internal.commanderview.view.SafeRunnable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.progress.WorkbenchJob;

public class CommanderView
extends ViewPart {
    public static final String VIEW_ID = "com.freescale.core.ide.commanderView";
    private Composite fParentComp;
    private Composite fCmdCompositeParent;
    private ScrolledForm fForm;
    private FormToolkit fToolkit;
    private IPartListener2 fPartListener = new IPartListener2(){

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            String partRefId = partRef.getId();
            if (partRefId.equals(CommanderView.VIEW_ID)) {
                CommanderView.this.fContextMgr.setView(null);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partActivated(IWorkbenchPartReference partRef) {
        }
    };
    private List<Section> fSections = new ArrayList<Section>();
    private Set<String> fCollapsedGroups = new HashSet<String>();
    private boolean fPinned;
    private Composite fStatus;
    private Label fLabel;
    private ControlAdapter fResizeListener;
    private Composite[] fCmdComposites;
    private Integer[] fCurrentSectionsDistribution;
    private static final String PREF_COLLAPSED_GROUPS = "collapsedGroups";
    private List<HyperlinkEntry> fLinkEntries = new LinkedList<HyperlinkEntry>();
    private ILaunchConfigurationListener fLaunchConfigListener = new ILaunchConfigurationListener(){

        public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            if (!configuration.isWorkingCopy()) {
                CommanderView.this.updateCmdLinks();
            }
        }

        public void launchConfigurationChanged(ILaunchConfiguration configuration) {
            if (!configuration.isWorkingCopy()) {
                CommanderView.this.updateCmdLinks();
            }
        }

        public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            if (!configuration.isWorkingCopy()) {
                CommanderView.this.updateCmdLinks();
            }
        }
    };
    private ILaunchesListener fLaunchesListener = new ILaunchesListener(){

        public void launchesAdded(ILaunch[] launches) {
            CommanderView.this.updateCmdLinks();
        }

        public void launchesRemoved(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }
    };
    private ContextManager fContextMgr;

    protected void updateCmdLinks() {
        if (Display.getCurrent() == null) {
            WorkbenchJob job = new WorkbenchJob(Messages.CommanderView_0){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    CommanderView.this.updateCmdLinksUI();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
        } else {
            this.updateCmdLinksUI();
        }
    }

    private void updateCmdLinksUI() {
        try {
            for (final HyperlinkEntry entry : this.fLinkEntries) {
                String tooltip = entry.cmd.tooltip;
                boolean enable = true;
                IProject[] projects = this.fContextMgr.getActiveProjects().toArray();
                if (tooltip.indexOf("__PROJECT__") >= 0) {
                    if (projects.length > 0) {
                        String pname = projects[0].getName();
                        if (projects.length > 1) {
                            pname = String.valueOf(pname) + Messages.CommanderView_8;
                        }
                        tooltip = tooltip.replaceFirst("__PROJECT__", pname);
                    } else {
                        tooltip = Messages.CommanderView_1;
                        enable = false;
                    }
                }
                if (tooltip.indexOf("__LAUNCHCONFIG__") >= 0) {
                    if (projects.length > 0) {
                        boolean[] multiple = new boolean[1];
                        ILaunchConfiguration lconfig = BaseLaunchConfigContextHandler.getLaunchConfiguration(BaseLaunchConfigContextHandler.getDebugLaunchGroup(), projects[0], this.fContextMgr.getActiveSelection(), false, multiple);
                        tooltip = lconfig != null ? tooltip.replaceFirst("__LAUNCHCONFIG__", lconfig.getName()) : (multiple[0] ? tooltip.replaceFirst("__LAUNCHCONFIG__", "TBD") : String.valueOf(Messages.CommanderView_2) + projects[0].getName());
                    } else {
                        tooltip = Messages.CommanderView_3;
                        enable = false;
                    }
                }
                if (tooltip.indexOf("__KEYBINDING__") >= 0 && entry.cmd.keyBinding != '\u0000') {
                    tooltip = tooltip.replaceFirst("__KEYBINDING__", "ALT+B," + entry.cmd.keyBinding);
                }
                final boolean[] enableA = new boolean[1];
                SafeRunner.run((ISafeRunnable)new SafeRunnable(){

                    public void run() throws Exception {
                        enableA[0] = entry.cmd.handler.isEnabled(CommanderView.this.fContextMgr.createContext(entry.cmd));
                    }
                });
                enable = enableA[0];
                entry.link.setToolTipText(tooltip);
                entry.link.setEnabled(enable);
                if (entry.imglink == null) continue;
                entry.imglink.setEnabled(enable);
            }
        }
        catch (Exception e) {
            Activator.log(e);
        }
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        IPartService partService = (IPartService)site.getService(IPartService.class);
        partService.addPartListener(this.fPartListener);
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener(this.fLaunchConfigListener);
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener(this.fLaunchesListener);
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "com.freescale.s32ds.cdt.core.commanderview");
        String pref = prefStore.getString(PREF_COLLAPSED_GROUPS);
        String[] stringArray = pref.split(",");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            if (!id.isEmpty()) {
                this.fCollapsedGroups.add(id);
            }
            ++n2;
        }
        this.fContextMgr = ContextManager.getManager(site.getWorkbenchWindow());
        this.fContextMgr.setView(this);
    }

    public void dispose() {
        IPartService partService = (IPartService)this.getSite().getService(IPartService.class);
        partService.removePartListener(this.fPartListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener(this.fLaunchConfigListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener(this.fLaunchesListener);
        StringBuilder pref = new StringBuilder();
        for (String id : this.fCollapsedGroups) {
            pref.append(String.valueOf(id) + ',');
        }
        ScopedPreferenceStore prefStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, Activator.getDefault().getBundle().getSymbolicName());
        prefStore.setValue(PREF_COLLAPSED_GROUPS, pref.toString());
        super.dispose();
    }

    private Section newSection(int column, String title, final String groupId, int gridColumnCount) {
        Section section = this.fToolkit.createSection(this.fCmdComposites[column], 578);
        section.setText(title);
        Composite client = this.fToolkit.createComposite((Composite)section);
        section.setClient((Control)client);
        if (this.fCollapsedGroups.contains(groupId)) {
            section.setExpanded(false);
        }
        GridLayout gridLayout = new GridLayout(gridColumnCount, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        client.setLayout((Layout)gridLayout);
        section.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                if (e.getState()) {
                    CommanderView.this.fCollapsedGroups.remove(groupId);
                } else {
                    CommanderView.this.fCollapsedGroups.add(groupId);
                }
                CommanderView.this.rebuildContent(CommanderView.this.fCurrentSectionsDistribution);
                CommanderView.this.layout();
            }
        });
        return section;
    }

    private void newCommand(Section section, final CommandManager.Command cmd) {
        Composite client = (Composite)section.getClient();
        int columnCount = ((GridLayout)client.getLayout()).numColumns;
        ImageHyperlink imglink = this.fToolkit.createImageHyperlink((Composite)section.getClient(), 0);
        CommandManager cmdManager = CommandManager.getInstance();
        int childCount = 0;
        CommandManager.Command[] commandArray = cmd.children;
        int n = cmd.children.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Command child = commandArray[n2];
            if (cmdManager.isVisible(child)) {
                ++childCount;
            }
            ++n2;
        }
        GridData gridData = new GridData();
        gridData.horizontalSpan = columnCount - childCount - 1;
        imglink.setImage(cmd.getIcon());
        Hyperlink link = this.fToolkit.createHyperlink((Composite)section.getClient(), cmd.label, 0);
        link.setData("org.eclipse.swtbot.widget.key", (Object)cmd.label);
        link.setUnderlined(false);
        link.setLayoutData((Object)gridData);
        HyperlinkAdapter listener = new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (cmd.handler != null) {
                    cmd.handler.execute(CommanderView.this.fContextMgr.createContext(cmd));
                }
            }
        };
        imglink.addHyperlinkListener((IHyperlinkListener)listener);
        link.addHyperlinkListener((IHyperlinkListener)listener);
        link.setToolTipText(cmd.tooltip);
        this.fLinkEntries.add(new HyperlinkEntry(link, imglink, cmd));
        CommandManager.Command[] commandArray2 = cmd.children;
        int n3 = cmd.children.length;
        int n4 = 0;
        while (n4 < n3) {
            final CommandManager.Command child = commandArray2[n4];
            if (cmdManager.isVisible(child)) {
                Hyperlink childLink = this.fToolkit.createHyperlink((Composite)section.getClient(), child.label, 0);
                childLink.setData("org.eclipse.swtbot.widget.key", (Object)(String.valueOf(cmd.label) + "." + child.label));
                childLink.setUnderlined(false);
                childLink.setLayoutData((Object)new GridData());
                listener = new HyperlinkAdapter(){

                    public void linkActivated(HyperlinkEvent e) {
                        if (child.handler != null) {
                            child.handler.execute(CommanderView.this.fContextMgr.createContext(child));
                        }
                    }
                };
                childLink.addHyperlinkListener((IHyperlinkListener)listener);
                childLink.setToolTipText(cmd.children[0].tooltip);
                this.fLinkEntries.add(new HyperlinkEntry(childLink, null, cmd.children[0]));
            }
            ++n4;
        }
    }

    public void createPartControl(Composite parent) {
        this.fParentComp = new Composite(parent, 0);
        this.setTitleToolTip(Messages.CommanderView_title);
        GridLayout gridLayout = this.newTightGridLayout();
        this.fParentComp.setLayout((Layout)gridLayout);
        this.fToolkit = new FormToolkit(parent.getDisplay());
        this.rebuildContent(null);
        this.fResizeListener = new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CommanderView.this.layout();
            }
        };
        parent.addControlListener((ControlListener)this.fResizeListener);
    }

    void rebuildContent(Integer[] sectionsDistribution) {
        if (this.fStatus == null) {
            this.fStatus = new Composite(this.fParentComp, 0);
            GridData gridData = new GridData();
            gridData.exclude = !this.fPinned;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            this.fStatus.setLayoutData((Object)gridData);
            FillLayout fillLayout = new FillLayout();
            fillLayout.marginWidth = 5;
            this.fStatus.setLayout((Layout)fillLayout);
            this.fLabel = new Label(this.fStatus, 131072);
            FontData fontData = this.fLabel.getFont().getFontData()[0];
            Font font = new Font((Device)this.fLabel.getDisplay(), new FontData(fontData.getName(), fontData.getHeight(), 2));
            this.fLabel.setFont(font);
            this.fStatus.setVisible(this.fPinned);
        }
        CommandManager cmdManager = CommandManager.getInstance();
        if (sectionsDistribution == null) {
            int count = 0;
            CommandManager.Group[] groupArray = cmdManager.getGroups();
            int n = groupArray.length;
            int font = 0;
            while (font < n) {
                CommandManager.Group group = groupArray[font];
                if (cmdManager.hasVisibleCommands(group)) {
                    ++count;
                }
                ++font;
            }
            sectionsDistribution = new Integer[]{count};
        }
        if (this.fForm != null) {
            this.fForm.dispose();
        }
        this.fSections.clear();
        this.fLinkEntries.clear();
        this.fForm = this.fToolkit.createScrolledForm(this.fParentComp);
        this.fForm.setLayoutData((Object)new GridData(4, 4, true, true));
        Composite formComp = this.fForm.getBody();
        GridLayout gridLayout = this.newTightGridLayout();
        formComp.setLayout((Layout)gridLayout);
        this.fLabel.setBackground(formComp.getBackground());
        this.fStatus.setBackground(formComp.getBackground());
        this.fCmdCompositeParent = this.fToolkit.createComposite(formComp);
        GridData gridData = new GridData(4, 4, true, true);
        this.fCmdCompositeParent.setLayoutData((Object)gridData);
        gridLayout = new GridLayout(sectionsDistribution.length, false);
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.fCmdCompositeParent.setLayout((Layout)gridLayout);
        this.fCmdComposites = new Composite[sectionsDistribution.length];
        int i = 0;
        while (i < sectionsDistribution.length) {
            Composite cmdComposite = this.fToolkit.createComposite(this.fCmdCompositeParent);
            gridData = new GridData(4, 4, false, true);
            cmdComposite.setLayoutData((Object)gridData);
            cmdComposite.setLayout((Layout)new GridLayout());
            this.fCmdComposites[i] = cmdComposite;
            ++i;
        }
        CommandManager.Group[] groupArray = cmdManager.getGroups();
        int n = groupArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommandManager.Group group = groupArray[n2];
            if (cmdManager.hasVisibleCommands(group)) {
                int column = 0;
                int sum = 0;
                Integer[] integerArray = sectionsDistribution;
                int n3 = sectionsDistribution.length;
                int n4 = 0;
                while (n4 < n3) {
                    int dist = integerArray[n4];
                    if (this.fSections.size() < (sum += dist)) break;
                    ++column;
                    ++n4;
                }
                assert (column < sectionsDistribution.length);
                int gridColumnCount = 2;
                CommandManager.Command[] commandArray = group.children;
                int n5 = group.children.length;
                n3 = 0;
                while (n3 < n5) {
                    CommandManager.Command cmd = commandArray[n3];
                    CommandManager.Command[] commandArray2 = cmd.children;
                    int n6 = cmd.children.length;
                    int n7 = 0;
                    while (n7 < n6) {
                        CommandManager.Command subCmd = commandArray2[n7];
                        if (cmdManager.isVisible(subCmd)) {
                            ++gridColumnCount;
                        }
                        ++n7;
                    }
                    ++n3;
                }
                Section section = this.newSection(column, group.label, group.id, gridColumnCount);
                CommandManager.Command[] commandArray3 = group.children;
                int n8 = group.children.length;
                n5 = 0;
                while (n5 < n8) {
                    CommandManager.Command cmd = commandArray3[n5];
                    if (cmdManager.isVisible(cmd)) {
                        this.newCommand(section, cmd);
                    }
                    ++n5;
                }
                this.fSections.add(section);
            }
            ++n2;
        }
        this.fParentComp.layout(true, true);
        this.fCurrentSectionsDistribution = Arrays.copyOf(sectionsDistribution, sectionsDistribution.length);
        this.updateCmdLinks();
        if (this.fContextMgr.isPinned()) {
            this.showPinned();
        } else {
            this.showUnpinned();
        }
    }

    public void setFocus() {
        this.fForm.setFocus();
    }

    void showPinned() {
        IProject[] projects = this.fContextMgr.getActiveProjects().toArray();
        String pname = projects[0].getName();
        if (projects.length > 1) {
            pname = String.valueOf(pname) + Messages.CommanderView_8;
        }
        String status = String.valueOf(Messages.CommanderView_5) + pname;
        this.fLabel.setText(status);
        ((GridData)this.fStatus.getLayoutData()).exclude = false;
        this.fStatus.setVisible(true);
        this.fStatus.getParent().layout(true);
        this.layout();
    }

    void showUnpinned() {
        ((GridData)this.fStatus.getLayoutData()).exclude = true;
        this.fStatus.setVisible(false);
        this.fStatus.getParent().layout(true);
        this.updateCmdLinksUI();
        this.layout();
    }

    public void layout() {
        int sum;
        Point totalSize = this.fParentComp.getParent().getSize();
        int totalWidth = totalSize.x - 10;
        int totalHeight = totalSize.y - 25;
        if (this.fPinned) {
            totalHeight -= this.fStatus.getSize().y;
        }
        if (totalWidth <= 0 || totalHeight <= 0) {
            return;
        }
        ArrayList<Integer> distribution = new ArrayList<Integer>(5);
        int nextColumnSectionIndex = 0;
        do {
            sum = 0;
            int i = nextColumnSectionIndex;
            while (i < this.fSections.size()) {
                Section section = this.fSections.get(i);
                sum += section.getSize().y;
                ++i;
            }
            int lastSectOnLeft = -1;
            sum = 0;
            int i2 = nextColumnSectionIndex;
            while (i2 < this.fSections.size()) {
                Section section = this.fSections.get(i2);
                if ((sum += section.getSize().y) > totalHeight) {
                    if (lastSectOnLeft >= 0) break;
                    lastSectOnLeft = 0;
                    break;
                }
                ++lastSectOnLeft;
                ++i2;
            }
            int sectionsOnLeft = lastSectOnLeft + 1;
            distribution.add(sectionsOnLeft);
            nextColumnSectionIndex += sectionsOnLeft;
        } while (sum > totalHeight);
        Object[] distArray = distribution.toArray(new Integer[distribution.size()]);
        if (!Arrays.equals(distArray, (Object[])this.fCurrentSectionsDistribution)) {
            this.rebuildContent((Integer[])distArray);
        }
    }

    private GridLayout newTightGridLayout() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        return gridLayout;
    }

    void contextChanged() {
        this.updateCmdLinksUI();
    }

    private static class HyperlinkEntry {
        Hyperlink link;
        ImageHyperlink imglink;
        CommandManager.Command cmd;

        public HyperlinkEntry(Hyperlink link, ImageHyperlink imglink, CommandManager.Command cmd) {
            this.link = link;
            this.imglink = imglink;
            this.cmd = cmd;
        }
    }
}

