/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cdt.core.internal.commanderview.view;

import com.freescale.s32ds.cdt.core.internal.commanderview.Activator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class ProjectSet {
    private static final char PROJECT_NAME_DELIMITER = ';';
    private final Set<IProject> projects = new HashSet<IProject>();

    public IProject[] toArray() {
        return this.projects.toArray(new IProject[this.projects.size()]);
    }

    public void fromString(String projectNames) {
        this.projects.clear();
        if (projectNames.isEmpty()) {
            return;
        }
        String[] names = projectNames.split(";");
        IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            IProject project = wsRoot.getProject(name);
            if (project.exists()) {
                this.projects.add(project);
            } else {
                Activator.log((IStatus)new Status(2, "com.freescale.s32ds.cdt.core.commanderview", "Can't restore pinned project: " + name));
            }
            ++n2;
        }
    }

    public String asString() {
        StringBuilder sb = new StringBuilder();
        for (IProject project : this.projects) {
            if (sb.length() > 0) {
                sb.append(';');
            }
            sb.append(project.getName());
        }
        return sb.toString();
    }

    public IProject getOne() {
        if (this.projects.isEmpty()) {
            return null;
        }
        return this.projects.iterator().next();
    }

    public boolean contains(IProject project) {
        return this.projects.contains(project);
    }

    public boolean isEmpty() {
        return this.projects.isEmpty();
    }

    public void set(IProject ... newProjects) {
        this.projects.clear();
        this.projects.addAll(Arrays.asList(newProjects));
    }

    public boolean same(IProject[] projectsSave) {
        if (this.projects.size() != projectsSave.length) {
            return false;
        }
        IProject[] iProjectArray = projectsSave;
        int n = projectsSave.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (!this.projects.contains(project)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

