/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.debug.internal.lauterbach;

import com.nxp.s32ds.cle.ide.debugger.registry.LaunchConfigurationCreator;
import com.nxp.s32ds.cle.ide.launch.core.LaunchConfigurationUtil;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;

public class LauterbachT32LaunchConfigurationCreator
implements LaunchConfigurationCreator {
    private static final String T32_LAUNCH_CONFIGURATION_TYPE_ID = "com.lauterbach.trace32.debug.internal.core.T32LaunchConfigurationDelegate";
    private static final String T32_ATTRIBUTE_CPROJECT = "com.lauterbach.trace32.debug.t32.CPROJECT";

    public ILaunchConfigurationWorkingCopy createLaunchConfigurationWorkingCopy(Map<String, Object> params) throws CoreException {
        String component;
        IResource launchResource;
        ILaunchConfigurationType debugerLaunchType = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(T32_LAUNCH_CONFIGURATION_TYPE_ID);
        if (debugerLaunchType == null) {
            IStatus errorStatus = LaunchConfigurationUtil.getUndefinedLaunchConfigurationTypeErrorStatus();
            throw new CoreException(errorStatus);
        }
        IProject project = LaunchConfigurationUtil.extractProject(params);
        IFolder container = project.getFolder("Project_Settings/Debugger");
        if (container == null || !container.isAccessible()) {
            container = project;
        }
        if ((launchResource = container.findMember(String.valueOf(component = LaunchConfigurationUtil.extractComponent(params)) + ".launch")) != null && launchResource.isAccessible()) {
            IStatus errorStatus = LaunchConfigurationUtil.getLaunchConfigurationExistsErrorStatus();
            throw new CoreException(errorStatus);
        }
        ILaunchConfigurationWorkingCopy workingCopy = debugerLaunchType.newInstance((IContainer)container, component);
        this.setupLaunchConfigurationWorkingCopy(workingCopy, params);
        return workingCopy;
    }

    public void setupLaunchConfigurationWorkingCopy(ILaunchConfigurationWorkingCopy workingCopy, Map<String, Object> params) throws CoreException {
        IProject project = LaunchConfigurationUtil.extractProject(params);
        workingCopy.setAttribute(T32_ATTRIBUTE_CPROJECT, project.getName());
        String buildArtifact = LaunchConfigurationUtil.extractProjectExecutable(params);
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", project.getName());
        workingCopy.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", buildArtifact);
    }
}

