/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core;

import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentListenerManager;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventBuilder;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.implementation.SoftwareManagerFactory;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPayload;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerVariable;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.core.variables.VariablesPlugin;

public class SoftwareManagerJobChangeListener
implements IJobChangeListener {
    private final SoftwareManagerPayload payload;

    public SoftwareManagerJobChangeListener(SoftwareManagerPayload payload) {
        if (payload == null) {
            throw new IllegalArgumentException();
        }
        this.payload = payload;
    }

    public void aboutToRun(IJobChangeEvent event) {
    }

    public void awake(IJobChangeEvent event) {
    }

    public void done(IJobChangeEvent event) {
        Set<String> varsNames = this.payload.getMissedSoftwareManagerDescriptors().stream().flatMap(descr -> descr.getVariables().stream()).map(var -> var.getName()).collect(Collectors.toSet());
        this.removeMissedVars(varsNames);
        this.resolveVariablies();
        ComponentChangeEvent changeEvent = this.createComponentChangeEvent();
        if (changeEvent != null) {
            ComponentListenerManager.INSTANCE.notifyComponentChange(changeEvent);
        }
        ComponentListenerManager.INSTANCE.notifyComponentChange(this.createFinishEvent());
    }

    private void removeMissedVars(Set<String> varsName) {
        IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
        HashSet<IValueVariable> varsToRemove = new HashSet<IValueVariable>();
        IValueVariable[] iValueVariableArray = variableManager.getValueVariables();
        int n = iValueVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            IValueVariable variable = iValueVariableArray[n2];
            if (varsName.contains(variable.getName())) {
                varsToRemove.add(variable);
            }
            ++n2;
        }
        IValueVariable[] varsArr = new IValueVariable[varsToRemove.size()];
        varsArr = varsToRemove.toArray(varsArr);
        variableManager.removeVariables(varsArr);
    }

    private void resolveVariablies() {
        HashSet<SoftwareManagerVariable> collect = new HashSet<SoftwareManagerVariable>();
        for (SoftwareManagerPackageDescriptor packageDescriptor : this.payload.getCurrentSoftwareManagerDescriptors()) {
            for (SoftwareManagerVariable managerVariable : packageDescriptor.getVariables()) {
                if (collect.add(managerVariable)) continue;
                SoftwareManagerActivator.getInstance().logWarning(SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJobChangeListener_DuplicateNameOfVariable, (Object)managerVariable.getName()));
            }
        }
        if (!collect.isEmpty()) {
            collect.forEach(var -> SoftwareManagerFactory.processVariableByType(var.getName(), var.getValue(), var.getType()));
        }
    }

    public void running(IJobChangeEvent event) {
    }

    public void scheduled(IJobChangeEvent event) {
    }

    public void sleeping(IJobChangeEvent event) {
    }

    private ComponentChangeEvent createComponentChangeEvent() {
        return ComponentChangeEventBuilder.builder().archetypeId("software_package_eventevent appeared").payload((Object)this.payload).build();
    }

    private ComponentChangeEvent createFinishEvent() {
        return ComponentChangeEventBuilder.builder().archetypeId("software_package_loading_finished").build();
    }
}

