/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.connection.DebuggerUsbConnectionInterface;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessorLinuxImpl;
import com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap.S32DebuggerTapUsbDeviceAccessorWindowsImpl;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;

public class S32DebuggerTapUsbDeviceAccessor
implements DebuggerConnectionAccessor {
    static final String S32DEBUGGER_VIRTUAL_IP_PREFIX = "s32dbg:";
    static final String VID = "15A2";
    static final String PID = "0067";
    private DebuggerUsbConnectionInterface usbConnectionImpl = null;

    public S32DebuggerTapUsbDeviceAccessor() {
        if ("win32".equals(Platform.getOS())) {
            this.usbConnectionImpl = new S32DebuggerTapUsbDeviceAccessorWindowsImpl();
        }
        if ("linux".equals(Platform.getOS())) {
            this.usbConnectionImpl = new S32DebuggerTapUsbDeviceAccessorLinuxImpl();
        }
    }

    public Collection<DeviceConnection> getActiveDeviceConnections(DebuggerConnectionDescriptor connectionDescriptor) {
        if (connectionDescriptor == null || this.usbConnectionImpl == null) {
            return Collections.emptySet();
        }
        return this.usbConnectionImpl.getConnectedDevices(connectionDescriptor, VID, PID);
    }

    public String getConnectionString(DebuggerConnectionDescriptor connectionDescriptor, DeviceConnection connectionData) {
        if (this.usbConnectionImpl == null) {
            return null;
        }
        return this.usbConnectionImpl.getConnectionString(connectionDescriptor, connectionData);
    }

    public String getBaseSpeed() {
        return "";
    }
}

