/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.core.internal.usb.devices.s32debugger.tap;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import com.nxp.s32ds.debug.ide.core.connection.WindowsDebuggerUsbConnection;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class S32DebuggerTapUsbDeviceAccessorWindowsImpl
extends WindowsDebuggerUsbConnection {
    private static final String SERVICE_USB_RNDIS = "RNDIS";
    private static final String IPCONFIG_ALL_CMD = "ipconfig /all\n";
    private static final Pattern DHCP_SERVER = Pattern.compile("(.*DHCP.*) : (.*)");

    public Collection<DeviceConnection> getConnectedDevices(DebuggerConnectionDescriptor deviceDescriptor, String vid, String pid) {
        String deviceVidPid = String.format("VID_%s&PID_%s", vid, pid);
        List usbCCGPDevices = this.runProcessForOutput(REQUEST_TO_WINDOWS_REGISTRY_USBCCGP_SERVICE);
        Collection<String> devicesIDs = this.retrieveDeviceStrings(usbCCGPDevices, deviceVidPid);
        if (devicesIDs.isEmpty()) {
            return Collections.emptyList();
        }
        Map<String, String> containerIDToDevice = this.retrieveDeviceContainerIDs(devicesIDs, deviceVidPid);
        Map<String, String> enumeratorPaths = this.createSystemEnumeratorQualifiersForActiveDevices(devicesIDs, containerIDToDevice, deviceVidPid);
        return this.createDeviceConnections(enumeratorPaths, containerIDToDevice, deviceVidPid, deviceDescriptor.getConnectionName());
    }

    public String getConnectionString(DebuggerConnectionDescriptor deviceDescriptor, DeviceConnection connectionData) {
        List result = this.runProcessForOutput(IPCONFIG_ALL_CMD);
        boolean deviceConnectionFound = false;
        for (String line : result) {
            String virtualIp;
            if (!deviceConnectionFound) {
                if (!line.endsWith(connectionData.getDeviceConnectionData())) continue;
                deviceConnectionFound = true;
                continue;
            }
            if (line.isEmpty()) {
                return "";
            }
            Matcher dhcp = DHCP_SERVER.matcher(line);
            if (!dhcp.matches() || !DebuggerUtils.validateIp((String)(virtualIp = dhcp.group(2)))) continue;
            return "s32dbg:" + virtualIp;
        }
        return null;
    }

    private Collection<String> retrieveDeviceStrings(Collection<String> activeDevices, String vidPid) {
        HashSet<String> devicesStrings = new HashSet<String>();
        for (String line : activeDevices) {
            int vidPidIndex = line.lastIndexOf(vidPid);
            if (vidPidIndex == -1) continue;
            String deviceIdStr = line.substring(vidPidIndex + 1 + vidPid.length());
            devicesStrings.add(deviceIdStr);
        }
        return devicesStrings;
    }

    private Map<String, String> retrieveDeviceContainerIDs(Collection<String> devicesIDs, String vidPid) {
        HashMap<String, String> containerToDevice = new HashMap<String, String>();
        block0: for (String deviceId : devicesIDs) {
            String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_CONTAINER_ID, vidPid, deviceId);
            List result = this.runProcessForOutput(request);
            for (String line : result) {
                if (!line.contains("ContainerID")) continue;
                String containerId = line.substring(line.indexOf(123));
                containerToDevice.put(containerId, deviceId);
                continue block0;
            }
        }
        return containerToDevice;
    }

    private Map<String, String> createSystemEnumeratorQualifiersForActiveDevices(Collection<String> devicesIDs, Map<String, String> containerIDToDevice, String vidPid) {
        HashMap<String, String> qualifiers = new HashMap<String, String>();
        String request = String.format(REQUEST_TO_WINDOWS_REGISTRY_USB_DEVICES, String.format("%s&MI_00", vidPid));
        List devicesChildren = this.runProcessForOutput(request);
        block0: for (String childDevice : devicesChildren) {
            if (childDevice.isEmpty() || childDevice.lastIndexOf(92) == -1) continue;
            childDevice = childDevice.substring(childDevice.lastIndexOf(92) + 1);
            String childRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY_CONTAINER_ID, String.format("%s&MI_00", vidPid), childDevice);
            List result = this.runProcessForOutput(childRequest);
            for (String line : result) {
                if (!line.contains("ContainerID")) continue;
                String containerId = line.substring(line.indexOf(123));
                String deviceByContainer = containerIDToDevice.get(containerId);
                if (deviceByContainer == null) continue block0;
                for (String deviceId : devicesIDs) {
                    if (!deviceId.equals(deviceByContainer)) continue;
                    qualifiers.put(containerId, childDevice);
                    continue block0;
                }
                continue block0;
            }
        }
        return qualifiers;
    }

    private Collection<DeviceConnection> createDeviceConnections(Map<String, String> containerIDToQualifier, Map<String, String> containerIDToDevice, String vidPid, String deviceName) {
        HashSet<DeviceConnection> deviceConnections = new HashSet<DeviceConnection>();
        block0: for (String containerID : containerIDToQualifier.keySet()) {
            String deviceDescRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY_DEVICE_DESC, vidPid, containerIDToDevice.get(containerID));
            List deviceDescResult = this.runProcessForOutput(deviceDescRequest);
            String rootDeviceDescription = this.getDeviceDescription(deviceDescResult);
            if (rootDeviceDescription.isEmpty()) continue;
            String serviceRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY_SERVICE, String.format("%s&MI_00", vidPid), containerIDToQualifier.get(containerID));
            List serviceResult = this.runProcessForOutput(serviceRequest);
            for (String resultLine : serviceResult) {
                String deviceDescServiceRequest;
                List deviceDescServiceResult;
                String enumeratorDeviceDescription;
                if (!resultLine.contains(SERVICE_USB_RNDIS) && !resultLine.contains(SERVICE_USB_RNDIS.toLowerCase()) || (enumeratorDeviceDescription = this.getDeviceFriendlyName(deviceDescServiceResult = this.runProcessForOutput(deviceDescServiceRequest = String.format(REQUEST_TO_WINDOWS_REGISTRY_FRIENDLY_NAME, String.format("%s&MI_00", vidPid), containerIDToQualifier.get(containerID))))).isEmpty()) continue;
                DeviceConnection device = new DeviceConnection(deviceName, false);
                device.setDeviceConnectionData(enumeratorDeviceDescription);
                device.setDeviceUiFriendlyName(NLS.bind((String)Messages.Debugger_connection_ui_pattern, (Object)containerIDToDevice.get(containerID), (Object)rootDeviceDescription));
                deviceConnections.add(device);
                continue block0;
            }
        }
        return deviceConnections;
    }

    private String getDeviceDescription(List<String> processResult) {
        String deviceDescription = "";
        for (String line : processResult) {
            if (!line.contains("DeviceDesc")) continue;
            int symbolIndex = line.lastIndexOf(59);
            deviceDescription = line.substring(symbolIndex + 1);
            break;
        }
        return deviceDescription;
    }

    private String getDeviceFriendlyName(List<String> processResult) {
        String deviceDescription = "";
        for (String line : processResult) {
            if (!line.contains("FriendlyName")) continue;
            int symbolIndex = line.lastIndexOf("    ");
            deviceDescription = line.substring(symbolIndex + 4);
            break;
        }
        return deviceDescription;
    }
}

