/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.validation.ui;

import com.nxp.s32ds.cle.cdt.ui.internal.CdtUiActivator;
import com.nxp.s32ds.cle.cdt.validation.internal.ui.Messages;
import com.nxp.s32ds.cle.ide.migration.ui.MigrationsUI;
import com.nxp.s32ds.cle.runtime.migration.sequence.MigrationSequenceDescriptor;
import com.nxp.s32ds.ext.ide.validation.core.ToolChainVersionValidationMarker;
import java.util.HashSet;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMarkerResolution2;
import org.eclipse.ui.PlatformUI;

public class ToolChainVersionUpdateQuickFix
implements IMarkerResolution2 {
    private final MigrationSequenceDescriptor migrationSequenceDescriptor;
    private final IMarker selectedMarker;

    public ToolChainVersionUpdateQuickFix(IMarker marker, MigrationSequenceDescriptor migrationSequenceDescriptor) {
        this.selectedMarker = marker;
        this.migrationSequenceDescriptor = migrationSequenceDescriptor;
    }

    public String getDescription() {
        return Messages.ToolChainVersionUpdateQuickFix_description_message;
    }

    public Image getImage() {
        return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_BACK");
    }

    public String getLabel() {
        return this.migrationSequenceDescriptor.getName();
    }

    public void run(IMarker marker) {
        IProject project = (IProject)this.selectedMarker.getResource();
        boolean isMigrated = MigrationsUI.migrate((IProject)project, (MigrationSequenceDescriptor)this.migrationSequenceDescriptor);
        if (isMigrated) {
            MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)Messages.ToolChainVersionUpdateDialog_title_message, (String)Messages.ToolChainVersionUpdateDialog_migration_succeed_status_message);
            ToolChainVersionValidationMarker.delete((IProject)project);
        }
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> colMarkers = new HashSet<IMarker>();
        IProject selectedProject = this.selectedMarker.getResource().getProject();
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker it = iMarkerArray[n2];
            try {
                if (it.exists() && !it.equals((Object)this.selectedMarker) && it.isSubtypeOf("com.nxp.s32ds.ext.ide.validation.core.toolchain.version.validation.marker") && selectedProject.equals((Object)it.getResource().getProject())) {
                    colMarkers.add(it);
                }
            }
            catch (CoreException ex) {
                CdtUiActivator.getInstance().logError("An exception was thrown during marker type verification process", ex);
            }
            ++n2;
        }
        return colMarkers.toArray(new IMarker[colMarkers.size()]);
    }
}

