/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.cle.runtime.debugger.registry.core.DebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.CoreDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.debugger.core.DeviceDebuggerDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashAlgorithmDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FlashProtocolDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FlashDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.ui.tree.HardwareContentProvider;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatcher;
import com.nxp.s32ds.cle.runtime.storage.sensitive.info.StorageDispatchers;
import com.nxp.s32ds.debug.ide.core.AttributeReadingUtils;
import com.nxp.s32ds.debug.ide.core.DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.core.S32DebuggerErrorStatuses;
import com.nxp.s32ds.debug.ide.core.connection.Messages;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerErrorMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.core.S32DebuggerFlashProgrammerCoreActivator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.S32DebuggerFlashProgrammerTabMessages;
import com.nxp.s32ds.debug.ide.s32debugger.flash.internal.ui.dialogs.HardwareContentProviderDeviceFilter;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerAttributesValidator;
import com.nxp.s32ds.debug.ide.s32debugger.flash.validation.S32DebuggerFlashProgrammerParams;
import com.nxp.s32ds.debug.ide.ui.DebuggerTabMessages;
import com.nxp.s32ds.debug.ide.ui.ErrorMessages;
import com.nxp.s32ds.debug.ide.ui.S32DebuggerHardwareDialog;
import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.ext.jfx.ui.FxFileDialog;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandlers;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.eclipse.cdt.debug.gdbjtag.ui.GDBJtagImages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class S32DebuggerFlashProgrammerTab
extends AbstractLaunchConfigurationTab {
    private static final int SERVER_PORT_NUMBER_HORIZONTAL_INDENT = 15;
    private static final String TAB_NAME = "Debugger";
    private Group hardware;
    private Text txtDevice;
    private Text txtInitScript;
    private Combo cmbFlashName;
    private Combo cmbFlashType;
    private Group debugProbeConnection;
    private Combo cmbDebugInterface;
    private Combo cmbUSBDevice;
    private Button btnRefresh;
    private Button btnTestConnection;
    private Text txtHostNameOrIp;
    private Group targetCommunicationSpeed;
    private Text txtJtagSpeed;
    private Text txtRemoteTimeout;
    private Button btnResetAndDelay;
    private Text txtDelay;
    private Group gdbServer;
    private Button btnLaunchServer;
    private Text txtServerPort;
    private Button btnEnableLog;
    private Group gdbClient;
    private Button btnClientSelection;
    private Text txtClientExecutable;
    private Text txtClientCommands;
    private Group secureDebugger;
    private Button btnEnableSecureDebugging;
    private Combo cmbSecureType;
    private Button btnResetDataStored;
    private static final int COMBOS_WIDTH_HINT = 550;
    private static final int TEXT_NEAR_COMBOS_WIDTH_HINT = 564;
    private static final int LEFT_COLUMN_WIDTH = 120;
    private static final int TEXT_TARGET_WIDTH = 50;
    private static final int TEXT_COMMANDS_HEIGHT = 60;
    private static final int TEXT_SPEED_HORIZONTAL_INDENT = 25;
    private String launchConfigurationName;
    private String deviceId;
    private String deviceRevision;
    private DeviceConnection[] activeConnections;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.createHardwareGroup(composite, 120);
        this.createDebugProbeConnectionGroup(composite, 120);
        this.createTargetCommunicationSpeedGroup(composite, 120);
        this.createGdbServerGroup(composite, 120);
        this.createGdbClientGroup(composite, 120);
        this.createSecureDebuggingGroup(composite, 120);
        this.launchConfigurationName = "";
    }

    private void createHardwareGroup(Composite parent, int leftLabelsWidth) {
        this.hardware = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_hardware_group);
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_device_label, (int)leftLabelsWidth);
        this.txtDevice = SWTUtils.createTextWithWidthHint((Composite)this.hardware, (int)2052, (int)564, (int)1);
        this.txtDevice.setEditable(false);
        this.txtDevice.setEnabled(false);
        this.txtDevice.setText(DebuggerTabMessages.DebuggerTab_not_specified_label);
        Button selectDevice = SWTUtils.createButtonWithHorizontalSpan((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_select_device_button, (int)0, (int)2);
        SWTUtils.createLabel((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_initialization_script_label);
        this.txtInitScript = SWTUtils.createTextWithWidthHint((Composite)this.hardware, (int)2052, (int)564, (int)1);
        this.txtInitScript.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        selectDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerHardwareDialog dialog = new S32DebuggerHardwareDialog(S32DebuggerFlashProgrammerTab.this.getShell(), (HardwareContentProvider)new HardwareContentProviderDeviceFilter("s32debuggerflashprogrammer"), DebuggerTabMessages.DebuggerTab_select_target_device_and_core_dialog);
                if (dialog.open() != 0) {
                    return;
                }
                EntityDescriptor selectedDescriptor = dialog.getDescriptor();
                if (selectedDescriptor == null || !(selectedDescriptor instanceof DeviceDescriptor)) {
                    S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(ErrorMessages.S32DebuggerHWDialog_unexpected_null_result_error_message);
                    return;
                }
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)selectedDescriptor;
                S32DebuggerFlashProgrammerTab.this.deviceRevision = dialog.getDeviceRevision();
                S32DebuggerFlashProgrammerTab.this.deviceId = deviceDescriptor.getId();
                String initScript = DeviceDebuggerDescriptors.getInitializationScriptPath((String)S32DebuggerFlashProgrammerTab.this.deviceId, (String)"s32debuggerflashprogrammer");
                if (initScript.isEmpty()) {
                    initScript = DebuggerDescriptors.getDeviceDebuggerConfigurationScript((String)"s32debuggerflashprogrammer", (String)S32DebuggerFlashProgrammerTab.this.deviceId);
                }
                S32DebuggerFlashProgrammerTab.this.txtInitScript.setText(initScript);
                S32DebuggerFlashProgrammerTab.this.setDefaultFlashParameters(S32DebuggerFlashProgrammerTab.this.deviceId);
                S32DebuggerFlashProgrammerTab.this.btnClientSelection.setEnabled(!S32DebuggerFlashProgrammerTab.this.deviceId.isEmpty());
                S32DebuggerFlashProgrammerTab.this.setDeviceUINames(deviceDescriptor);
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
        Button browse = SWTUtils.createButton((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_initialization_script_title, S32DebuggerFlashProgrammerTab.this.txtInitScript);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.hardware, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.variablesButtonSelected(S32DebuggerFlashProgrammerTab.this.txtInitScript);
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_flash_name_label, (int)leftLabelsWidth);
        this.cmbFlashName = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.hardware, (int)8, (int)550, (int)3);
        this.cmbFlashName.addListener(13, event -> {
            Combo source = (Combo)event.widget;
            this.cmbFlashType.setItems(new String[0]);
            List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(this.deviceId);
            if (!descriptors.isEmpty()) {
                for (FlashAlgorithmDescriptor dsc : descriptors) {
                    if (!source.getText().equals(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName())) continue;
                    for (FlashProtocolDescriptor fDsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(dsc.getFlashId())) {
                        this.cmbFlashType.add(fDsc.getProtocolId());
                    }
                    if (this.cmbFlashType.getItemCount() <= 0) break;
                    this.cmbFlashType.select(0);
                    break;
                }
            }
            this.scheduleUpdateJob();
        });
        SWTUtils.createFixedWidthLabel((Composite)this.hardware, (String)S32DebuggerFlashProgrammerTabMessages.S32DebuggerFlashProgrammerTab_flash_type_label, (int)leftLabelsWidth);
        this.cmbFlashType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.hardware, (int)8, (int)550, (int)3);
    }

    private void createDebugProbeConnectionGroup(Composite parent, int leftLabelsWidth) {
        this.debugProbeConnection = SWTUtils.createGroup((Composite)parent, (int)4, (String)DebuggerTabMessages.DebuggerTab_debug_probe_connection_group);
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_interface_label, (int)leftLabelsWidth);
        this.cmbDebugInterface = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)550, (int)3);
        DebuggerConnections.getDebuggerConnectionDeviceDescriptors((String)"s32debugger").stream().sorted((d1, d2) -> d1.getPriority() - d2.getPriority()).forEach(descriptor -> this.cmbDebugInterface.add(descriptor.getConnectionName()));
        if (this.cmbDebugInterface.getItemCount() > 0) {
            this.cmbDebugInterface.select(0);
        }
        this.cmbDebugInterface.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.debugInterfaceChanged(S32DebuggerFlashProgrammerTab.this.cmbDebugInterface.getText());
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_usb_device, (int)leftLabelsWidth);
        this.cmbUSBDevice = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.debugProbeConnection, (int)8, (int)550, (int)1);
        this.cmbUSBDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.btnRefresh = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_refresh_button, (int)0, (int)1);
        this.btnRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DebuggerConnectionDescriptor devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)S32DebuggerFlashProgrammerTab.this.cmbDebugInterface.getText());
                String connectionId = devDescriptor.getConnectionName();
                DebuggerConnectionAccessor conAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
                if (conAccessor != null) {
                    S32DebuggerFlashProgrammerTab.this.updateUSBDevices(conAccessor, devDescriptor);
                    S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
                }
            }
        });
        this.btnTestConnection = SWTUtils.createButtonWithHorizontalSpan((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_test_connection_button, (int)0, (int)1);
        this.btnTestConnection.setEnabled(false);
        this.btnTestConnection.addListener(13, event -> {
            String connectionString = DebuggerUtils.getConnectionStringForDeviceConnection((String)this.getActiveConnectionData());
            try {
                RcpStatusHandlers.handleStatus((String)"com.nxp.s32ds.debug.ide.s32debugger.ui.testConnectionStatusHandler", (IStatus)new Status(1, S32DebuggerCoreActivator.getDefault().getBundleId(), ""), (Object)connectionString);
            }
            catch (CoreException coreException) {
                S32DebuggerCoreActivator.getDefault().logError(S32DebuggerErrorMessages.S32DebuggerCannotHandleStatusCall_message);
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.debugProbeConnection, (String)DebuggerTabMessages.DebuggerTab_hostname_or_ip_label, (int)leftLabelsWidth);
        this.txtHostNameOrIp = SWTUtils.createTextWithWidthHint((Composite)this.debugProbeConnection, (int)2048, (int)564, (int)2);
        this.txtHostNameOrIp.addListener(1, event -> {
            if (event.keyCode == 45 && this.txtHostNameOrIp.getText().contains(".")) {
                event.doit = false;
            }
            if (event.keyCode == 32) {
                event.doit = false;
            }
        });
        this.txtHostNameOrIp.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (S32DebuggerFlashProgrammerTab.this.activeConnections != null) {
                    S32DebuggerFlashProgrammerTab.this.activeConnections[0].setDeviceConnectionData(S32DebuggerFlashProgrammerTab.this.txtHostNameOrIp.getText());
                }
                S32DebuggerFlashProgrammerTab.this.btnTestConnection.setEnabled(DebuggerUtils.validateIpOrHost((String)S32DebuggerFlashProgrammerTab.this.txtHostNameOrIp.getText()));
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void debugInterfaceChanged(String selectedInterface) {
        DebuggerConnectionDescriptor devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)selectedInterface);
        boolean isUsbUsed = !devDescriptor.isEthernetConnection();
        String connectionId = devDescriptor.getConnectionName();
        DebuggerConnectionAccessor conAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
        this.cmbUSBDevice.setEnabled(isUsbUsed);
        this.btnRefresh.setEnabled(isUsbUsed);
        this.txtHostNameOrIp.setEnabled(!isUsbUsed);
        if (isUsbUsed) {
            this.btnTestConnection.setEnabled(this.cmbUSBDevice.getSelectionIndex() != -1);
        } else {
            this.btnTestConnection.setEnabled(DebuggerUtils.validateIpOrHost((String)this.txtHostNameOrIp.getText()));
        }
        DeviceConnection connection = new DeviceConnection(connectionId, !isUsbUsed);
        this.activeConnections = new DeviceConnection[]{connection};
        if (conAccessor != null) {
            String baseSpeed = conAccessor.getBaseSpeed();
            if (!baseSpeed.isEmpty()) {
                this.txtJtagSpeed.setText(baseSpeed);
            } else {
                this.txtJtagSpeed.setText("16000");
            }
            if (isUsbUsed) {
                String curDevice = this.cmbUSBDevice.getText();
                this.updateUSBDevices(conAccessor, devDescriptor);
                this.setUSBDevice(curDevice);
                if (this.cmbUSBDevice.getSelectionIndex() == -1) {
                    this.cmbUSBDevice.select(0);
                }
            } else {
                connection.setDeviceConnectionData(this.txtHostNameOrIp.getText());
            }
        } else {
            S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(NLS.bind((String)Messages.Debugger_no_device_accessor, (Object)connectionId));
        }
        this.scheduleUpdateJob();
    }

    public boolean isValid(ILaunchConfiguration lc) {
        this.setErrorMessage(null);
        this.setWarningMessage(null);
        S32DebuggerFlashProgrammerAttributesValidator validator = new S32DebuggerFlashProgrammerAttributesValidator();
        S32DebuggerFlashProgrammerParams params = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        List errorsAndWarnings = validator.validateDebuggerParameters(params, false);
        List errors = errorsAndWarnings.stream().filter(status -> status.getSeverity() == 4).collect(Collectors.toList());
        if (errors.size() != 0) {
            this.setErrorMessage(((IStatus)errors.get(0)).getMessage());
            return false;
        }
        if (errorsAndWarnings.size() != 0) {
            this.setWarningMessage(((IStatus)errorsAndWarnings.get(0)).getMessage());
        }
        return true;
    }

    private void createTargetCommunicationSpeedGroup(Composite parent, int leftLabelsWidth) {
        this.targetCommunicationSpeed = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_target_communication_speed_group);
        SWTUtils.createFixedWidthLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_jtag_speed_label, (int)leftLabelsWidth);
        this.txtJtagSpeed = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtJtagSpeed.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabelWithHorizontalIndent((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_label, (int)25);
        this.txtRemoteTimeout = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtRemoteTimeout.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_timeout_unit_of_measure_label);
        this.btnResetAndDelay = SWTUtils.createButton((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_reset_and_delay_button, (int)32);
        this.btnResetAndDelay.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.txtDelay.setEnabled(((Button)e.getSource()).getSelection());
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.txtDelay = SWTUtils.createTextWithWidthHint((Composite)this.targetCommunicationSpeed, (int)2052, (int)50, (int)1);
        this.txtDelay.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createLabel((Composite)this.targetCommunicationSpeed, (String)DebuggerTabMessages.DebuggerTab_delay_unit_of_measure_label);
    }

    private void createGdbServerGroup(Composite parent, int leftLabelsWidth) {
        this.gdbServer = SWTUtils.createGroup((Composite)parent, (int)2, (String)DebuggerTabMessages.DebuggerTab_gdb_server_group);
        this.btnLaunchServer = SWTUtils.createButtonWithHorizontalSpan((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_launch_server_button, (int)32, (int)2);
        this.btnLaunchServer.setSelection(true);
        this.btnLaunchServer.setEnabled(false);
        Label serverPortNumberLabel = SWTUtils.createLabel((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_server_port_number_label);
        SWTUtils.createControlDecoration((Label)serverPortNumberLabel, (String)DebuggerTabMessages.DebuggerTab_server_port_tooltip, (String)"DEC_INFORMATION", (int)131072);
        this.txtServerPort = SWTUtils.createTextWithHorizontalIndentAndWidthHint((Composite)this.gdbServer, (int)2052, (int)15, (int)50);
        this.txtServerPort.setTextLimit(5);
        this.txtServerPort.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.btnEnableLog = SWTUtils.createButton((Composite)this.gdbServer, (String)DebuggerTabMessages.DebuggerTab_enable_log, (int)32);
        this.btnEnableLog.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void createGdbClientGroup(Composite parent, int leftLabelsWidth) {
        this.gdbClient = SWTUtils.createGroup((Composite)parent, (int)5, (String)DebuggerTabMessages.DebuggerTab_gdb_client_group);
        SWTUtils.createFixedWidthLabel((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_executable_label, (int)leftLabelsWidth);
        this.txtClientExecutable = SWTUtils.createWideText((Composite)this.gdbClient, (int)2052, (boolean)true, (int)1);
        this.txtClientExecutable.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.btnClientSelection = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_select_executable, (int)0);
        this.btnClientSelection.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object firstResult;
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(S32DebuggerFlashProgrammerTab.this.getShell(), (ILabelProvider)new LabelProvider());
                dialog.setTitle(DebuggerTabMessages.DebuggerTab_select_executable_dialog);
                dialog.setMessage(DebuggerTabMessages.DebuggerTab_selection_dialog_text_hint);
                dialog.setMultipleSelection(false);
                Collection gdbClients = CoreDebuggerDescriptors.getDeviceClientPaths((String)S32DebuggerFlashProgrammerTab.this.txtDevice.getText(), (String)"s32debugger");
                dialog.setHelpAvailable(false);
                dialog.setIgnoreCase(false);
                dialog.setElements((Object[])gdbClients.toArray(new String[gdbClients.size()]));
                if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof String) {
                    S32DebuggerFlashProgrammerTab.this.txtClientExecutable.setText((String)dialog.getFirstResult());
                }
            }
        });
        this.btnClientSelection.setEnabled(false);
        Button browse = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_browse_button, (int)0);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.browseButtonSelected(DebuggerTabMessages.DebuggerTab_browse_gdb_client_title, S32DebuggerFlashProgrammerTab.this.txtClientExecutable);
            }
        });
        Button variables = SWTUtils.createButton((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_variable_button, (int)0);
        variables.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.variablesButtonSelected(S32DebuggerFlashProgrammerTab.this.txtClientExecutable);
            }
        });
        SWTUtils.createLabelWithVerticalAlignment((Composite)this.gdbClient, (String)DebuggerTabMessages.DebuggerTab_commands_label, (int)1);
        this.txtClientCommands = SWTUtils.createWideTextWithHeightHint((Composite)this.gdbClient, (int)2626, (boolean)true, (int)4, (int)60);
        this.txtClientCommands.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
    }

    private void createSecureDebuggingGroup(Composite parent, int leftLabelsWidth) {
        this.secureDebugger = SWTUtils.createGroup((Composite)parent, (int)3, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_group);
        this.btnEnableSecureDebugging = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_button, (int)32, (int)3);
        this.btnEnableSecureDebugging.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useSecureDebugging = S32DebuggerFlashProgrammerTab.this.btnEnableSecureDebugging.getSelection();
                S32DebuggerFlashProgrammerTab.this.checkClearSecureDataState(S32DebuggerFlashProgrammerTab.this.launchConfigurationName, useSecureDebugging);
                if (S32DebuggerFlashProgrammerTab.this.btnEnableSecureDebugging.getSelection()) {
                    S32DebuggerFlashProgrammerTab.this.cmbSecureType.setEnabled(true);
                    if (S32DebuggerFlashProgrammerTab.this.cmbSecureType.getText().isEmpty()) {
                        S32DebuggerFlashProgrammerTab.this.cmbSecureType.select(0);
                    }
                } else {
                    S32DebuggerFlashProgrammerTab.this.cmbSecureType.setEnabled(false);
                }
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        SWTUtils.createFixedWidthLabel((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_type, (int)leftLabelsWidth);
        this.cmbSecureType = SWTUtils.createFixedWidthComboWithHorizontalSpan((Composite)this.secureDebugger, (int)8, (int)550, (int)1);
        this.cmbSecureType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                S32DebuggerFlashProgrammerTab.this.scheduleUpdateJob();
            }
        });
        this.cmbSecureType.add(DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
        if ("win32".equals(Platform.getOS())) {
            this.cmbSecureType.add(DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
        }
        this.cmbSecureType.setEnabled(false);
        this.btnResetDataStored = SWTUtils.createButtonWithHorizontalSpan((Composite)this.secureDebugger, (String)DebuggerTabMessages.DebuggerTab_secure_debugging_clear_lc_data, (int)8, (int)1);
        this.btnResetDataStored.setEnabled(false);
        this.btnResetDataStored.addListener(13, event -> {
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            if (dispatcher != null && dispatcher.resetProtectedSettings(this.launchConfigurationName)) {
                this.btnResetDataStored.setEnabled(false);
            } else {
                DebuggerCoreActivator.getInstance().logError(ErrorMessages.CannotResetLCStorageData_error_message);
            }
        });
    }

    private void browseButtonSelected(String title, Text text) {
        String str;
        FxFileDialog dialog;
        block3: {
            dialog = new FxFileDialog(this.getControl().getParent(), this.getShell(), 4096);
            dialog.setText(title);
            try {
                dialog.setFilterPath(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution("${S32DS_INITIALIZATION_SCRIPTS_DIR}"));
            }
            catch (CoreException coreException) {
                str = text.getText().trim();
                int lastSeparatorIndex = str.lastIndexOf(File.separator);
                if (lastSeparatorIndex == -1) break block3;
                dialog.setFilterPath(str.substring(0, lastSeparatorIndex));
            }
        }
        str = dialog.open();
        if (str != null) {
            text.setText(str);
        }
    }

    private void variablesButtonSelected(Text text) {
        StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(this.getShell());
        if (dialog.open() == 0) {
            text.setText(dialog.getVariableExpression());
        }
    }

    public String getName() {
        return TAB_NAME;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams.applyDefaults((ILaunchConfigurationWorkingCopy)lc);
    }

    private void setDefaultElementForCombo(Combo combo, String text) {
        String[] comboItems = combo.getItems();
        if (!text.isEmpty()) {
            int i = 0;
            while (i < comboItems.length) {
                if (text.contains(comboItems[i])) {
                    combo.select(i);
                    return;
                }
                ++i;
            }
        }
        combo.select(0);
    }

    public void initializeFrom(ILaunchConfiguration lc) {
        this.launchConfigurationName = lc.getName();
        S32DebuggerFlashProgrammerParams debuggerParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        this.deviceId = debuggerParams.getDeviceId();
        if (!this.deviceId.isEmpty()) {
            this.btnClientSelection.setEnabled(true);
            this.deviceRevision = debuggerParams.getDeviceRevision();
            if (this.deviceRevision == null || this.deviceRevision.isEmpty()) {
                this.txtDevice.setText(this.deviceId);
            } else {
                this.txtDevice.setText(String.valueOf(this.deviceId) + "_" + this.deviceRevision);
            }
            this.btnEnableSecureDebugging.setEnabled(DebuggerDescriptors.getDeviceDebuggerSecureDebuggingAvailable((String)"s32debuggerflashprogrammer", (String)this.deviceId));
        } else {
            this.txtDevice.setText(DebuggerTabMessages.DebuggerTab_not_specified_label);
            this.btnClientSelection.setEnabled(false);
            this.deviceRevision = null;
            this.btnEnableSecureDebugging.setEnabled(false);
        }
        this.txtInitScript.setText(debuggerParams.getInitializationScript());
        boolean isUsbConnection = this.initializeConnectionData(debuggerParams.getDevicePort());
        this.cmbUSBDevice.setEnabled(isUsbConnection);
        this.btnRefresh.setEnabled(isUsbConnection);
        this.txtHostNameOrIp.setEnabled(!isUsbConnection);
        if (isUsbConnection) {
            this.btnTestConnection.setEnabled(this.cmbUSBDevice.getSelectionIndex() != -1);
        } else {
            this.btnTestConnection.setEnabled(DebuggerUtils.validateIpOrHost((String)this.txtHostNameOrIp.getText()));
        }
        String flashName = debuggerParams.getFlashName();
        this.setFlashName(this.deviceId, flashName);
        this.setFlashType(this.deviceId, flashName, debuggerParams.getFlashType());
        this.txtJtagSpeed.setText(debuggerParams.getJtagSpeedKHz());
        this.txtRemoteTimeout.setText(debuggerParams.getRemoteTimeoutInSeconds());
        this.btnResetAndDelay.setSelection(debuggerParams.isDoResetAndDelay());
        this.txtDelay.setEnabled(this.btnResetAndDelay.getSelection());
        this.txtDelay.setText(debuggerParams.getDelayInMSeconds());
        this.txtServerPort.setText(debuggerParams.getServerPort());
        this.btnEnableLog.setSelection(debuggerParams.isLogEnabled());
        this.txtClientExecutable.setText(debuggerParams.getClientExecutable());
        this.txtClientCommands.setText(debuggerParams.getClientCommands());
        boolean useSecureDebugging = debuggerParams.isUseSecureDebugging();
        this.btnEnableSecureDebugging.setSelection(useSecureDebugging);
        this.cmbSecureType.setEnabled(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = debuggerParams.getSecureDebuggingType();
            if ("CR".equals(secureType)) {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_C_R);
            } else {
                this.setDefaultElementForCombo(this.cmbSecureType, DebuggerTabMessages.DebuggerTab_secure_debugging_PwD);
            }
        }
        this.checkClearSecureDataState(this.launchConfigurationName, useSecureDebugging);
        ArrayList readErrors = debuggerParams.getReadErrors();
        if (!readErrors.isEmpty()) {
            AttributeReadingUtils.handleAttributeReadingFailure((IStatus)S32DebuggerErrorStatuses.getAttributesReadingFailedStatus((List)readErrors));
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy lc) {
        S32DebuggerFlashProgrammerParams debuggerParams = S32DebuggerFlashProgrammerParams.getParams((ILaunchConfiguration)lc);
        debuggerParams.setDeviceId(this.deviceId);
        debuggerParams.setDeviceRevision(this.deviceRevision);
        debuggerParams.setInitializationScript(this.txtInitScript.getText().trim());
        if (this.activeConnections != null) {
            debuggerParams.setDevicePort(this.getActiveConnectionData());
        } else {
            debuggerParams.setDevicePort("");
        }
        debuggerParams.setJtagSpeedKHz(this.txtJtagSpeed.getText().trim());
        debuggerParams.setRemoteTimeoutInSeconds(this.txtRemoteTimeout.getText().trim());
        debuggerParams.setDoResetAndDelay(this.btnResetAndDelay.getSelection());
        debuggerParams.setDelayInMSeconds(this.txtDelay.getText().trim());
        debuggerParams.setDoLaunchServer(this.btnLaunchServer.getSelection());
        debuggerParams.setServerPort(this.txtServerPort.getText().trim());
        debuggerParams.setClientExecutable(this.txtClientExecutable.getText().trim());
        debuggerParams.setClientCommands(this.txtClientCommands.getText());
        debuggerParams.setLogEnabled(this.btnEnableLog.getSelection());
        debuggerParams.setFlashName(this.cmbFlashName.getText());
        debuggerParams.setFlashType(this.cmbFlashType.getText());
        boolean useSecureDebugging = this.btnEnableSecureDebugging.getSelection();
        debuggerParams.setUseSecureDebugging(useSecureDebugging);
        if (useSecureDebugging) {
            String secureType = this.cmbSecureType.getText();
            if (DebuggerTabMessages.DebuggerTab_secure_debugging_C_R.equals(secureType)) {
                debuggerParams.setSecureDebuggingType("CR");
            } else {
                debuggerParams.setSecureDebuggingType("PWD");
            }
        } else {
            debuggerParams.setSecureDebuggingType("");
        }
        debuggerParams.applyParams(lc);
    }

    public Image getImage() {
        return GDBJtagImages.getDebuggerTabImage();
    }

    private void setFlashName(String deviceId, String flashName) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashName.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            for (FlashAlgorithmDescriptor dsc : descriptors) {
                this.cmbFlashName.add(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName());
            }
            this.setDefaultElementForCombo(this.cmbFlashName, flashName);
            this.cmbFlashName.setEnabled(true);
        } else {
            this.cmbFlashName.setEnabled(false);
        }
    }

    private void setFlashType(String deviceId, String flashName, String flashType) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashType.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            if (flashName.isEmpty()) {
                flashName = this.cmbFlashName.getText();
            }
            for (FlashAlgorithmDescriptor algDsc : descriptors) {
                String flashId = FlashDescriptors.getFlashRegistry().getFlashDescriptor(algDsc.getFlashId()).getName();
                if (!flashName.equals(flashId)) continue;
                for (FlashProtocolDescriptor dsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(algDsc.getFlashId())) {
                    this.cmbFlashType.add(dsc.getProtocolId());
                }
            }
            this.setDefaultElementForCombo(this.cmbFlashType, flashType);
            this.cmbFlashType.setEnabled(true);
        } else {
            this.cmbFlashType.setEnabled(false);
        }
    }

    private void setDefaultFlashParameters(String deviceId) {
        List descriptors = FlashDescriptors.getFlashRegistry().getFlashAlgorithmDescriptorsByDeviceId(deviceId);
        this.cmbFlashName.setItems(new String[0]);
        this.cmbFlashType.setItems(new String[0]);
        if (!descriptors.isEmpty()) {
            for (FlashAlgorithmDescriptor dsc : descriptors) {
                this.cmbFlashName.add(FlashDescriptors.getFlashRegistry().getFlashDescriptor(dsc.getFlashId()).getName());
            }
            for (FlashAlgorithmDescriptor dsc : FlashDescriptors.getFlashRegistry().getFlashProtocolDescriptorsByFlashId(((FlashAlgorithmDescriptor)descriptors.get(0)).getFlashId())) {
                this.cmbFlashType.add(dsc.getProtocolId());
            }
        }
        if (this.cmbFlashType.getItemCount() > 0 && this.cmbFlashName.getItemCount() > 0) {
            this.cmbFlashName.setEnabled(true);
            this.cmbFlashType.setEnabled(true);
            this.cmbFlashType.select(0);
            this.cmbFlashName.select(0);
        } else {
            this.cmbFlashName.setEnabled(false);
            this.cmbFlashType.setEnabled(false);
        }
    }

    private void addUSBDevices(Collection<DeviceConnection> activeConnections, String deviceToSelect) {
        activeConnections.stream().forEach(connection -> {
            this.cmbUSBDevice.add(connection.getDeviceUiFriendlyName());
            if (connection.getDeviceConnectionData().equals(deviceToSelect)) {
                this.cmbUSBDevice.select(this.cmbUSBDevice.getItemCount() - 1);
            }
        });
        if (this.cmbUSBDevice.getSelectionIndex() == -1) {
            this.cmbUSBDevice.select(0);
        }
        this.activeConnections = (DeviceConnection[])activeConnections.stream().toArray(DeviceConnection[]::new);
    }

    private void updateUSBDevices(DebuggerConnectionAccessor conAccessor, DebuggerConnectionDescriptor conDescriptor) {
        boolean hasDevices;
        this.cmbUSBDevice.removeAll();
        Collection devices = conAccessor.getActiveDeviceConnections(conDescriptor);
        boolean bl = hasDevices = !devices.isEmpty();
        if (hasDevices) {
            this.addUSBDevices(conAccessor.getActiveDeviceConnections(conDescriptor), null);
        }
        this.btnTestConnection.setEnabled(hasDevices);
    }

    private void setUSBDevice(String oldDevice) {
        String[] stringArray = this.cmbUSBDevice.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String curDevice = stringArray[n2];
            if (oldDevice.equals(curDevice)) {
                this.cmbUSBDevice.select(this.cmbUSBDevice.indexOf(curDevice));
                break;
            }
            ++n2;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean initializeConnectionData(String connectionString) {
        DebuggerConnectionDescriptor devDescriptor;
        DebuggerConnectionAccessor devAccessor;
        String connectionId;
        this.cmbUSBDevice.removeAll();
        this.txtHostNameOrIp.setText("");
        boolean isUsbConnection = false;
        String friendlyName = null;
        DeviceConnection connection = DeviceConnection.createFromFullConnectionString((String)connectionString);
        if (connection != null) {
            connectionId = connection.getDeviceConnectionId();
            devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)connectionId);
            if (devAccessor == null) {
                S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(NLS.bind((String)Messages.Debugger_no_device_accessor, (Object)connectionId));
                return false;
            }
            devDescriptor = DebuggerConnections.getDebuggerConnectionDescriptorByConnectionName((String)connectionId);
            friendlyName = connection.getDeviceUiFriendlyName();
        } else {
            Optional descriptorOpt = DebuggerConnections.getDebuggerConnectionDeviceDescriptors((String)"s32debugger").stream().sorted((d1, d2) -> d1.getPriority() - d2.getPriority()).findFirst();
            if (!descriptorOpt.isPresent()) {
                S32DebuggerFlashProgrammerCoreActivator.getDefault().logError(Messages.Debugger_no_device_descriptors);
                return false;
            }
            devDescriptor = (DebuggerConnectionDescriptor)descriptorOpt.get();
            devAccessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)devDescriptor.getConnectionName());
            connection = new DeviceConnection(devDescriptor.getConnectionName(), devDescriptor.isEthernetConnection());
            connectionId = connection.getDeviceConnectionId();
        }
        this.setDefaultElementForCombo(this.cmbDebugInterface, connectionId);
        isUsbConnection = connection.isUsbConnection();
        if (!isUsbConnection) {
            this.txtHostNameOrIp.setText(connection.getDeviceConnectionData());
            this.activeConnections = new DeviceConnection[]{connection};
            return isUsbConnection;
        }
        Collection devicesActive = devAccessor.getActiveDeviceConnections(devDescriptor);
        if (!devicesActive.isEmpty()) {
            this.addUSBDevices(devicesActive, friendlyName);
            return isUsbConnection;
        }
        if (!connection.getDeviceConnectionData().isEmpty()) {
            connection.setDeviceConnectionData("");
        }
        if (!connection.getDeviceUiFriendlyName().isEmpty()) {
            connection.setDeviceUiFriendlyName("");
        }
        this.activeConnections = new DeviceConnection[]{connection};
        return isUsbConnection;
    }

    private String getActiveConnectionData() {
        int index;
        String connectionData = null;
        if (this.activeConnections[0].isUsbConnection() && (index = this.cmbUSBDevice.getSelectionIndex()) != -1) {
            connectionData = this.activeConnections[index].getFullConnectionString();
        }
        if (connectionData == null) {
            connectionData = this.activeConnections[0].getFullConnectionString();
        }
        return connectionData;
    }

    private void setDeviceUINames(DeviceDescriptor descriptor) {
        if (this.deviceRevision == null || this.deviceRevision.isEmpty()) {
            this.txtDevice.setText(descriptor.getName());
        } else {
            this.txtDevice.setText(String.valueOf(descriptor.getName()) + "_" + this.deviceRevision);
        }
        this.txtClientExecutable.setText("${S32DS_GDB_ARM32_PY}");
        this.btnEnableSecureDebugging.setEnabled(DebuggerDescriptors.getDeviceDebuggerSecureDebuggingAvailable((String)"s32debuggerflashprogrammer", (String)descriptor.getId()));
        if (!this.btnEnableSecureDebugging.getEnabled()) {
            this.btnEnableSecureDebugging.setSelection(false);
        }
        this.cmbSecureType.setEnabled(this.btnEnableSecureDebugging.getSelection());
    }

    private void checkClearSecureDataState(String lcName, boolean enableButton) {
        if (enableButton) {
            StorageDispatcher dispatcher = StorageDispatchers.getStorageDispatcher();
            if (dispatcher != null && dispatcher.getProtectedSettings(lcName) != null) {
                this.btnResetDataStored.setEnabled(true);
            }
        } else {
            this.btnResetDataStored.setEnabled(false);
        }
    }
}

