/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.config;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.config.CustomConfigOption;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="custom_config", strict=false)
public class CustomConfigParser {
    private static final Logger LOGGER = LogManager.getLogger(CustomConfigParser.class);
    @ElementList(inline=true, required=false)
    private ArrayList<CustomConfigOption> customOptions = new ArrayList();

    public List<CustomConfigOption> getOptions() {
        return this.customOptions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable Map<String, String> parseCustomOptions(String customConfigPath) {
        File customConfigFile = new File(customConfigPath);
        if (!customConfigFile.exists()) {
            return null;
        }
        HashMap<String, String> customOptionsMap = new HashMap<String, String>();
        try {
            Throwable throwable = null;
            Object var4_7 = null;
            try (InputStream connXmlInStr = UtilsDecryption.getFileInputStream((File)customConfigFile);){
                Persister serializer = new Persister();
                @Nullable CustomConfigParser customConfigContent = (CustomConfigParser)serializer.read(CustomConfigParser.class, connXmlInStr);
                if (customConfigContent == null) {
                    LOGGER.log(Level.WARNING, "Error loading custom_config.xml - no config content.");
                    return null;
                }
                Iterator<CustomConfigOption> iterator = customConfigContent.getOptions().iterator();
                while (true) {
                    if (!iterator.hasNext()) {
                        return customOptionsMap;
                    }
                    CustomConfigOption option = iterator.next();
                    customOptionsMap.put(option.getName(), option.getValue());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot read custom config definition file. ", e);
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error loading custom_config.xml. ", ex);
            return null;
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof CustomConfigParser) || !super.equals(obj)) {
            return false;
        }
        CustomConfigParser other = (CustomConfigParser)obj;
        return this.customOptions.equals(other.customOptions);
    }

    public int hashCode() {
        return Objects.hashCode(this.customOptions);
    }
}

