/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections;

import com.nxp.swtools.common.utils.Nullable;
import java.util.HashMap;
import java.util.Map;

public abstract class Connection {
    protected int clockSource = 0;
    public static final Map<String, SUPPORTED_CONNECTIONS> connectionIDs = new HashMap<String, SUPPORTED_CONNECTIONS>();
    private SUPPORTED_CONNECTIONS type;

    static {
        connectionIDs.put("serial", SUPPORTED_CONNECTIONS.SERIAL_CONNECTION);
        connectionIDs.put("jtag", SUPPORTED_CONNECTIONS.JTAG_CONNECTION);
        connectionIDs.put("cmsis_dap", SUPPORTED_CONNECTIONS.CMSISDAP_CONNECTION);
        connectionIDs.put("s32probe", SUPPORTED_CONNECTIONS.S32PROBE_CONNECTION);
        connectionIDs.put("s32serial", SUPPORTED_CONNECTIONS.S32SERIAL_CONNECTION);
    }

    Connection(SUPPORTED_CONNECTIONS _type) {
        this.type = _type;
    }

    Connection(String _type) {
        SUPPORTED_CONNECTIONS[] sUPPORTED_CONNECTIONSArray = SUPPORTED_CONNECTIONS.values();
        int n = sUPPORTED_CONNECTIONSArray.length;
        int n2 = 0;
        while (n2 < n) {
            SUPPORTED_CONNECTIONS connectionType = sUPPORTED_CONNECTIONSArray[n2];
            if (_type.equalsIgnoreCase(connectionType.getName())) {
                this.type = connectionType;
                return;
            }
            ++n2;
        }
        this.type = SUPPORTED_CONNECTIONS.UNKNOWN_CONNECTION;
    }

    public SUPPORTED_CONNECTIONS getType() {
        return this.type;
    }

    public static @Nullable SUPPORTED_CONNECTIONS getTypeFromID(String id) {
        return connectionIDs.get(id);
    }

    public boolean hasErrors() {
        return false;
    }

    public String getErrorMessage() {
        return "";
    }

    public int getClockSource() {
        return 0;
    }

    public void setClockSource(int clockSource) {
    }

    public static enum SUPPORTED_CONNECTIONS {
        UNKNOWN_CONNECTION("NONE"),
        SERIAL_CONNECTION("SERIAL"),
        CMSISDAP_CONNECTION("CMSISDAP"),
        JTAG_CONNECTION("JTAG"),
        SERIAL_OVER_GDB("SERIALGDB"),
        S32PROBE_CONNECTION("S32PROBE"),
        S32SERIAL_CONNECTION("S32SERIAL");

        private String name;

        private SUPPORTED_CONNECTIONS(String _name) {
            this.name = _name;
        }

        public String getName() {
            return this.name;
        }
    }
}

