/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.tasystem;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.connections.actions.RunAction;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class ProcessWaitHandler
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger(ProcessWaitHandler.class);
    public static final long PROCESS_JOIN_WAIT = 500L;
    private Thread outHandlerThread;
    private long timeout;
    private RunAction.ExecStatus state;
    private AtomicBoolean cancelled = new AtomicBoolean(false);

    public ProcessWaitHandler(Thread _outHandlerThread, long _timeout) {
        this.outHandlerThread = _outHandlerThread;
        this.timeout = _timeout;
        this.state = RunAction.ExecStatus.RUNNING;
    }

    public void cancel() {
        this.cancelled.set(true);
    }

    public RunAction.ExecStatus getState() {
        return this.state;
    }

    @Override
    public void run() {
        long startTime = System.currentTimeMillis();
        while (true) {
            if (!this.outHandlerThread.isAlive()) {
                this.state = RunAction.ExecStatus.TERMINATED;
                return;
            }
            if (System.currentTimeMillis() - startTime > this.timeout) {
                this.state = RunAction.ExecStatus.TIMED_OUT;
                return;
            }
            if (this.cancelled.get()) {
                this.state = RunAction.ExecStatus.CANCELLED;
                return;
            }
            try {
                this.outHandlerThread.join(500L);
            }
            catch (InterruptedException ie) {
                LOGGER.info(ie.getMessage());
                this.state = RunAction.ExecStatus.INTERNAL_ERROR;
                return;
            }
        }
    }
}

