/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.connections.Connection;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionParamView;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.connections.ui.JtagConnectionParamView;
import com.nxp.swtools.mem.validation.connections.ui.SerialConnectionParamView;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Composite;

public class ConnectionParamViewFactory {
    private static final Logger LOGGER = LogManager.getLogger(ConnectionParamViewFactory.class);

    public static @Nullable ConnectionParamView create(Connection.SUPPORTED_CONNECTIONS type, ConnectionView connView, Composite parentView) {
        switch (type) {
            case SERIAL_CONNECTION: 
            case SERIAL_OVER_GDB: 
            case S32SERIAL_CONNECTION: {
                return new SerialConnectionParamView(connView, parentView);
            }
            case JTAG_CONNECTION: 
            case S32PROBE_CONNECTION: {
                return new JtagConnectionParamView(connView, parentView);
            }
            case CMSISDAP_CONNECTION: {
                return new ConnectionParamView(parentView);
            }
        }
        LOGGER.severe("Error creating ConnectionParamView - Unknown connection type: " + (Object)((Object)type));
        return null;
    }
}

