/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.IValidationSessionEventListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.presenter.updaters.ValidationStartUiUpdater;

public class PresentationModelUpdaterListener
implements IValidationSessionEventListener {
    private VPresentationModel data;

    public PresentationModelUpdaterListener(VPresentationModel data) {
        this.data = data;
    }

    @Override
    public IValidationSessionEventListener.VEventListenerResult onEvent(VSessionModel session, VSessionModel.VEvent event, VSessionModel.VEventPhase phase) {
        if (phase == VSessionModel.VEventPhase.CELL_START) {
            this.data.onValidationCellStart(event, true);
        } else if (phase == VSessionModel.VEventPhase.CELL_END) {
            this.data.onValidationCellFinish(event, false);
        } else if (phase == VSessionModel.VEventPhase.VTABLE_START) {
            VTable[] tables;
            VTable[] vTableArray = tables = event.getTables();
            int n = tables.length;
            int n2 = 0;
            while (n2 < n) {
                VTable table = vTableArray[n2];
                table.setState(VTable.TableState.RUNNING);
                ++n2;
            }
            this.data.updateCellHighlighting();
        } else if (phase == VSessionModel.VEventPhase.VTABLE_END) {
            this.data.onValidationTableFinish(event);
        } else if (phase == VSessionModel.VEventPhase.VSCENARIO_END) {
            this.data.onValidationTableFinish(event);
        } else if (phase == VSessionModel.VEventPhase.VSCENARIO_START) {
            this.onValidationScenarioStart(event);
        }
        return new IValidationSessionEventListener.VEventListenerResult(event, phase, true, null);
    }

    private void onValidationScenarioStart(VSessionModel.VEvent event) {
        VStagePresentation stagePresentation;
        VStage stage;
        ValidationPresentationModel vpm = this.data.getValidationModel();
        ExecutionPresentationModel epm = this.data.getExecution();
        VSessionModel session = this.data.getSession();
        if (session != null && (stage = session.getStage()) != null && vpm != null && (stagePresentation = vpm.getStage(stage.getName())) != null) {
            stagePresentation.setSelectedScenarioElement(event.getScenario());
            stagePresentation.setScenarioAutoSelected(true);
            this.data.setSelectedStage(stagePresentation, false);
        }
        if (vpm != null && vpm.isChangedEnabled()) {
            vpm.setChangedEnabled(false);
            if (epm != null) {
                epm.setStartMode(ExecutionPresentationModel.StartValidationMode.CANCEL);
                epm.setStartEnabled(true);
            }
        }
        this.data.updateUI(new ValidationStartUiUpdater(this.data), JobName.REFRESH_UI_ON_VALIDATION_NEXT_STEP.name);
        this.data.updateCellHighlighting();
    }
}

