/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.lproviders;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import java.util.Objects;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.swt.graphics.Image;

public class ScriptConfigColumnLabelProvider
extends ColumnLabelProvider {
    public static final int NAME_COLUMN_IDX = 0;
    public static final int COUNT_COLUMN_IDX = 1;
    private VPresentationModel data;
    private int columnIndex;

    public ScriptConfigColumnLabelProvider(VPresentationModel data, int columnIndex) {
        this.columnIndex = columnIndex;
        this.data = data;
    }

    public @Nullable Image getImage(@Nullable Object element) {
        VScriptConfig sc = (VScriptConfig)element;
        if (sc != null) {
            if (sc.getScript().isUserScript() && this.columnIndex == 0) {
                return Activator.getDefault().getImage("addedByUser.gif");
            }
            if (Objects.requireNonNull(this.data.getValidationModel()).isScriptConfigInvalid(sc) && this.columnIndex == 0) {
                return Activator.getDefault().getImage("errorstate.gif");
            }
        }
        return null;
    }

    public @NonNull String getText(@Nullable Object element) {
        VScriptConfig sc = (VScriptConfig)element;
        if (this.columnIndex == 0 && sc != null) {
            return Objects.requireNonNull(sc.getScript().getName());
        }
        if (this.columnIndex == 1 && sc != null) {
            return "" + sc.getNumRuns();
        }
        return "";
    }
}

