/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.codgen.CgenParser;
import com.nxp.swtools.mem.validation.codgen.Template;
import com.nxp.swtools.mem.validation.config.ConfigManager;
import com.nxp.swtools.mem.validation.config.CustomConfigParser;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.TargetConnectionsSetting;
import com.nxp.swtools.mem.validation.model.ValidationModel;
import com.nxp.swtools.mem.validation.model.scenarios.Tables;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioParser;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableParser;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptParser;
import com.nxp.swtools.validation.engine.GenericProblemWithShowProblemDetails;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class VModel {
    private static final Logger LOGGER = LogManager.getLogger(VModel.class);
    @Nullable
    private static VModel prototype;
    public static final String CONFIG_REGS_ID = "ddr_config_registers";
    public static final String ERR_CAPT_REGS_ID = "ddr_error_capture_registers";
    public static final String DEBUG_REGS_ID = "ddr_debug_registers";
    public static final String CONFIG_REGS_NAME = "Config";
    public static final String ERR_CAPT_REGS_NAME = "Error capture registers";
    public static final String DEBUG_REGS_NAME = "Debug registers";
    public static final String DDR_DATA_RATE_PROPERTY_SYM = "DDR_validDataRate";
    public static final String READ_MARGIN_ID_SUBSTR = "read_margin";
    public static final String EYE_START_IDX = "read_eye_start";
    public static final String EYE_END_IDX = "read_eye_end";
    public static final String TRAINED_VREF = "trained_vref_value";
    public static final String TRAINED_STEP = "trained_vref_step";
    static final String[] CS_BOUNDS_PROPERTIES;
    private boolean populated = false;
    private ValidationModel vModel;
    @Nullable
    private Map<String, String> customOptions;
    @Nullable
    private TargetConnectionsSetting connections;

    static {
        CS_BOUNDS_PROPERTIES = new String[]{"DDR_csStartAddress0", "DDR_csStartAddress1", "DDR_csStartAddress2", "DDR_csStartAddress3", "DDR_cs_bnds_size0", "DDR_cs_bnds_size1", "DDR_cs_bnds_size2", "DDR_cs_bnds_size3"};
    }

    private static void reportVModelLoadProblem(String errMsg) {
        GenericProblemWithShowProblemDetails problem = new GenericProblemWithShowProblemDetails("DDR", 2, errMsg, String.valueOf(Messages.DDRValidationLabel) + ": " + Messages.ValidationDataLoader, Messages.DDRValidationLabel, errMsg);
        ValidationEngineFactory.deleteProblem((IBaseProblem)problem);
        ValidationEngineFactory.addProblem((IGenericProblem)problem);
    }

    private static @Nullable VModel loadPrototype(ConfigManager configManag) {
        String scenarioConfigFile = configManag.getScenariosConfigFile();
        String scriptConfigFile = configManag.getScriptsConfigFile();
        String tableConfigFile = configManag.getTablesConfigFile();
        String scriptsDir = configManag.getMainDir();
        if (!(new File(scenarioConfigFile).exists() && new File(scriptConfigFile).exists() && new File(tableConfigFile).exists() && new File(scriptsDir).exists())) {
            VModel.reportVModelLoadProblem(Messages.MissingValidationDataFiles);
            return null;
        }
        Scripts scripts = VScriptParser.parseScripts(scriptConfigFile, scriptsDir);
        if (scripts == null) {
            VModel.reportVModelLoadProblem(Messages.InvalidValidationScriptData);
            return null;
        }
        Tables tables = VTableParser.parseTables(tableConfigFile, scripts);
        if (tables == null) {
            VModel.reportVModelLoadProblem(Messages.InvalidValidationTableData);
            return null;
        }
        VStage[] stages = VScenarioParser.parseValidationStages(scenarioConfigFile, tables);
        if (stages.length == 0) {
            VModel.reportVModelLoadProblem(Messages.InvalidValidationStagesData);
            return null;
        }
        ValidationModel vModel = new ValidationModel(stages, tables, scripts);
        Map<String, String> customCfg = CustomConfigParser.parseCustomOptions(configManag.getCustomConfigFile());
        TargetConnectionsSetting connections = TargetConnectionsSetting.loadConnectionsXml(configManag.getConnectionsFile());
        return new VModel(vModel, customCfg, connections);
    }

    private static void loadPrototype(ValidationContext vContext, ConfigManager configManager) {
        prototype = VModel.loadPrototype(configManager);
        try {
            CgenManager cgenMng = Activator.getDefault().getCgenManager();
            if (prototype != null) {
                Map<String, Template.TemplateFile[]> templates = prototype.getValidationModel().getScripts().getScriptTemplateMap();
                CgenParser.parseCgenConfigFile(configManager, templates, cgenMng);
            }
        }
        catch (Exception e) {
            LOGGER.severe(e.getMessage());
        }
    }

    public static @Nullable VModel newInstance(ValidationContext vContext, ConfigManager configMng) {
        VModel.loadPrototype(vContext, configMng);
        VModel prototypeLoc = prototype;
        if (prototypeLoc != null) {
            ValidationModel vModel = new ValidationModel(prototypeLoc.vModel, vContext);
            VModel newModel = new VModel(vModel, prototypeLoc.customOptions, prototypeLoc.connections);
            newModel.populate(vContext);
            newModel.update(vContext);
            newModel.updateReadMarginDataEye();
            return newModel;
        }
        return null;
    }

    private VModel(ValidationModel _vModel, @Nullable Map<String, String> _customOptions, @Nullable TargetConnectionsSetting _connections) {
        this.vModel = _vModel;
        this.customOptions = _customOptions;
        this.connections = _connections;
    }

    public @Nullable String getCustomOption(String optionName) {
        return this.customOptions != null ? this.customOptions.get(optionName) : null;
    }

    public @Nullable TargetConnectionsSetting getConnections() {
        return this.connections;
    }

    public Map<String, Template.TemplateFile[]> getScriptTemplateMap() {
        HashMap<String, Template.TemplateFile[]> templateMap = new HashMap<String, Template.TemplateFile[]>();
        Scripts scripts = this.vModel.getScripts();
        for (VScript script : scripts.getScripts()) {
            VScript.VScriptTemplate[] templates = script.getTemplates();
            Template.TemplateFile[] templFiles = new Template.TemplateFile[templates.length];
            int i = 0;
            VScript.VScriptTemplate[] vScriptTemplateArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                VScript.VScriptTemplate template = vScriptTemplateArray[n2];
                templFiles[i] = new Template.TemplateFile(script.getId(), template.getFilePath());
                ++i;
                ++n2;
            }
            templateMap.put(script.getId(), templFiles);
        }
        return templateMap;
    }

    public ValidationModel getValidationModel() {
        return this.vModel;
    }

    private void populate(ValidationContext vContext) {
        if (!this.populated) {
            this.vModel.populate(vContext);
            this.populated = true;
        }
    }

    public void update(ValidationContext vContext) {
        this.update(vContext, false);
    }

    public void update(ValidationContext vContext, boolean repopulateRegs) {
        this.vModel.update(vContext);
    }

    private void updateReadMarginDataEye() {
        VTable[] tables = this.vModel.getTables(READ_MARGIN_ID_SUBSTR);
        int startEye = 20;
        int endEye = 40;
        VTable[] vTableArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            VTable table = vTableArray[n2];
            table.getOptions().setParam(EYE_START_IDX, new Integer(startEye));
            table.getOptions().setParam(EYE_END_IDX, new Integer(endEye));
            ++n2;
        }
    }

    public static enum ScriptId {
        BIST_1TURN_TEST("bist_1_wr_turn"),
        BIST_2TURN_TEST("bist_2_wr_turn"),
        BIST_4TURN_TEST("bist_4_wr_turn"),
        BIST_NOTURN_TEST("bist_no_turn"),
        DMA_TEST("dma"),
        WRITE_READ_COMPARE("wrc"),
        WALKING_ONES("wones"),
        WALKING_ZEROS("wzeros"),
        READ_MARGIN("rmargin"),
        WRITE_MARGIN("wmargin");

        public final String id;

        private ScriptId(String _id) {
            this.id = _id;
        }
    }
}

