/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.JitterEyeResultHandler;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.JSPresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.nebula.visualization.xygraph.dataprovider.CircularBufferDataProvider;
import org.eclipse.nebula.visualization.xygraph.dataprovider.IDataProvider;
import org.eclipse.nebula.visualization.xygraph.figures.Axis;
import org.eclipse.nebula.visualization.xygraph.figures.IXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.ToolbarArmedXYGraph;
import org.eclipse.nebula.visualization.xygraph.figures.Trace;
import org.eclipse.nebula.visualization.xygraph.figures.XYGraph;
import org.eclipse.nebula.visualization.xygraph.linearscale.Range;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class JitterFigure
implements IDisplayFigure {
    protected static final Logger LOGGER = LogManager.getLogger(JSPresentation.class);
    public static final String DATA_EYE_DIAGRAM = "Data Eye";
    public static final String RECOVERED_DATA_DIAGRAM = "Recovered data stream";
    public static final String BATH_TUB_BER = "Bath Tub Curve";
    public static final String BATH_TUB_MISCOMPARES = "Bath Tub Number of Miscompares";
    public static final String RECOVERED_DIAGRAM_Y_AXIS_NAME = "Normalized Mismatch";
    public static final String RECOVERED_DIAGRAM_X_AXIS_NAME = "Test Step";
    public static final String BATH_TUB_CURVE_X_AXIS_NAME = "Sampler Position";
    public static final String BATH_TUB_CURVE_Y_AXIS_NAME = "BER";
    public static final String DATA_EYE_X_AXIS_NAME = "Interpolator Step";
    public static final String DATA_EYE_Y_AXIS_NAME = "Normalized Mismatch";
    public static final String BATH_TUB_MISCOMPARES_X_AXIS_NAME = "Sampler Position";
    public static final String BATH_TUB_MISCOMPARES_Y_AXIS_NAME = "Number of Miscompares";
    private VTable model;
    private List<JitterEyeResultHandler.JSTestData> jitterDataList = new ArrayList<JitterEyeResultHandler.JSTestData>();
    private List<JitterEyeResultHandler.JSTestData> patternIndependentDataList = new ArrayList<JitterEyeResultHandler.JSTestData>();
    private double stepsPerBit;
    private int patternLength;
    private int rxRate;
    private int countWindowBits;
    private ToolbarArmedXYGraph dataEyeDiagram;
    private ToolbarArmedXYGraph recoveredDataDiagram;
    private ArrayList<JitterEyeResultHandler.EyeTable> jitterData = new ArrayList();
    private ArrayList<JitterEyeResultHandler.EyeTable> pattIndepJitterData = new ArrayList();
    public static final String PATTERN = "pattern";
    private boolean isJitter = false;

    public JitterFigure(VTable model) {
        this.model = model;
        this.recoveredDataDiagram = new ToolbarArmedXYGraph();
        this.dataEyeDiagram = new ToolbarArmedXYGraph();
    }

    @Override
    public void draw(PaintEvent e, Point selCell, boolean hiliteRunCell, int numRuns) {
        if (this.isJitter) {
            if (!this.jitterData.isEmpty()) {
                JitterEyeResultHandler.EyeTable eye = this.jitterData.get(0);
                this.jitterDataList = eye.getTestData();
                this.stepsPerBit = eye.getStepsPerBit();
                this.patternLength = eye.getPatternLegth();
            }
        } else if (!this.pattIndepJitterData.isEmpty()) {
            JitterEyeResultHandler.EyeTable eye = this.pattIndepJitterData.get(0);
            this.patternIndependentDataList = eye.getTestData();
            this.stepsPerBit = eye.getStepsPerBit();
            this.rxRate = eye.getRxRate();
            this.countWindowBits = eye.getCountWindowBits();
        }
        this.clearTestData();
        if (this.jitterDataList.isEmpty() && this.patternIndependentDataList.isEmpty()) {
            return;
        }
        if (this.isJitter) {
            this.fillDataEyeDiagram();
            this.fillRecoveredDataDiagram();
        } else {
            this.fillBathTubCurveDiagram();
            this.fillBathTubNumMiscompares();
        }
    }

    private void fillRecoveredDataDiagram() {
        int testSteps = this.jitterDataList.size();
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        traceDataProvider.setBufferSize(testSteps);
        traceDataProvider.setCurrentXDataArray(this.getArrayOfElementsFromList(0, true));
        traceDataProvider.setCurrentYDataArray(this.getArrayOfElementsFromList(2, true));
        IXYGraph graph = this.recoveredDataDiagram.getXYGraph();
        graph.getPrimaryXAxis().setRange(new Range(0.0, 1000.0));
        graph.getPrimaryXAxis().setAutoScale(true);
        graph.getPrimaryXAxis().setShowMajorGrid(true);
        graph.getPrimaryXAxis().setAutoScaleThreshold(0.0);
        graph.getPrimaryYAxis().setRange(new Range(-1.5, 1.5));
        graph.getPrimaryYAxis().setAutoScale(true);
        graph.getPrimaryYAxis().setShowMajorGrid(true);
        graph.getPrimaryYAxis().setAutoScaleThreshold(0.0);
        graph.setTitle(RECOVERED_DATA_DIAGRAM);
        graph.getPrimaryXAxis().setTitle(RECOVERED_DIAGRAM_X_AXIS_NAME);
        graph.getPrimaryYAxis().setTitle("Normalized Mismatch");
        Trace trace = new Trace("Recovered data stream plot", graph.getPrimaryXAxis(), graph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.XCROSS);
        graph.addTrace(trace);
    }

    private void fillDataEyeDiagram() {
        block4: {
            IXYGraph graph = this.dataEyeDiagram.getXYGraph();
            try {
                double[][] stepResults = this.generateDataForEyeDiagramAxes(0, this.patternLength);
                double[][] normMismatchResults = this.generateDataForEyeDiagramAxes(2, this.patternLength);
                if (normMismatchResults == null || stepResults == null) {
                    return;
                }
                graph.getPrimaryXAxis().setRange(new Range(0.0, this.stepsPerBit / 2.0));
                graph.getPrimaryYAxis().setLogScale(false);
                graph.getPrimaryYAxis().setRange(new Range(-1.5, 1.5));
                graph.getPrimaryYAxis().setAutoScaleThreshold(0.0);
                graph.setTitle(DATA_EYE_DIAGRAM);
                graph.getPrimaryXAxis().setTitle(DATA_EYE_X_AXIS_NAME);
                graph.getPrimaryYAxis().setTitle("Normalized Mismatch");
                int i = 0;
                while (i < this.patternLength) {
                    CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
                    traceDataProvider.setBufferSize(10000);
                    traceDataProvider.setCurrentXDataArray(stepResults[i]);
                    traceDataProvider.setCurrentYDataArray(normMismatchResults[i]);
                    Trace trace = new Trace("Bit " + i, graph.getPrimaryXAxis(), graph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
                    trace.setPointStyle(Trace.PointStyle.XCROSS);
                    graph.addTrace(trace);
                    ++i;
                }
            }
            catch (Exception exception) {
                if (!((double)this.jitterDataList.size() < (double)(this.patternLength * 2) * this.stepsPerBit)) break block4;
                LOGGER.severe("Data size is incorrect");
            }
        }
    }

    public void clearTestData() {
        Trace t;
        int i;
        IXYGraph graph = this.dataEyeDiagram.getXYGraph();
        List traces = graph.getPlotArea().getTraceList();
        if (traces != null && !traces.isEmpty()) {
            i = 0;
            while (i < traces.size()) {
                t = (Trace)traces.get(i);
                graph.removeTrace(t);
                --i;
                ++i;
            }
        }
        if ((traces = (graph = this.recoveredDataDiagram.getXYGraph()).getPlotArea().getTraceList()) != null && !traces.isEmpty()) {
            i = 0;
            while (i < traces.size()) {
                t = (Trace)traces.get(i);
                graph.removeTrace(t);
                --i;
                ++i;
            }
        }
    }

    private double[] getArrayOfElementsFromList(int id, boolean isJitter) {
        List<JitterEyeResultHandler.JSTestData> dataList = isJitter ? this.jitterDataList : this.patternIndependentDataList;
        double[] results = new double[dataList.size()];
        int i = 0;
        for (JitterEyeResultHandler.JSTestData data : dataList) {
            results[i++] = id == 0 ? data.step : (id == 1 ? data.numMismatch : data.normMismatch);
        }
        return results;
    }

    private void fillBathTubCurveDiagram() {
        assert (!this.patternIndependentDataList.isEmpty()) : "No data is available!";
        int testSteps = this.patternIndependentDataList.size();
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        traceDataProvider.setBufferSize(testSteps);
        double[] xPoints = this.getArrayOfElementsFromList(0, false);
        XYGraph xygraph = (XYGraph)this.dataEyeDiagram.getXYGraph();
        xygraph.getPrimaryYAxis().setLogScale(true);
        xygraph.getPrimaryYAxis().setShowMajorGrid(true);
        xygraph.getPrimaryYAxis().setRange(1.0E-16, 1.0);
        xygraph.setTitle(BATH_TUB_BER);
        xygraph.getPrimaryXAxis().setTitle("Sampler Position");
        xygraph.getPrimaryYAxis().setTitle(BATH_TUB_CURVE_Y_AXIS_NAME);
        double[] yPoints = null;
        if (this.rxRate == 3) {
            yPoints = new double[32];
            int i = 0;
            while (i < 32) {
                double posSum = this.patternIndependentDataList.get((int)i).normMismatch + this.patternIndependentDataList.get((int)(i + 32)).normMismatch + this.patternIndependentDataList.get((int)(i + 64)).normMismatch + this.patternIndependentDataList.get((int)(i + 96)).normMismatch;
                yPoints[i] = posSum / (double)(4 * this.countWindowBits);
                ++i;
            }
            ((Axis)xygraph.getXAxisList().get(0)).setRange(0.0, (double)xPoints.length / 4.0);
        } else if (this.rxRate == 0) {
            yPoints = new double[64];
            int i = 0;
            while (i < 64) {
                double posSum = this.patternIndependentDataList.get((int)i).normMismatch + this.patternIndependentDataList.get((int)(i + 64)).normMismatch;
                yPoints[i] = posSum / (double)(2 * this.countWindowBits);
                ++i;
            }
            ((Axis)xygraph.getXAxisList().get(0)).setRange(0.0, (double)xPoints.length / 2.0);
        } else if (this.rxRate == 1) {
            yPoints = new double[128];
            int i = 0;
            while (i < 128) {
                double posSum = this.patternIndependentDataList.get((int)i).normMismatch;
                yPoints[i] = posSum / (double)(1 * this.countWindowBits);
                ++i;
            }
            ((Axis)xygraph.getXAxisList().get(0)).setRange(0.0, (double)xPoints.length);
        } else if (this.rxRate == 2) {
            yPoints = new double[256];
            int i = 0;
            while (i < 256) {
                double posSum = this.patternIndependentDataList.get((int)i).normMismatch;
                yPoints[i] = posSum / (double)(1 * this.countWindowBits);
                ++i;
            }
            ((Axis)xygraph.getXAxisList().get(0)).setRange(0.0, (double)xPoints.length);
        }
        traceDataProvider.setCurrentXDataArray(xPoints);
        traceDataProvider.setCurrentYDataArray(yPoints);
        XYGraph graph = (XYGraph)this.dataEyeDiagram.getXYGraph();
        Trace trace = new Trace("BathTub curve BER", graph.getPrimaryXAxis(), graph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.XCROSS);
        graph.addTrace(trace);
    }

    private void fillBathTubNumMiscompares() {
        assert (!this.patternIndependentDataList.isEmpty()) : "No data is available!";
        int testSteps = this.patternIndependentDataList.size();
        CircularBufferDataProvider traceDataProvider = new CircularBufferDataProvider(false);
        traceDataProvider.setBufferSize(testSteps);
        traceDataProvider.setCurrentXDataArray(this.getArrayOfElementsFromList(0, false));
        traceDataProvider.setCurrentYDataArray(this.getArrayOfElementsFromList(2, false));
        XYGraph graph = (XYGraph)this.recoveredDataDiagram.getXYGraph();
        graph.getPrimaryYAxis().setRange(new Range(0.0, 40000.0));
        graph.getPrimaryYAxis().setShowMajorGrid(true);
        graph.getPrimaryYAxis().setAutoScale(true);
        graph.getPrimaryYAxis().setAutoFormat(false);
        graph.getPrimaryYAxis().setFormatPattern("0");
        ((Axis)graph.getXAxisList().get(0)).setRange(0.0, (double)(this.getArrayOfElementsFromList(0, false).length - 1));
        graph.setTitle(BATH_TUB_MISCOMPARES);
        graph.getPrimaryXAxis().setTitle("Sampler Position");
        graph.getPrimaryYAxis().setTitle(BATH_TUB_MISCOMPARES_Y_AXIS_NAME);
        Trace trace = new Trace("BathTub curve Miscompares", graph.getPrimaryXAxis(), graph.getPrimaryYAxis(), (IDataProvider)traceDataProvider);
        trace.setPointStyle(Trace.PointStyle.XCROSS);
        graph.addTrace(trace);
    }

    private double @Nullable [][] generateDataForEyeDiagramAxes(int id, int patternLength) throws Exception {
        double[][] results = new double[patternLength][];
        if (this.jitterDataList.isEmpty()) {
            return null;
        }
        assert (patternLength > 0) : "Pattern length must be strict positive";
        int noOfStepsPerBit = 2 * (int)this.stepsPerBit;
        if (noOfStepsPerBit != this.jitterDataList.size() / patternLength) {
            LOGGER.severe(String.format("Number of steps per bit is wrong! Steps_per_bit:%d, patternLength=%d, dataSize=%d!", BigInteger.valueOf((int)this.stepsPerBit), BigInteger.valueOf(patternLength), BigInteger.valueOf(this.jitterDataList.size())));
        }
        int i = 0;
        while (i < patternLength) {
            results[i] = new double[noOfStepsPerBit];
            int j = 0;
            while (j < noOfStepsPerBit) {
                JitterEyeResultHandler.JSTestData data = this.jitterDataList.get(i * noOfStepsPerBit + j);
                results[i][j] = id == 0 ? (double)j : (id == 1 ? data.numMismatch : data.normMismatch);
                ++j;
            }
            ++i;
        }
        return results;
    }

    @Override
    public void enableCellColoring(boolean enabled) {
    }

    @Override
    public @Nullable Point getCellBoxPos(@NonNull Point selectedCellPos) {
        return null;
    }

    @Override
    public @Nullable Point getCellBoxSize(@NonNull Point selectedCellPos) {
        return null;
    }

    @Override
    public @Nullable Point getCellPositionAt(@NonNull Point pos) {
        return null;
    }

    @Override
    public @Nullable Point @Nullable [] getCellPositions(@NonNull Point start, @NonNull Point end) {
        return null;
    }

    @Override
    public @NonNull VTable getModel() {
        return this.model;
    }

    @Override
    public @NonNull Point getOffset() {
        return new Point(0, 0);
    }

    @Override
    public @NonNull Point getSize() {
        return new Point(1, 1);
    }

    @Override
    public void precompute(@NonNull GC gc, @NonNull Point _offset) {
    }

    @Override
    public boolean reset() {
        return false;
    }

    @Override
    public void setRunningCell(@NonNull VParamVariation cellData) {
    }

    @Override
    public void updateAllCellContents() {
    }

    @Override
    public void updateAllCellContents(@NonNull VParamVariation startCell) {
    }

    @Override
    public void updateCellContents(@NonNull VParamVariation cellData) {
        ArrayList<JitterEyeResultHandler.EyeTable> pdata;
        ArrayList<JitterEyeResultHandler.EyeTable> jdata = cellData.getJitterData();
        if (jdata != null) {
            this.jitterData = jdata;
        }
        if ((pdata = cellData.getPattIndepJitterData()) != null) {
            this.pattIndepJitterData = pdata;
        }
    }

    @Override
    public void updateGoldenCellContents(@NonNull VParamVariation cellData) {
    }

    @Override
    public void updateSkipTableContents(@NonNull VParamVariation firstCell) {
    }

    @Override
    public void updateVLabelName(@NonNull String vLabel) {
    }

    public void updateJitterInfo(ToolbarArmedXYGraph dataEyeDiagram, ToolbarArmedXYGraph recoveredDataDiagram, boolean isJitter) {
        this.dataEyeDiagram = dataEyeDiagram;
        this.recoveredDataDiagram = recoveredDataDiagram;
        this.isJitter = isJitter;
    }

    public int getDataSize() {
        int size = 0;
        size = !this.jitterDataList.isEmpty() ? this.jitterDataList.size() : 0;
        size += !this.patternIndependentDataList.isEmpty() ? this.patternIndependentDataList.size() : 0;
        size += this.jitterData.size();
        return size += this.pattIndepJitterData.size();
    }

    public int getJitterSize() {
        return this.jitterDataList.size() + this.jitterData.size();
    }

    public int getPattIndepJitterSize() {
        return this.patternIndependentDataList.size() + this.pattIndepJitterData.size();
    }
}

