/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.UIResourceManager;
import com.nxp.swtools.mem.validation.utils.VLoggingUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Transform;

public class VTableFigure
implements IDisplayFigure {
    private static final Logger LOGGER = LogManager.getLogger(VTableFigure.class);
    public static final int TXT_LINE_SPACE = 4;
    public static final int DEFAULT_VLABEL_WIDTH = 15;
    public static final int SEL_CELL_LINE_WIDTH = 4;
    private static boolean staticsComputed = false;
    @Nullable
    static Font boldFont = null;
    private static int textHeight = -1;
    private VTable model;
    private Point offset;
    private Point size;
    private boolean hLabelsVisible;
    private LabelBox headerLabel;
    private LabelBox cornerLabel;
    private LabelBox hLabel;
    private ParamBox[] hParams;
    private LabelBox vLabel;
    private ParamBox[] vParams;
    private CellsBox cells;
    private boolean computed;
    private boolean headerIsVisible;
    private boolean cellColoringEnabled;

    private static String extractClassFromString(String description) {
        if (description.startsWith("class:")) {
            assert (description.split(":").length == 3);
            try {
                Class<?> myClass = Class.forName(description.split(":")[1]);
                Method method = myClass.getMethod(description.split(":")[2], new Class[0]);
                Object returnMethod = method.invoke(null, new Object[0]);
                return (String)returnMethod;
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                return description;
            }
        }
        return description;
    }

    private static void precomputeStatics(GC gc) {
        FontData[] boldFontData = gc.getFont().getFontData();
        boldFontData[0].setStyle(1);
        boldFont = new Font(gc.getDevice(), boldFontData);
        Font crtFont = gc.getFont();
        gc.setFont(boldFont);
        textHeight = gc.getFontMetrics().getHeight();
        gc.setFont(crtFont);
    }

    private static String[] splitName(String name, int medianLen) {
        int MAX_ALLOW_DIF = 5;
        if (name.length() < medianLen) {
            return new String[]{name};
        }
        if (name.length() - medianLen <= MAX_ALLOW_DIF) {
            return new String[]{name};
        }
        String[] words = name.split("[\\s]+");
        if (words.length == 1 || words.length == 2) {
            return words;
        }
        int i = 0;
        LinkedList<String> splits = new LinkedList<String>();
        while (i < words.length) {
            if (words[i].length() - medianLen > MAX_ALLOW_DIF) {
                splits.add(words[i]);
                ++i;
                continue;
            }
            int sumLen = words[i].length();
            int j = i + 1;
            while (j < words.length) {
                if (words[j].length() + sumLen >= MAX_ALLOW_DIF) break;
                sumLen += words[j].length();
                ++j;
            }
            StringBuffer sbNewGroup = new StringBuffer(words[i]);
            if (j == words.length) {
                --j;
            }
            int k = i + 1;
            while (k <= j) {
                sbNewGroup.append(" ").append(words[k]);
                ++k;
            }
            splits.add(sbNewGroup.toString());
            i = j + 1;
        }
        return splits.toArray(new String[splits.size()]);
    }

    public VTableFigure(VTable _model, boolean _hLabelsVisible, boolean headerIsVisible, boolean celColoringEnabled) {
        int j;
        String[] multiParamOpt;
        int numMultiOpt;
        String[] paramOpt;
        String paramName;
        this.model = _model;
        this.headerIsVisible = headerIsVisible;
        this.cellColoringEnabled = celColoringEnabled;
        boolean isDarkTheme = ToolsColors.isDarkTheme();
        Color headerColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.title_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_BG");
        Color cornerColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_header_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG");
        Color paramColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_header_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG");
        Color paramOptColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.title_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_BG");
        this.offset = new Point(0, 0);
        this.size = new Point(0, 0);
        this.hLabelsVisible = _hLabelsVisible;
        this.headerLabel = new LabelBox(this.model.getDescription(), false, null, headerColor);
        this.cornerLabel = new LabelBox(this.model.getCornerText(), false, null, cornerColor);
        String hLabelTxt = this.model.getOptions().gethLabel();
        Transform t = Activator.getDefault().getTransform();
        this.hLabel = new LabelBox(hLabelTxt, true, t, paramColor);
        this.hParams = new ParamBox[this.model.getHParams().length];
        int prevOptNum = 1;
        int i = 0;
        boolean showParamLabels = this.model.getHParams().length > 1;
        VParam[] vParamArray = this.model.getHParams();
        int n = vParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParamData = vParamArray[n2];
            paramName = hParamData.getName();
            paramOpt = hParamData.getOptNames();
            if (paramOpt == null) {
                paramOpt = new String[]{};
            }
            if (prevOptNum == 1) {
                this.hParams[i] = new ParamBox(showParamLabels, paramName, paramOpt, paramColor, paramOptColor, paramOpt.length);
            } else {
                numMultiOpt = prevOptNum * paramOpt.length;
                multiParamOpt = new String[numMultiOpt];
                j = 0;
                while (j < numMultiOpt) {
                    multiParamOpt[j] = paramOpt[j % paramOpt.length];
                    ++j;
                }
                int length = 0;
                String[] optNames = hParamData.getOptNames();
                if (optNames != null) {
                    length = optNames.length;
                }
                this.hParams[i] = new ParamBox(showParamLabels, paramName, multiParamOpt, paramColor, paramOptColor, length);
            }
            prevOptNum *= paramOpt.length;
            ++i;
            ++n2;
        }
        this.vLabel = new LabelBox(this.model.getOptions().getvLabel(), false, null, paramColor);
        this.vParams = new ParamBox[this.model.getVParams().length];
        i = 0;
        prevOptNum = 1;
        showParamLabels = this.model.getVParams().length > 1;
        vParamArray = this.model.getVParams();
        n = vParamArray.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParamData = vParamArray[n2];
            paramName = vParamData.getName();
            paramOpt = vParamData.getOptNames();
            if (paramOpt == null) {
                paramOpt = new String[]{};
            }
            if (prevOptNum == 1) {
                this.vParams[i] = new ParamBox(showParamLabels, paramName, paramOpt, paramColor, paramOptColor, paramOpt.length);
            } else {
                numMultiOpt = prevOptNum * paramOpt.length;
                multiParamOpt = new String[numMultiOpt];
                j = 0;
                while (j < numMultiOpt) {
                    multiParamOpt[j] = paramOpt[j % paramOpt.length];
                    ++j;
                }
                this.vParams[i] = new ParamBox(showParamLabels, paramName, multiParamOpt, paramColor, paramOptColor, paramOpt.length);
            }
            prevOptNum *= paramOpt.length;
            ++i;
            ++n2;
        }
        this.cells = this.createCells();
        this.createHiliteMap();
    }

    public void updateTheme(boolean isDarkTheme) {
        ParamBox hParamBox;
        Color headerColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.title_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_BG");
        Color cornerColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_header_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG");
        Color paramColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_header_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.tile_viewer_item_BG");
        Color paramOptColor = isDarkTheme ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.title_BG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_BG");
        this.headerLabel.color = headerColor;
        this.cornerLabel.color = cornerColor;
        this.hLabel.color = paramColor;
        ParamBox[] paramBoxArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            hParamBox = paramBoxArray[n2];
            hParamBox.paramLabel.color = paramColor;
            hParamBox.paramOptions.color = paramOptColor;
            ++n2;
        }
        this.vLabel.color = paramColor;
        paramBoxArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            hParamBox = paramBoxArray[n2];
            hParamBox.paramLabel.color = paramColor;
            hParamBox.paramOptions.color = paramOptColor;
            ++n2;
        }
        this.cells.color = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_BG");
    }

    private CellsBox createCells() {
        String[] optNames;
        Point numCells = new Point(1, 1);
        VParam[] vParamArray = this.model.getHParams();
        int n = vParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hparam = vParamArray[n2];
            optNames = hparam.getOptNames();
            if (optNames != null) {
                numCells.x *= optNames.length;
            }
            ++n2;
        }
        vParamArray = this.model.getVParams();
        n = vParamArray.length;
        n2 = 0;
        while (n2 < n) {
            VParam vparam = vParamArray[n2];
            optNames = vparam.getOptNames();
            if (optNames != null) {
                numCells.y = optNames.length;
            }
            ++n2;
        }
        return new CellsBox(numCells);
    }

    private void createHiliteMap() {
        int i;
        int[] higtliteMap;
        Point numCells = this.cells.numCells;
        int hiliteGroupSize = 1;
        int k = this.hParams.length - 1;
        while (k >= 0) {
            ParamBox hParamBox = this.hParams[k];
            hParamBox.paramOptions.setHiliteMap(new int[numCells.x]);
            higtliteMap = hParamBox.paramOptions.getHiliteMap();
            if (higtliteMap != null) {
                if (hiliteGroupSize == 1) {
                    i = 0;
                    while (i < numCells.x) {
                        higtliteMap[i] = i;
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < numCells.x) {
                        higtliteMap[i] = i / hiliteGroupSize;
                        ++i;
                    }
                }
            }
            hiliteGroupSize *= hParamBox.numOptions;
            --k;
        }
        hiliteGroupSize = 1;
        k = this.vParams.length - 1;
        while (k >= 0) {
            ParamBox vParamBox = this.vParams[k];
            vParamBox.paramOptions.setHiliteMap(new int[numCells.y]);
            higtliteMap = vParamBox.paramOptions.getHiliteMap();
            if (higtliteMap != null) {
                if (hiliteGroupSize == 1) {
                    i = 0;
                    while (i < numCells.y) {
                        higtliteMap[i] = i;
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < numCells.y) {
                        higtliteMap[i] = (i + 1) / hiliteGroupSize;
                        ++i;
                    }
                }
            }
            hiliteGroupSize *= vParamBox.numOptions;
            --k;
        }
    }

    @Override
    public void draw(PaintEvent e, Point selCell, boolean hiliteRunCell, int numRuns) {
        int n;
        int n2;
        ParamBox[] paramBoxArray;
        this.updateSelectedCell(selCell);
        if (this.headerIsVisible) {
            this.headerLabel.draw(e);
        }
        if (this.model.getDescription().startsWith("class:")) {
            this.headerLabel.content = VTableFigure.extractClassFromString(this.model.getDescription());
            this.headerLabel.draw(e);
        }
        if (this.hLabelsVisible) {
            this.cornerLabel.draw(e);
            this.hLabel.draw(e);
            paramBoxArray = this.hParams;
            n2 = this.hParams.length;
            n = 0;
            while (n < n2) {
                ParamBox hParamBox = paramBoxArray[n];
                hParamBox.draw(e);
                ++n;
            }
        }
        this.vLabel.draw(e);
        paramBoxArray = this.vParams;
        n2 = this.vParams.length;
        n = 0;
        while (n < n2) {
            ParamBox vParamBox = paramBoxArray[n];
            vParamBox.draw(e);
            ++n;
        }
        if (this.model.getState() != VTable.TableState.RUNNING && this.model.getState() != VTable.TableState.PAUSED) {
            this.cells.runCellPos.x = -1;
            this.cells.runCellPos.y = -1;
        }
        Object obj1 = this.model.getOptions().getParam("read_eye_start");
        Object obj2 = this.model.getOptions().getParam("read_eye_end");
        if (obj1 == null || obj2 == null) {
            this.cells.draw(e, hiliteRunCell);
        } else {
            Integer startEye = (Integer)obj1;
            Integer endEye = (Integer)obj2;
            this.cells.draw(e, hiliteRunCell, startEye - 1, endEye);
        }
    }

    @Override
    public void enableCellColoring(boolean enabled) {
        this.cellColoringEnabled = enabled;
    }

    public @Nullable CellBox getCellBox(Point cellPos) {
        if (cellPos == null || cellPos.x < 0 || cellPos.y < 0) {
            return null;
        }
        if (cellPos.x >= this.cells.numCells.x || cellPos.y >= this.cells.numCells.y) {
            return null;
        }
        return this.cells.cells[cellPos.x][cellPos.y];
    }

    @Override
    public @Nullable Point getCellBoxPos(Point selectedCellPos) {
        CellBox cell = this.getCellBox(selectedCellPos);
        if (cell != null) {
            return cell.getPos();
        }
        return null;
    }

    @Override
    public @Nullable Point getCellBoxSize(Point selectedCellPos) {
        CellBox cell = this.getCellBox(selectedCellPos);
        if (cell != null) {
            return cell.getSize();
        }
        return null;
    }

    @Override
    public @Nullable Point getCellPositionAt(Point pos) {
        if (this.cells.pos.x <= pos.x && pos.x <= this.cells.pos.x + this.cells.size.x && this.cells.pos.y <= pos.y && pos.y <= this.cells.pos.y + this.cells.size.y) {
            return new Point((pos.y - this.cells.pos.y - 1) / this.cells.cellSize.y, (pos.x - this.cells.pos.x - 1) / this.cells.cellSize.x);
        }
        return new Point(-1, -1);
    }

    @Override
    public @Nullable Point @Nullable [] getCellPositions(Point start, Point end) {
        ArrayList<Point> cellPosList = new ArrayList<Point>();
        int i = 0;
        while (i < this.cells.numCells.x) {
            int j = 0;
            while (j < this.cells.numCells.y) {
                boolean hIntersect;
                Point cellPos = this.cells.cells[i][j].pos;
                Point cellSize = this.cells.cells[i][j].size;
                boolean bl = hIntersect = cellPos.x >= start.x && cellPos.x <= end.x || cellPos.x + cellSize.x >= start.x && cellPos.x + cellSize.x <= end.x || start.x >= cellPos.x && start.x <= cellPos.x + cellSize.x || end.x >= cellPos.x && end.x <= cellPos.x + cellSize.x;
                if (hIntersect) {
                    boolean vIntersect;
                    boolean bl2 = vIntersect = cellPos.y >= start.y && cellPos.y <= end.y || cellPos.y + cellSize.y >= start.y && cellPos.y + cellSize.y <= end.y || start.y >= cellPos.y && start.y <= cellPos.y + cellSize.y || end.y >= cellPos.y && end.y <= cellPos.y + cellSize.y;
                    if (vIntersect) {
                        cellPosList.add(new Point(i, j));
                    }
                }
                ++j;
            }
            ++i;
        }
        return cellPosList.toArray(new Point[cellPosList.size()]);
    }

    public CellsBox getCellsBox() {
        return this.cells;
    }

    public String getCornerText() {
        return this.cornerLabel.content;
    }

    public boolean getHLabelsVisible() {
        return this.hLabelsVisible;
    }

    @Override
    public VTable getModel() {
        return this.model;
    }

    @Override
    public Point getOffset() {
        return this.offset;
    }

    @Override
    public Point getSize() {
        return this.size;
    }

    public boolean isComputed() {
        return this.computed;
    }

    public boolean isHeaderVisible() {
        return this.headerIsVisible;
    }

    @Override
    public void precompute(GC gc, Point _offset) {
        if (!staticsComputed) {
            VTableFigure.precomputeStatics(gc);
            staticsComputed = true;
        }
        Font defaultFont = gc.getFont();
        gc.setFont(boldFont);
        this.offset.x = _offset.x;
        this.offset.y = _offset.y;
        this.precomputeHeaderLabelPosition(gc);
        this.precomputeCellsSize(gc);
        this.precomputeLabelCoords(gc);
        this.precomputeSize(gc);
        gc.setFont(defaultFont);
        this.precomputeDiscardedLineSegments();
        this.computed = true;
    }

    private void precomputeCellsSize(GC gc) {
        int vLabelWidth;
        int numRuns = 0;
        for (VScriptConfig scriptConfig : this.model.getScriptsConfig()) {
            if (!scriptConfig.isSelected()) continue;
            numRuns += scriptConfig.getNumRuns();
        }
        VParamVariation cellData = this.model.getParamVariation(new Point(0, 0));
        int numDigits = ("" + numRuns).length();
        char[] maxChars = new char[numDigits];
        Arrays.fill(maxChars, '0');
        int numTestsExt = gc.stringExtent((String)new String((char[])maxChars)).x;
        int errCellExt = gc.stringExtent((String)(cellData != null ? cellData.getConfErrorText() : "")).x;
        int skipCellExt = gc.stringExtent((String)(cellData != null ? cellData.getSkippText() : "")).x;
        int maxContentExt = numTestsExt;
        if (errCellExt > maxContentExt) {
            maxContentExt = errCellExt;
        }
        if (skipCellExt > maxContentExt) {
            maxContentExt = skipCellExt;
        }
        int optNameExt = -1;
        VParam[] vParamArray = this.model.getVParams();
        int n = vParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            String[] opsName = vParam.getOptNames();
            if (opsName != null) {
                String[] stringArray = opsName;
                int n3 = opsName.length;
                int n4 = 0;
                while (n4 < n3) {
                    String optName = stringArray[n4];
                    optNameExt = gc.stringExtent((String)optName).x;
                    if (optNameExt > maxContentExt) {
                        maxContentExt = optNameExt;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        int adjustedContentExt = vLabelWidth = gc.stringExtent((String)this.vLabel.content).x;
        if (this.cells.numCells.y > 0) {
            adjustedContentExt = vLabelWidth / this.cells.numCells.y;
        }
        if (adjustedContentExt > maxContentExt) {
            maxContentExt = adjustedContentExt;
        }
        Point cellSize = new Point(maxContentExt + 6, textHeight + 2);
        int hLabelLen = gc.stringExtent((String)this.hLabel.content).x + 6;
        int adjustedCellHeight = hLabelLen / this.cells.numCells.x;
        if (adjustedCellHeight > cellSize.y) {
            cellSize.y = adjustedCellHeight;
        }
        this.cells.setCellSize(cellSize);
    }

    private void precomputeDiscardedLineSegments() {
        int i = 0;
        while (i < this.cells.numCells.x) {
            int j = 0;
            while (j < this.cells.numCells.y) {
                this.cells.getCells()[i][j].precomputeDiscardedLineSegments();
                ++j;
            }
            ++i;
        }
    }

    private void precomputeHeaderLabelPosition(GC gc) {
        this.headerLabel.pos.x = this.offset.x;
        this.headerLabel.pos.y = this.offset.y;
        this.headerLabel.size.x = gc.stringExtent((String)this.headerLabel.content).x + 6;
        this.headerLabel.size.y = textHeight + 2;
        this.headerLabel.textPos.x = this.headerLabel.pos.x + 3;
        this.headerLabel.textPos.y = this.headerLabel.pos.y + 1;
    }

    private void precomputeHorizontalLabelCoords(GC gc) {
        this.hLabel.pos.x = this.headerLabel.pos.x;
        this.hLabel.size.x = textHeight + 6;
        this.hLabel.size.y = this.cells.cellSize.y * this.cells.numCells.x;
        if (!this.hLabelsVisible) {
            return;
        }
        int cornerExt = gc.stringExtent((String)this.cornerLabel.content).x;
        int numHparams = this.model.getHParams().length;
        int[] hOptNameExts = new int[numHparams];
        int i = 0;
        int strExt = 0;
        VParam[] vParamArray = this.model.getHParams();
        int n = vParamArray.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            hOptNameExts[i] = this.hParams[i].showLabel ? gc.stringExtent((String)hParam.getName()).x : 0;
            String[] opsNames = hParam.getOptNames();
            if (opsNames != null) {
                String[] stringArray = opsNames;
                int n3 = opsNames.length;
                int n4 = 0;
                while (n4 < n3) {
                    String hParamOptionName = stringArray[n4];
                    strExt = gc.stringExtent((String)hParamOptionName).x;
                    if (strExt > hOptNameExts[i]) {
                        hOptNameExts[i] = strExt;
                    }
                    ++n4;
                }
            }
            ++i;
            ++n2;
        }
        int hLabelsExt = this.hLabel.size.x;
        int[] nArray = hOptNameExts;
        int n5 = hOptNameExts.length;
        n = 0;
        while (n < n5) {
            int hOptNameExt = nArray[n];
            hLabelsExt += hOptNameExt;
            ++n;
        }
        if (hLabelsExt < cornerExt) {
            int diff = cornerExt - hLabelsExt;
            int diffPerParam = diff / numHparams + 1;
            i = 0;
            while (i < numHparams) {
                int n6 = i++;
                hOptNameExts[n6] = hOptNameExts[n6] + diffPerParam;
            }
        }
        i = 0;
        String[][] paramNames = new String[numHparams][];
        int[] paramNameExt = new int[numHparams];
        VParam[] vParamArray2 = this.model.getHParams();
        int n7 = vParamArray2.length;
        int n8 = 0;
        while (n8 < n7) {
            VParam hParam = vParamArray2[n8];
            paramNames[i] = VTableFigure.splitName(hParam.getName(), hOptNameExts[i]);
            int j = 0;
            while (j < paramNames[i].length) {
                int paramNameSplitExt = gc.stringExtent((String)paramNames[i][j]).x;
                if (paramNameExt[i] < paramNameSplitExt) {
                    paramNameExt[i] = paramNameSplitExt;
                }
                ++j;
            }
            ++i;
            ++n8;
        }
        i = 0;
        while (i < numHparams) {
            if (this.hParams[i].showLabel && hOptNameExts[i] < paramNameExt[i]) {
                hOptNameExts[i] = paramNameExt[i];
            }
            ++i;
        }
        this.cornerLabel.pos.x = this.offset.x;
        this.cornerLabel.pos.y = this.headerLabel.pos.y + this.headerLabel.size.y;
        this.cornerLabel.size.x = this.hLabel.size.x;
        i = 0;
        while (i < numHparams) {
            this.cornerLabel.size.x += hOptNameExts[i] + 6;
            ++i;
        }
        int prevPosX = this.hLabel.pos.x + this.hLabel.size.x;
        i = 0;
        while (i < numHparams) {
            this.hParams[i].paramOptions.pos.x = prevPosX;
            this.hParams[i].paramOptions.size.x = hOptNameExts[i] + 6;
            this.hParams[i].paramOptions.size.y = this.hLabel.size.y;
            this.hParams[i].paramLabel.lineTexts = paramNames[i];
            this.hParams[i].paramLabel.pos.x = prevPosX;
            this.hParams[i].paramLabel.size.x = hOptNameExts[i] + 6;
            this.hParams[i].paramLabel.size.y = paramNames.length * (textHeight + 4);
            this.hParams[i].paramLabel.size.y += -2;
            prevPosX += this.hParams[i].paramOptions.size.x;
            ++i;
        }
    }

    private void precomputeLabelCoords(GC gc) {
        this.precomputeHorizontalLabelCoords(gc);
        this.precomputeVerticalLabelCoords(gc);
        this.updateLabelPositions(gc);
        this.updateCellsPosition(gc);
    }

    private void precomputeSize(GC gc) {
        this.size.y = this.headerLabel.size.y;
        if (this.hLabelsVisible) {
            this.size.y += this.cornerLabel.size.y;
            if (this.hParams.length > 0) {
                this.size.y += this.hLabel.size.y;
                if (this.hParams[0].showLabel) {
                    this.size.y += this.hParams[0].paramLabel.size.y;
                }
            }
        } else {
            this.size.y += this.vLabel.size.y;
            ParamBox[] paramBoxArray = this.vParams;
            int n = this.vParams.length;
            int n2 = 0;
            while (n2 < n) {
                ParamBox vParam = paramBoxArray[n2];
                this.size.y += vParam.paramOptions.size.y;
                ++n2;
            }
            this.size.y += this.cells.size.y;
        }
        this.size.x = 0;
        if (this.hLabelsVisible) {
            this.size.x += this.cornerLabel.size.x;
        }
        this.size.x += this.vLabel.size.x;
        if (this.vParams.length > 0 && this.vParams[0].showLabel) {
            this.size.x += this.vParams[0].paramLabel.size.x;
        }
    }

    private void precomputeVerticalLabelCoords(GC gc) {
        this.vLabel.pos.y = this.headerLabel.pos.y + this.headerLabel.size.y;
        this.vLabel.size.x = gc.stringExtent((String)this.vLabel.content).x + 6;
        this.vLabel.size.y = textHeight + 2;
        int vParamOptWidth = this.cells.numCells.y * this.cells.cellSize.x;
        int prevPosY = this.vLabel.pos.y + this.vLabel.size.y;
        ParamBox[] paramBoxArray = this.vParams;
        int n = this.vParams.length;
        int n2 = 0;
        while (n2 < n) {
            ParamBox vParam = paramBoxArray[n2];
            vParam.paramOptions.pos.y = prevPosY;
            vParam.paramOptions.size.x = vParamOptWidth;
            vParam.paramOptions.size.y = textHeight + 2;
            vParam.paramLabel.pos.y = prevPosY;
            vParam.paramLabel.size.x = gc.stringExtent((String)vParam.paramLabel.lineTexts[0]).x + 6;
            vParam.paramLabel.size.y = textHeight + 2;
            prevPosY += vParam.paramOptions.size.y;
            ++n2;
        }
        this.vLabel.size.x = this.vParams.length > 0 ? this.vParams[0].paramOptions.size.x : this.cells.cellSize.x;
    }

    @Override
    public boolean reset() {
        this.cells.reset();
        return false;
    }

    public void setOffset(Point _offset) {
        this.offset.x = _offset.x;
        this.offset.y = _offset.y;
    }

    @Override
    public void setRunningCell(VParamVariation cellData) {
        cellData.updateCurrentRunModel();
        this.cells.runCellPos.x = cellData.getPos().x;
        this.cells.runCellPos.y = cellData.getPos().y;
    }

    @Override
    public void updateAllCellContents() {
        VParamVariation goldCell;
        int i = 0;
        while (i < this.cells.numCells.x) {
            int j = 0;
            while (j < this.cells.numCells.y) {
                VParamVariation param = this.model.getParamVariation(new Point(i, j));
                if (param != null) {
                    this.updateCellContents(param);
                }
                ++j;
            }
            ++i;
        }
        if (this.model.getOptions().precomputeGoldenVariation() && (goldCell = this.model.getGoldenVariation()) != null) {
            this.updateGoldenCellContents(goldCell);
        }
    }

    @Override
    public void updateAllCellContents(VParamVariation startCell) {
        Point pos = startCell == null ? new Point(0, 0) : startCell.getPos();
        int startY = pos.y;
        int i = pos.x;
        while (i < this.cells.numCells.x) {
            int j = startY;
            while (j < this.cells.numCells.y) {
                VParamVariation param = this.model.getParamVariation(new Point(i, j));
                if (param != null) {
                    this.updateCellContents(param);
                }
                ++j;
            }
            startY = 0;
            ++i;
        }
    }

    @Override
    public void updateCellContents(VParamVariation cellData) {
        Point p = cellData.getPos();
        CellBox cellFig = this.cells.cells[p.x][p.y];
        cellFig.extraContent = cellData.getState() != VParamVariation.VState.DEFAULT;
        cellFig.bgColor = null;
        cellFig.fgColor = null;
        cellFig.discarded = !cellData.isSelected();
        cellFig.contents = cellData.getText();
        switch (cellData.getState()) {
            case PARTIALY_PASSED: 
            case FAILED: {
                VRunResult[] res;
                if (!this.cellColoringEnabled || (res = cellData.getResults()) == null) break;
                VLoggingUtils.ScriptResultType scriptFailureType = VTableFigure.getWorstFailureType(res);
                cellFig.bgColor = VLoggingUtils.getFailureColor(scriptFailureType);
                break;
            }
            case PASSED: {
                cellFig.bgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_STABLE);
                break;
            }
            case PAUSED: {
                break;
            }
            case ERR_CODEGEN: {
                cellFig.fgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_RED);
                break;
            }
            case SKIPPED: {
                cellFig.fgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_GRAY);
                break;
            }
            case ERR_CONFIG: {
                cellFig.fgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_RED);
                break;
            }
        }
        cellData.nextRun();
    }

    private static VLoggingUtils.ScriptResultType getWorstFailureType(VRunResult[] res) {
        VLoggingUtils.ScriptResultType worstFail = VLoggingUtils.ScriptResultType.PASSED;
        VRunResult[] vRunResultArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            VRunResult result = vRunResultArray[n2];
            if (result.getFailureType().ordinal() > worstFail.ordinal()) {
                worstFail = result.getFailureType();
            }
            ++n2;
        }
        return worstFail;
    }

    private void updateCellsPosition(GC gc) {
        int n;
        int n2;
        ParamBox[] paramBoxArray;
        Point pos = new Point(this.offset.x, this.offset.y + this.headerLabel.size.y);
        pos.x = this.offset.x;
        pos.y = this.offset.y + this.headerLabel.size.y;
        if (this.hLabelsVisible) {
            pos.x += this.hLabel.size.x;
            paramBoxArray = this.hParams;
            n2 = this.hParams.length;
            n = 0;
            while (n < n2) {
                ParamBox hParam = paramBoxArray[n];
                pos.x += hParam.paramOptions.size.x;
                ++n;
            }
        }
        pos.y += this.vLabel.size.y;
        paramBoxArray = this.vParams;
        n2 = this.vParams.length;
        n = 0;
        while (n < n2) {
            ParamBox vParam = paramBoxArray[n];
            pos.y += vParam.paramOptions.size.y;
            ++n;
        }
        this.cells.setPos(pos);
    }

    @Override
    public void updateGoldenCellContents(VParamVariation cellData) {
        Point p = cellData.getPos();
        this.cells.goldCellPos.x = p.x;
        this.cells.goldCellPos.y = p.y;
        CellBox cellFig = this.cells.cells[p.x][p.y];
        cellFig.extraContent = true;
        cellFig.bgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.CELL_SELECTED);
        cellFig.contents = cellData.getText();
    }

    private void updateLabelPositions(GC gc) {
        int i;
        ParamBox[] paramBoxArray;
        int n;
        if (this.hLabelsVisible) {
            this.cornerLabel.size.y = this.vLabel.size.y;
            ParamBox[] paramBoxArray2 = this.vParams;
            n = this.vParams.length;
            int n2 = 0;
            while (n2 < n) {
                ParamBox vParam = paramBoxArray2[n2];
                this.cornerLabel.size.y += vParam.paramOptions.size.y;
                ++n2;
            }
            int cornerTextWidth = gc.stringExtent((String)this.cornerLabel.content).x;
            int cornerTextHeight = textHeight;
            this.cornerLabel.textPos.x = this.cornerLabel.pos.x + (this.cornerLabel.size.x - cornerTextWidth) / 2;
            this.cornerLabel.textPos.y = this.cornerLabel.pos.y + (this.cornerLabel.size.y - cornerTextHeight) / 2;
        }
        if (this.hLabelsVisible) {
            this.hLabel.pos.y = this.cornerLabel.pos.y + this.cornerLabel.size.y;
            int hLabelTextWidth = gc.stringExtent((String)this.hLabel.content).x;
            this.hLabel.tPos.x = this.hLabel.pos.x + 3;
            this.hLabel.tPos.y = this.hLabel.pos.y + this.hLabel.size.y - (this.hLabel.size.y - hLabelTextWidth) / 2;
            this.hLabel.textPos.x = 0;
            this.hLabel.textPos.y = 0;
            paramBoxArray = this.hParams;
            int n3 = this.hParams.length;
            n = 0;
            while (n < n3) {
                ParamBox hParam = paramBoxArray[n];
                hParam.paramOptions.pos.y = this.hLabel.pos.y;
                int optHeight = hParam.paramOptions.size.y;
                if (hParam.paramOptions.contents.length > 0) {
                    optHeight = hParam.paramOptions.size.y / hParam.paramOptions.contents.length;
                }
                i = 0;
                while (i < hParam.paramOptions.p1.length) {
                    hParam.paramOptions.p1[i].x = hParam.paramOptions.pos.x;
                    hParam.paramOptions.p1[i].y = hParam.paramOptions.pos.y + (i + 1) * optHeight;
                    hParam.paramOptions.p2[i].x = hParam.paramOptions.pos.x + hParam.paramOptions.size.x;
                    hParam.paramOptions.p2[i].y = hParam.paramOptions.pos.y + (i + 1) * optHeight;
                    ++i;
                }
                int optIdent = (optHeight - textHeight) / 2;
                int i2 = 0;
                while (i2 < hParam.paramOptions.textPos.length) {
                    hParam.paramOptions.textPos[i2].x = hParam.paramOptions.pos.x + 3;
                    hParam.paramOptions.textPos[i2].y = hParam.paramOptions.pos.y + i2 * optHeight + optIdent;
                    ++i2;
                }
                hParam.paramLabel.pos.y = hParam.paramOptions.pos.y + hParam.paramOptions.size.y;
                i2 = 0;
                while (i2 < hParam.paramLabel.lineTexts.length) {
                    int textWidth = gc.stringExtent((String)hParam.paramLabel.lineTexts[i2]).x;
                    int xTextOffset = (hParam.paramLabel.size.x - textWidth) / 2;
                    hParam.paramLabel.textPos[i2].x = hParam.paramLabel.pos.x + xTextOffset;
                    hParam.paramLabel.textPos[i2].y = hParam.paramLabel.pos.y + 1 + i2 * (4 + textHeight);
                    ++i2;
                }
                ++n;
            }
        }
        this.vLabel.pos.x = this.hLabelsVisible ? this.cornerLabel.pos.x + this.cornerLabel.size.x : this.headerLabel.pos.x;
        this.vLabel.tPos.x = 0;
        this.vLabel.tPos.y = 0;
        int vLabelTextWidth = gc.stringExtent((String)this.vLabel.content).x;
        this.vLabel.textPos.x = this.vLabel.pos.x + (this.vLabel.size.x - vLabelTextWidth) / 2;
        this.vLabel.textPos.y = this.vLabel.pos.y + 1;
        paramBoxArray = this.vParams;
        int n4 = this.vParams.length;
        n = 0;
        while (n < n4) {
            ParamBox vParam = paramBoxArray[n];
            vParam.paramOptions.pos.x = this.vLabel.pos.x;
            int optWidth = vParam.paramOptions.contents.length > 0 ? vParam.paramOptions.size.x / vParam.paramOptions.contents.length : vParam.paramOptions.size.x;
            i = 0;
            while (i < vParam.paramOptions.p1.length) {
                vParam.paramOptions.p1[i].x = vParam.paramOptions.pos.x + (i + 1) * optWidth;
                vParam.paramOptions.p1[i].y = vParam.paramOptions.pos.y;
                vParam.paramOptions.p2[i].x = vParam.paramOptions.pos.x + (i + 1) * optWidth;
                vParam.paramOptions.p2[i].y = vParam.paramOptions.pos.y + vParam.paramOptions.size.y;
                ++i;
            }
            i = 0;
            while (i < vParam.paramOptions.textPos.length) {
                int optTextWidth = gc.stringExtent((String)vParam.paramOptions.contents[i]).x;
                int optxIdent = (optWidth - optTextWidth) / 2;
                vParam.paramOptions.textPos[i].x = vParam.paramOptions.pos.x + i * optWidth + optxIdent;
                vParam.paramOptions.textPos[i].y = vParam.paramOptions.pos.y + 1;
                ++i;
            }
            vParam.paramLabel.pos.x = vParam.paramOptions.pos.x + vParam.paramOptions.size.x;
            vParam.paramLabel.textPos[0].x = vParam.paramLabel.pos.x + 3;
            vParam.paramLabel.textPos[0].y = vParam.paramLabel.pos.y + 1;
            ++n;
        }
    }

    private void updateSelectedCell(Point selCell) {
        if (this.hParams.length == 0) {
            this.hLabel.setHighlight(selCell.x != -1);
        }
        if (this.vParams.length == 0) {
            this.vLabel.setHighlight(selCell.y != -1);
        }
        if (selCell.x != -1 && selCell.y != -1) {
            int[] higtliteMap;
            ParamBox[] paramBoxArray = this.hParams;
            int n = this.hParams.length;
            int n2 = 0;
            while (n2 < n) {
                ParamBox hParamBox = paramBoxArray[n2];
                higtliteMap = hParamBox.paramOptions.getHiliteMap();
                if (higtliteMap != null) {
                    hParamBox.paramOptions.setHighlightIdx(higtliteMap[selCell.x]);
                }
                ++n2;
            }
            paramBoxArray = this.vParams;
            n = this.vParams.length;
            n2 = 0;
            while (n2 < n) {
                ParamBox vParamBox = paramBoxArray[n2];
                higtliteMap = vParamBox.paramOptions.getHiliteMap();
                if (higtliteMap != null) {
                    vParamBox.paramOptions.setHighlightIdx(higtliteMap[selCell.y]);
                }
                ++n2;
            }
        }
    }

    @Override
    public void updateSkipTableContents(VParamVariation firstCell) {
        Point startPos = new Point(0, 0);
        if (firstCell != null) {
            startPos = firstCell.getPos();
        }
        int i = 0;
        while (i < this.cells.numCells.x) {
            int j = 0;
            while (j < this.cells.numCells.y) {
                VParamVariation param;
                if ((i > startPos.x || i == startPos.x && j >= startPos.y) && (param = this.model.getParamVariation(new Point(i, j))) != null) {
                    this.updateCellContents(param);
                }
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void updateVLabelName(String content) {
        this.vLabel.content = content;
    }

    public static class CellBox {
        private Point pos = new Point(0, 0);
        private Point contentPos = new Point(0, 0);
        private Point size = new Point(0, 0);
        @Nullable
        private Color bgColor = null;
        @Nullable
        private Color fgColor = null;
        @Nullable
        private String contents = null;
        private boolean discarded;
        private boolean extraContent;
        private LineSegment @Nullable [] segments;

        public void draw(GC gc) {
            this.draw(gc, null);
        }

        public void draw(GC gc, @Nullable Color newBgColor) {
            if (newBgColor != null) {
                this.extraContent = true;
            }
            if (this.extraContent || this.discarded) {
                Color oldBg = gc.getBackground();
                Color oldFg = gc.getForeground();
                if (this.extraContent) {
                    String _contents;
                    if (newBgColor != null) {
                        gc.setBackground(newBgColor);
                    } else if (this.bgColor != null) {
                        gc.setBackground(this.bgColor);
                    }
                    gc.fillRectangle(this.pos.x, this.pos.y, this.size.x, this.size.y);
                    gc.drawRectangle(this.pos.x, this.pos.y, this.size.x, this.size.y);
                    if (this.fgColor != null) {
                        gc.setForeground(this.fgColor);
                    }
                    if ((_contents = this.contents) != null) {
                        int offsetX = Math.max((this.size.x - gc.stringExtent((String)_contents).x) / 2, 0);
                        gc.drawText(_contents, this.contentPos.x + offsetX, this.contentPos.y);
                    }
                }
                if (this.discarded) {
                    Color color = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.disabled_FG");
                    if (color != null) {
                        gc.setForeground(color);
                    }
                    if (this.segments != null) {
                        LineSegment[] lineSegmentArray = this.segments;
                        int n = this.segments.length;
                        int n2 = 0;
                        while (n2 < n) {
                            LineSegment ls = lineSegmentArray[n2];
                            gc.drawLine(ls.x1, ls.y1, ls.x2, ls.y2);
                            ++n2;
                        }
                    }
                }
                gc.setForeground(oldFg);
                gc.setBackground(oldBg);
            } else {
                String _contents = this.contents;
                if (_contents != null) {
                    int offsetX = Math.max((this.size.x - gc.stringExtent((String)_contents).x) / 2, 0);
                    gc.drawText(_contents, this.contentPos.x + offsetX, this.contentPos.y);
                }
            }
        }

        public @Nullable Color getBgColor() {
            return this.bgColor;
        }

        public @Nullable Color getFgColor() {
            return this.fgColor;
        }

        public Point getPos() {
            return this.pos;
        }

        public Point getSize() {
            return this.size;
        }

        public void precomputeDiscardedLineSegments() {
            this.precomputeDiscardedLineSegments(8.0f);
        }

        public void precomputeDiscardedLineSegments(float step) {
            ArrayList<LineSegment> segmList = new ArrayList<LineSegment>();
            double angle = 16.0;
            double x1 = this.pos.x;
            double x2 = x1 - angle;
            double y1 = this.pos.y;
            double y2 = y1 + (double)this.size.y;
            double scale = 1.0;
            while (x2 < (double)(this.pos.x + this.size.x)) {
                if (x2 < (double)this.pos.x) {
                    scale = (x1 - (double)this.pos.x) / angle;
                    x2 = this.pos.x;
                    segmList.add(new LineSegment((int)x1, (int)y1, (int)x2, (int)(y2 -= (double)this.size.y - (double)this.size.y * scale)));
                    x2 = (x1 += (double)step) - angle;
                    y2 = y1 + (double)this.size.y;
                    continue;
                }
                if (x1 > (double)(this.pos.x + this.size.x)) {
                    scale = ((double)(this.pos.x + this.size.x) - x2) / angle;
                    x1 = this.pos.x + this.size.x;
                    segmList.add(new LineSegment((int)x1, (int)(y1 += (double)this.size.y - (double)this.size.y * scale), (int)x2, (int)y2));
                    x1 = (x2 += (double)step) + angle;
                    y1 = this.pos.y;
                    continue;
                }
                segmList.add(new LineSegment((int)x1, (int)y1, (int)x2, (int)y2));
                x2 = (x1 += (double)step) - angle;
            }
            this.segments = segmList.toArray(new LineSegment[segmList.size()]);
        }

        public void reset() {
            this.bgColor = null;
            this.fgColor = null;
            this.contents = null;
            this.extraContent = false;
        }

        public void setBgColor(Color _bgColor) {
            this.bgColor = _bgColor;
        }

        public void setContents(String _contents) {
            this.contents = _contents;
        }

        public void setDiscarded(boolean _discarded) {
            this.discarded = _discarded;
        }

        public void setExtraContent(boolean _extraContent) {
            this.extraContent = _extraContent;
        }

        public void setFgColor(Color _fgColor) {
            this.fgColor = _fgColor;
        }

        public void setPos(Point _pos) {
            this.pos.x = _pos.x;
            this.pos.y = _pos.y;
            this.contentPos.x = this.pos.x;
            this.contentPos.y = this.pos.y + 1;
        }

        public void setSize(Point _size) {
            this.size = _size;
        }

        private static class LineSegment {
            public int x1;
            public int x2;
            public int y1;
            public int y2;

            public LineSegment(int _x1, int _y1, int _x2, int _y2) {
                this.x1 = _x1;
                this.y1 = _y1;
                this.x2 = _x2;
                this.y2 = _y2;
            }
        }
    }

    public static class CellsBox
    extends UiBox {
        private Point cellSize = new Point(0, 0);
        Point numCells = new Point(0, 0);
        private CellBox[][] cells;
        private Point[] hLinesStart;
        private Point[] hLinesEnd;
        private Point[] vLinesStart;
        private Point[] vLinesEnd;
        private Point goldCellPos = new Point(-1, -1);
        private Point userCellPos = new Point(-1, -1);
        private Point runCellPos = new Point(-1, -1);
        @Nullable
        private Color runCellBgColor;
        @Nullable
        private Color userCellBgColor;

        public CellsBox(Point _numCells) {
            this.color = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_BG");
            this.numCells = _numCells;
            this.cells = new CellBox[this.numCells.x][this.numCells.y];
            int i = 0;
            while (i < this.numCells.x) {
                int j = 0;
                while (j < this.numCells.y) {
                    this.cells[i][j] = new CellBox();
                    ++j;
                }
                ++i;
            }
            if (this.numCells.x > 0) {
                this.hLinesStart = new Point[this.numCells.x - 1];
                this.hLinesEnd = new Point[this.numCells.x - 1];
                i = 0;
                while (i < this.hLinesStart.length) {
                    this.hLinesStart[i] = new Point(0, 0);
                    this.hLinesEnd[i] = new Point(0, 0);
                    ++i;
                }
            } else {
                this.hLinesStart = new Point[0];
                this.hLinesEnd = new Point[0];
            }
            if (this.numCells.y > 0) {
                this.vLinesStart = new Point[this.numCells.y - 1];
                this.vLinesEnd = new Point[this.numCells.y - 1];
                i = 0;
                while (i < this.vLinesStart.length) {
                    this.vLinesStart[i] = new Point(0, 0);
                    this.vLinesEnd[i] = new Point(0, 0);
                    ++i;
                }
            } else {
                this.vLinesStart = new Point[0];
                this.vLinesEnd = new Point[0];
            }
            this.runCellBgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.LIGHT_BLUE);
            this.userCellBgColor = Activator.getDefault().getColor(UIResourceManager.ColorId.DARK_GREEN);
        }

        public void draw(PaintEvent e, boolean highlightRunningCell) {
            super.draw(e);
            int i = 0;
            while (i < this.hLinesStart.length) {
                e.gc.drawLine(this.hLinesStart[i].x, this.hLinesStart[i].y, this.hLinesEnd[i].x, this.hLinesEnd[i].y);
                ++i;
            }
            i = 0;
            while (i < this.vLinesStart.length) {
                e.gc.drawLine(this.vLinesStart[i].x, this.vLinesStart[i].y, this.vLinesEnd[i].x, this.vLinesEnd[i].y);
                ++i;
            }
            boolean cellDrawn = false;
            int i2 = 0;
            while (i2 < this.numCells.x) {
                int j = 0;
                while (j < this.numCells.y) {
                    cellDrawn = false;
                    if (i2 == this.runCellPos.x && j == this.runCellPos.y) {
                        this.cells[i2][j].draw(e.gc, highlightRunningCell ? this.runCellBgColor : null);
                        cellDrawn = true;
                    }
                    if (i2 == this.goldCellPos.x && j == this.goldCellPos.y) {
                        this.cells[i2][j].draw(e.gc);
                        cellDrawn = true;
                    }
                    if (i2 == this.userCellPos.x && j == this.userCellPos.y) {
                        this.cells[i2][j].draw(e.gc, this.userCellBgColor);
                        cellDrawn = true;
                    }
                    if (!cellDrawn) {
                        this.cells[i2][j].draw(e.gc, null);
                    }
                    ++j;
                }
                ++i2;
            }
        }

        public void draw(PaintEvent e, boolean hiliteRunCell, int i1, int i2) {
            this.draw(e, hiliteRunCell);
            Color oldFgGolor = e.gc.getForeground();
            int oldLineWidth = e.gc.getLineWidth();
            Color newFgColor = ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG");
            if (newFgColor != null) {
                e.gc.setForeground(newFgColor);
            }
            e.gc.setLineWidth(5);
            if (i1 < this.hLinesStart.length && i1 < this.hLinesEnd.length && i2 < this.hLinesStart.length && i2 < this.hLinesEnd.length) {
                e.gc.drawLine(this.hLinesStart[i1].x, this.hLinesStart[i1].y, this.hLinesEnd[i1].x, this.hLinesEnd[i1].y);
                e.gc.drawLine(this.hLinesStart[i2].x, this.hLinesStart[i2].y, this.hLinesEnd[i2].x, this.hLinesEnd[i2].y);
            }
            e.gc.setForeground(oldFgGolor);
            e.gc.setLineWidth(oldLineWidth);
        }

        public CellBox[][] getCells() {
            return (CellBox[][])this.cells.clone();
        }

        public Point getGoldCell() {
            return this.goldCellPos;
        }

        public Point getNumCells() {
            return this.numCells;
        }

        public Point getRunCell() {
            return this.runCellPos;
        }

        public Point getUserCell() {
            return this.userCellPos;
        }

        public void reset() {
            int i = 0;
            while (i < this.numCells.x) {
                int j = 0;
                while (j < this.numCells.y) {
                    this.cells[i][j].reset();
                    ++j;
                }
                ++i;
            }
            this.goldCellPos.x = -1;
            this.goldCellPos.y = -1;
            this.userCellPos.x = -1;
            this.userCellPos.y = -1;
            this.runCellPos.x = -1;
            this.runCellPos.y = -1;
        }

        public void setCellSize(Point _cellSize) {
            this.cellSize.x = _cellSize.x;
            this.cellSize.y = _cellSize.y;
            this.size.x = this.numCells.y * this.cellSize.x;
            this.size.y = this.numCells.x * this.cellSize.y;
            int i = 0;
            while (i < this.numCells.x) {
                int j = 0;
                while (j < this.numCells.y) {
                    this.cells[i][j].setSize(this.cellSize);
                    ++j;
                }
                ++i;
            }
        }

        public void setGoldCell(Point _goldCellPos) {
            this.goldCellPos.x = _goldCellPos.x;
            this.goldCellPos.y = _goldCellPos.y;
        }

        public void setPos(Point _pos) {
            this.pos.x = _pos.x;
            this.pos.y = _pos.y;
            Point cellPos = new Point(this.pos.x, this.pos.y);
            int i = 0;
            while (i < this.numCells.x) {
                int j = 0;
                while (j < this.numCells.y) {
                    this.cells[i][j].setPos(cellPos);
                    cellPos.x += this.cellSize.x;
                    ++j;
                }
                cellPos.x = this.pos.x;
                cellPos.y += this.cellSize.y;
                ++i;
            }
            i = 0;
            while (i < this.hLinesStart.length) {
                this.hLinesStart[i].x = this.pos.x;
                this.hLinesStart[i].y = this.pos.y + this.cellSize.y;
                this.hLinesEnd[i].x = this.pos.x + this.size.x;
                this.hLinesEnd[i].y = this.pos.y + this.cellSize.y;
                if (i > 0) {
                    this.hLinesStart[i].y = this.hLinesStart[i - 1].y + this.cellSize.y;
                    this.hLinesEnd[i].y = this.hLinesStart[i - 1].y + this.cellSize.y;
                }
                ++i;
            }
            i = 0;
            while (i < this.vLinesStart.length) {
                this.vLinesStart[i].x = this.pos.x + this.cellSize.x;
                this.vLinesStart[i].y = this.pos.y;
                this.vLinesEnd[i].x = this.pos.x + this.cellSize.x;
                this.vLinesEnd[i].y = this.pos.y + this.size.y;
                if (i > 0) {
                    this.vLinesStart[i].x = this.vLinesStart[i - 1].x + this.cellSize.x;
                    this.vLinesEnd[i].x = this.vLinesStart[i - 1].x + this.cellSize.x;
                }
                ++i;
            }
        }

        public void setRunCell(Point _runCellPos) {
            this.runCellPos.x = _runCellPos.x;
            this.runCellPos.y = _runCellPos.y;
        }

        public void setUserCell(Point _userCellPos) {
            if (this.goldCellPos.x != _userCellPos.x && this.goldCellPos.y != _userCellPos.y) {
                this.userCellPos.x = _userCellPos.x;
                this.userCellPos.y = _userCellPos.y;
            }
        }
    }

    public static class LabelBox
    extends UiBox {
        String content;
        private Point textPos;
        private boolean vertical;
        private boolean highlight;
        private Point tPos;
        @Nullable
        private Transform t;

        public LabelBox(String _content, boolean _vertical, @Nullable Transform _t, @Nullable Color _color) {
            this.color = _color;
            this.content = _content == null ? "" : _content;
            this.vertical = _vertical;
            this.t = _t;
            this.tPos = new Point(0, 0);
            this.textPos = new Point(0, 0);
        }

        @Override
        public void draw(PaintEvent e) {
            super.draw(e);
            Font defaultFont = null;
            if (this.isHighlight()) {
                defaultFont = e.gc.getFont();
                e.gc.setFont(boldFont);
            }
            Transform trans = this.t;
            if (this.vertical && trans != null) {
                trans.translate((float)this.tPos.x, (float)this.tPos.y);
                trans.rotate(-90.0f);
                e.gc.setTransform(this.t);
                e.gc.drawText(this.content, this.textPos.x, this.textPos.y);
                trans.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
                e.gc.setTransform(this.t);
            } else {
                e.gc.drawText(this.content, this.textPos.x, this.textPos.y);
            }
            if (this.isHighlight()) {
                e.gc.setFont(defaultFont);
            }
        }

        public boolean isHighlight() {
            return this.highlight;
        }

        public void setHighlight(boolean highlight) {
            this.highlight = highlight;
        }
    }

    public static class MultiLineLabelBox
    extends UiBox {
        private String[] lineTexts;
        private Point[] textPos;

        public MultiLineLabelBox(String[] _lineTexts) {
            this.lineTexts = (String[])_lineTexts.clone();
            this.textPos = new Point[this.lineTexts.length];
            int i = 0;
            while (i < this.textPos.length) {
                this.textPos[i] = new Point(0, 0);
                ++i;
            }
        }

        @Override
        public void draw(PaintEvent e) {
            super.draw(e);
            int i = 0;
            while (i < this.lineTexts.length) {
                e.gc.drawString(this.lineTexts[i], this.textPos[i].x, this.textPos[i].y);
                ++i;
            }
        }
    }

    public static class OptMultiBox
    extends UiBox {
        private String[] contents;
        private int @Nullable [] hiliteMap;
        private int highlightIdx;
        private Point[] p1;
        private Point[] p2;
        private Point[] textPos;

        public OptMultiBox(String[] _contents) {
            this.contents = (String[])_contents.clone();
            this.setHighlightIdx(-1);
            this.p1 = new Point[0];
            this.p2 = new Point[0];
            this.textPos = new Point[0];
            if (this.contents != null && this.contents.length > 0) {
                this.p1 = new Point[this.contents.length - 1];
                this.p2 = new Point[this.contents.length - 1];
                this.textPos = new Point[this.contents.length];
                int i = 0;
                while (i < this.contents.length) {
                    if (i < this.contents.length - 1) {
                        this.p1[i] = new Point(0, 0);
                        this.p2[i] = new Point(0, 0);
                        this.textPos[i] = new Point(0, 0);
                    } else {
                        this.textPos[i] = new Point(0, 0);
                    }
                    ++i;
                }
            }
        }

        @Override
        public void draw(PaintEvent e) {
            super.draw(e);
            int i = 0;
            while (i < this.contents.length - 1) {
                e.gc.drawLine(this.p1[i].x, this.p1[i].y, this.p2[i].x, this.p2[i].y);
                ++i;
            }
            i = 0;
            while (i < this.contents.length) {
                if (i != this.getHighlightIdx()) {
                    e.gc.drawText(this.contents[i], this.textPos[i].x, this.textPos[i].y);
                }
                ++i;
            }
            if (this.getHighlightIdx() != -1) {
                Font defaultFont = e.gc.getFont();
                e.gc.setFont(boldFont);
                e.gc.drawText(this.contents[this.getHighlightIdx()], this.textPos[this.getHighlightIdx()].x, this.textPos[this.getHighlightIdx()].y);
                e.gc.setFont(defaultFont);
            }
        }

        public int getHighlightIdx() {
            return this.highlightIdx;
        }

        public int @Nullable [] getHiliteMap() {
            return this.hiliteMap;
        }

        public void setHighlightIdx(int highlightIdx) {
            this.highlightIdx = highlightIdx;
        }

        public void setHiliteMap(int @Nullable [] hiliteMap) {
            this.hiliteMap = hiliteMap;
        }
    }

    public static class ParamBox {
        private boolean showLabel;
        private String paramName;
        private MultiLineLabelBox paramLabel;
        OptMultiBox paramOptions;
        private int numOptions;

        public ParamBox(boolean _showLabel, String _paramName, String[] _paramOpt, @Nullable Color paramColor, @Nullable Color paramOptColor, int _numOptions) {
            this.showLabel = _showLabel;
            this.paramName = _paramName;
            this.numOptions = _numOptions;
            this.paramLabel = new MultiLineLabelBox(new String[]{this.paramName});
            this.paramLabel.color = paramColor;
            this.paramOptions = new OptMultiBox(_paramOpt);
            this.paramOptions.color = paramOptColor;
        }

        public void draw(PaintEvent e) {
            if (this.showLabel) {
                this.paramLabel.draw(e);
            }
            this.paramOptions.draw(e);
        }
    }

    public static class UiBox {
        protected Point pos = new Point(0, 0);
        protected Point size = new Point(0, 0);
        @Nullable
        protected Color color;

        public void draw(PaintEvent e) {
            if (this.color != null) {
                e.gc.setBackground(this.color);
            }
            e.gc.fillRectangle(this.pos.x, this.pos.y, this.size.x, this.size.y);
            e.gc.drawRectangle(this.pos.x, this.pos.y, this.size.x, this.size.y);
        }
    }
}

