/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.presenter;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.jobs.ValidationJob;
import com.nxp.swtools.mem.validation.model.ARunResultsUpdaterListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.VSessionModel;
import com.nxp.swtools.mem.validation.model.ValidationModel;
import com.nxp.swtools.mem.validation.model.presenter.IDisplayFigure;
import com.nxp.swtools.mem.validation.model.presenter.Messages;
import com.nxp.swtools.mem.validation.model.presenter.ScenarioDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.SelectCellDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.SelectCellRegionDrawTool;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.VTableFigure;
import com.nxp.swtools.mem.validation.model.presenter.VTableScenarioPresentation;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.presenter.updaters.RunningCellHighlightRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.MainView;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.validation.engine.GenericProblemWithShowProblemDetails;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IProgressConstants;
import org.eclipse.ui.progress.UIJob;

public class ValidationPresentationModel {
    public static final String USER_SCRIPT_ID = "USER_SCRIPT_ID";
    public static final String USER_SCRIPT_NAME = "USER_SCRIPT_NAME";
    public static final String NEW_TEST_NAME_PREFIX = "Test ";
    public static final String NEW_TEST_SCRIPT_PREFIX = "user_script_";
    public static final String NEW_TEST_SCRIPT_SUFFIX = ".py";
    public static final String NEW_TEST_INPUT_PREFIX = "config_test_user_script_";
    public static final String NEW_TEST_INPUT_SUFFIX = ".json";
    public static final int DONT_WAIT = 0;
    public static final int WAIT_INDEFINITELY = -1;
    private static final Logger LOGGER = LogManager.getLogger(ValidationPresentationModel.class);
    private SelectionToolType activeToolType = SelectionToolType.SELECT_CELL;
    private Map<SelectionToolType, ScenarioDrawTool> toolMap = new EnumMap<SelectionToolType, ScenarioDrawTool>(SelectionToolType.class);
    @Nullable
    private Cursor backupCursor;
    private VPresentationModel parent;
    private ValidationModel model;
    private VStagePresentation @Nullable [] stages;
    private boolean autoSelected;
    @Nullable
    private VStagePresentation selectedStage;
    private boolean changeEnabled;
    private boolean userScriptsChanged;
    private boolean highlight;
    private HashMap<VScriptConfig, Set<String>> invalidScriptConfigs = new HashMap();
    private ValidationJob validationJob;
    private boolean configErrors;
    private boolean cellErrorColoringEnabled = true;
    @Nullable
    private RunningCellHighlightRunnable highlightRunnable;
    @Nullable
    VParamVariation runningCell;
    boolean bIsDarkTheme = ToolsColors.isDarkTheme();

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public ValidationPresentationModel(VPresentationModel _parent) {
        this.parent = _parent;
        this.model = Objects.requireNonNull(this.parent.getModel()).getValidationModel();
        this.changeEnabled = true;
        this.cellErrorColoringEnabled = true;
        this.toolMap.put(SelectionToolType.SELECT_CELL, new SelectCellDrawTool());
        this.toolMap.put(SelectionToolType.SELECT_REGION, new SelectCellRegionDrawTool());
        if (!this.parent.isViewDisposed()) {
            Canvas canvas = this.parent.getView().getScenarioView().getCanvas();
            if (canvas != null) {
                this.backupCursor = canvas.getCursor();
            }
            this.highlightRunnable = new RunningCellHighlightRunnable(this);
        }
        this.validationJob = new ValidationJob(this.parent);
        this.validationJob.setPriority(30);
        this.validationJob.setSystem(true);
        this.validationJob.setProperty(IProgressConstants.PROPERTY_IN_DIALOG, Boolean.FALSE);
    }

    public void addInvalidScriptConfig(VScriptConfig scriptConfig, String paramName) {
        String tooltip;
        String source = String.valueOf(scriptConfig.getScript().getName()) + ": " + paramName;
        Object scriptOwner = scriptConfig.getOwner();
        if (scriptOwner != null) {
            tooltip = MessageFormat.format(UtilsText.safeString((String)Messages.InvalidScriptConfig_ProblemTooltip), scriptOwner.toString(), scriptConfig.getScript().getName());
        } else {
            LOGGER.warning("Could not retrieve owner for invalid script config");
            tooltip = "";
        }
        String resource = UtilsText.safeString((String)Messages.ValidationProblemResource);
        String message = MessageFormat.format(UtilsText.safeString((String)Messages.InvalidParameterOfScriptConfig_ProblemMessage), paramName);
        if (this.invalidScriptConfigs.containsKey(scriptConfig)) {
            if (this.invalidScriptConfigs.get(scriptConfig).add(paramName)) {
                GenericProblemWithShowProblemDetails problem = new GenericProblemWithShowProblemDetails("DDR", 2, message, source, resource, tooltip);
                ValidationEngineFactory.addProblem((IGenericProblem)problem);
            }
        } else {
            HashSet<String> paramNameSet = new HashSet<String>();
            paramNameSet.add(paramName);
            this.invalidScriptConfigs.put(scriptConfig, paramNameSet);
            GenericProblemWithShowProblemDetails problem = new GenericProblemWithShowProblemDetails("DDR", 2, message, source, resource, tooltip);
            ValidationEngineFactory.addProblem((IGenericProblem)problem);
        }
    }

    void applyToolCursor() {
        Canvas scenCanvas;
        MainView mainView = this.parent.getView();
        if (!mainView.isDisposed() && (scenCanvas = mainView.getScenarioView().getCanvas()) != null) {
            switch (this.activeToolType) {
                case SELECT_CELL: {
                    scenCanvas.setCursor(this.backupCursor);
                    break;
                }
                case SELECT_REGION: {
                    scenCanvas.setCursor(Display.getDefault().getSystemCursor(2));
                }
            }
        }
    }

    public void cancelJob(int timeout) {
        this.validationJob.cancel();
        if (timeout == 0) {
            return;
        }
        long startMs = System.currentTimeMillis();
        while (this.validationJob.getState() == 4) {
            if (timeout != -1 && System.currentTimeMillis() - startMs > (long)timeout) {
                LOGGER.warning("Timed out waiting for validation job to complete");
                break;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                LOGGER.warning("Wait for cancelled job was interrupted " + e.getMessage());
                break;
            }
        }
    }

    public boolean checkSafeToDelete(List<VScript> scriptList) {
        if (this.selectedStage == null) {
            return false;
        }
        for (VScript script : scriptList) {
            if (script.isUserScript()) continue;
            return false;
        }
        boolean safeToDelete = true;
        for (VScript script : scriptList) {
            VStage[] vStageArray = this.model.getValidationStages();
            int n = vStageArray.length;
            int n2 = 0;
            while (n2 < n) {
                VStage stage = vStageArray[n2];
                boolean bl = safeToDelete = safeToDelete && stage.safeToDelete(script);
                if (!safeToDelete) {
                    return safeToDelete;
                }
                ++n2;
            }
        }
        return safeToDelete;
    }

    public boolean checkSafeToDelete(VScript script) {
        if (this.selectedStage == null) {
            return false;
        }
        if (!script.isUserScript()) {
            return false;
        }
        return Objects.requireNonNull(this.selectedStage).getModel().safeToDelete(script);
    }

    private boolean deleteScript(VScript script) {
        boolean success = this.model.deleteScript(script);
        return success;
    }

    public boolean deleteScripts(List<VScript> scriptList) {
        if (this.selectedStage == null) {
            return false;
        }
        boolean success = true;
        for (VScript script : scriptList) {
            boolean bl = success = success && this.deleteScript(script);
        }
        ValidationContext context = ValidationContext.getInstance();
        context.setModel(this.parent);
        this.model.updateTables(context);
        return success;
    }

    public void disableHighlight() {
        this.highlight = false;
    }

    public void enableCellErrorColoring(boolean enabled) {
        this.cellErrorColoringEnabled = enabled;
        if (this.stages != null) {
            VStagePresentation[] vStagePresentationArray = this.stages;
            int n = this.stages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                VTableScenarioPresentation[] vTableScenarioPresentationArray = stage.getScenarios();
                int n3 = vTableScenarioPresentationArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VTableScenarioPresentation scenData = vTableScenarioPresentationArray[n4];
                    IDisplayFigure[][] tables = scenData.getTableFigures();
                    if (tables != null) {
                        IDisplayFigure[][] iDisplayFigureArray = tables;
                        int n5 = tables.length;
                        int n6 = 0;
                        while (n6 < n5) {
                            IDisplayFigure[] tablesRow;
                            IDisplayFigure[] iDisplayFigureArray2 = tablesRow = iDisplayFigureArray[n6];
                            int n7 = tablesRow.length;
                            int n8 = 0;
                            while (n8 < n7) {
                                IDisplayFigure tableFigure = iDisplayFigureArray2[n8];
                                tableFigure.enableCellColoring(enabled);
                                ++n8;
                            }
                            ++n6;
                        }
                        scenData.updateTableContents();
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public @Nullable ScenarioDrawTool getActiveTool() {
        return this.toolMap.get((Object)this.activeToolType);
    }

    public SelectionToolType getActiveToolType() {
        return this.activeToolType;
    }

    private VParamVariation @Nullable [] getCellsInRegion(Point p1, Point p2) {
        if (this.selectedStage != null) {
            VScenarioPresentation scenario = this.selectedStage.getSelectedScenario();
            return scenario != null ? scenario.getCellsInRegion(p1, p2) : null;
        }
        return null;
    }

    public Collection<ScenarioDrawTool> getDrawTools() {
        return this.toolMap.values();
    }

    public @Nullable Set<String> getInvalidParamsForScript(VScriptConfig scriptConfig) {
        return this.invalidScriptConfigs.get(scriptConfig);
    }

    public VScriptConfig[] getInvalidScriptConfigs() {
        return this.invalidScriptConfigs.keySet().toArray(new VScriptConfig[this.invalidScriptConfigs.keySet().size()]);
    }

    public ValidationModel getModel() {
        return this.model;
    }

    public VPresentationModel getParent() {
        return this.parent;
    }

    public @Nullable VSessionModel.VEvent getResumeEvent() {
        return this.validationJob.getLastEvent();
    }

    public @Nullable SelectCellRegionDrawTool getSelectCellRegionTool() {
        return (SelectCellRegionDrawTool)this.toolMap.get((Object)SelectionToolType.SELECT_REGION);
    }

    public @Nullable VStagePresentation getSelectedStage() {
        return this.selectedStage;
    }

    public @Nullable VStagePresentation getStage(String name) {
        if (this.stages != null) {
            VStagePresentation[] vStagePresentationArray = this.stages;
            int n = this.stages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                if (stage.getModel().getName().equals(name)) {
                    return stage;
                }
                ++n2;
            }
        }
        return null;
    }

    public VStagePresentation @Nullable [] getStages() {
        return this.stages != null ? (VStagePresentation[])this.stages.clone() : null;
    }

    public boolean getUserScriptsChanged() {
        return this.userScriptsChanged;
    }

    public static String getValidationProblemResourceName() {
        return Messages.ValidationProblemResource;
    }

    public boolean hasConfigErrors() {
        return this.configErrors;
    }

    public boolean hasScriptConfigErrors(VScenarioPresentation selectedScenario) {
        for (VScriptConfig script : selectedScenario.getModel().getScriptsConfig()) {
            if (!this.invalidScriptConfigs.containsKey(script) || !script.isSelected()) continue;
            return true;
        }
        return false;
    }

    public boolean isAnyJobRunning() {
        return this.isValidationJobRunning();
    }

    public boolean isAutoSelected() {
        return this.autoSelected;
    }

    public boolean isCellErrorColoringEnabled() {
        return this.cellErrorColoringEnabled;
    }

    public boolean isChangedEnabled() {
        return this.changeEnabled;
    }

    public boolean isHighlight() {
        return this.highlight;
    }

    public boolean isScriptConfigInvalid(VScriptConfig scriptConfig) {
        return this.invalidScriptConfigs.containsKey(scriptConfig);
    }

    private boolean isValidationJobRunning() {
        return this.validationJob.getState() == 4 || this.validationJob.getState() == 2;
    }

    public void onCanvasMouseDown(Point clickPoint) {
    }

    public @Nullable VParamVariation getRunningCell() {
        return this.runningCell;
    }

    public void updateTheme(boolean isDarkTheme) {
        VStagePresentation[] myStages = this.stages;
        if (myStages == null) {
            return;
        }
        VStagePresentation[] vStagePresentationArray = myStages;
        int n = myStages.length;
        int n2 = 0;
        while (n2 < n) {
            VStagePresentation stage = vStagePresentationArray[n2];
            VTableScenarioPresentation[] vTableScenarioPresentationArray = stage.getScenarios();
            int n3 = vTableScenarioPresentationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                VTableScenarioPresentation scenarioPresentation = vTableScenarioPresentationArray[n4];
                for (IDisplayFigure figure : scenarioPresentation.getTables()) {
                    if (!(figure instanceof VTableFigure)) continue;
                    VTableFigure table = (VTableFigure)figure;
                    table.updateTheme(isDarkTheme);
                }
                ++n4;
            }
            ++n2;
        }
    }

    public void onPaint(@Nullable PaintEvent e) {
        if (e != null) {
            if (e.gc.isDisposed()) {
                return;
            }
            boolean isDarkTheme = ToolsColors.isDarkTheme();
            if (this.bIsDarkTheme != isDarkTheme) {
                this.bIsDarkTheme = isDarkTheme;
                this.updateTheme(this.bIsDarkTheme);
            }
            if (this.selectedStage == null) {
                return;
            }
            VScenarioPresentation crtFigure = Objects.requireNonNull(this.selectedStage).getSelectedScenario();
            if (crtFigure != null) {
                e.gc.setAdvanced(true);
                e.gc.setAntialias(1);
                crtFigure.draw(e, this.highlight);
                ScrolledComposite canvasPanel = this.parent.getView().getScenarioView().getCanvasPanel();
                if (canvasPanel != null) {
                    int canvasXsize = canvasPanel.getMinWidth();
                    int canvasYsize = canvasPanel.getMinHeight();
                    if (canvasXsize != crtFigure.getSize().x || canvasYsize != crtFigure.getSize().y) {
                        canvasPanel.setMinSize(crtFigure.getSize());
                    }
                }
            }
        }
    }

    public boolean onSelectCell(Point clickPoint) {
        if (this.selectedStage == null) {
            return false;
        }
        if (Objects.requireNonNull(this.selectedStage).getSelectedScenario() == null) {
            return false;
        }
        VScenarioPresentation scenFig = Objects.requireNonNull(this.selectedStage).getSelectedScenario();
        boolean selectionOk = false;
        if (scenFig != null) {
            selectionOk = scenFig.setSelection(clickPoint);
        }
        this.updateSelectCellTool();
        return selectionOk;
    }

    public void onSelectCellRegionEnd(Point p, boolean ctrlPressed) {
        SelectCellRegionDrawTool regionTool = this.getSelectCellRegionTool();
        if (regionTool != null) {
            regionTool.setEnd(p);
            regionTool.setActive(false);
            if (this.selectedStage != null) {
                VScenarioPresentation scenario = this.selectedStage.getSelectedScenario();
                if (scenario == null) {
                    return;
                }
                VParamVariation[] selectedCells = this.getCellsInRegion(regionTool.getStart(), regionTool.getEnd());
                if (selectedCells != null) {
                    VParamVariation[] vParamVariationArray = selectedCells;
                    int n = selectedCells.length;
                    int n2 = 0;
                    while (n2 < n) {
                        VParamVariation cell = vParamVariationArray[n2];
                        if (cell.getParent().getOptions().allowCellSkip()) {
                            cell.setSelected(!cell.isSelected());
                            boolean selected = false;
                            VParamVariation[][] vParamVariationArray2 = cell.getParent().getParamVariations();
                            int n3 = vParamVariationArray2.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                VParamVariation[] cellRow;
                                VParamVariation[] vParamVariationArray3 = cellRow = vParamVariationArray2[n4];
                                int n5 = cellRow.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    VParamVariation cellR = vParamVariationArray3[n6];
                                    selected |= cellR.isSelected();
                                    ++n6;
                                }
                                ++n4;
                            }
                            cell.getParent().setSelected(selected);
                        } else if (cell.getParent().getOptions().allowTableSkip()) {
                            cell.getParent().invertCellSelection();
                        }
                        ++n2;
                    }
                }
                scenario.updateTableContents();
                if (!ctrlPressed) {
                    this.setActiveToolType(SelectionToolType.SELECT_CELL);
                }
            }
        }
    }

    public void onSelectCells() {
        this.activeToolType = SelectionToolType.SELECT_REGION;
    }

    public void onUpdateRunningCell(VStage stage, VScenario scenData, VTable table, VParamVariation cell) {
        IDisplayFigure tableFig;
        VScenarioPresentation scenario;
        VStagePresentation stagePres = this.getStage(stage.getName());
        if (stagePres != null && (scenario = stagePres.getFigure(scenData)) != null && (tableFig = scenario.getTableFigure(table)) != null) {
            scenario.setRunningCell(table, cell);
            this.runningCell = cell;
        }
    }

    public void onUpdateTableVisibility() {
        if (this.stages != null) {
            VStagePresentation[] vStagePresentationArray = this.stages;
            int n = this.stages.length;
            int n2 = 0;
            while (n2 < n) {
                VStagePresentation stage = vStagePresentationArray[n2];
                if (stage.isVisible()) {
                    stage.onUpdateTableVisibility();
                }
                ++n2;
            }
        }
    }

    public void onValidationCellFinished(VStage stage, VScenario scenData, VParamVariation cell) {
        VScenarioPresentation scenario;
        VStagePresentation stagePres = this.getStage(stage.getName());
        if (stagePres != null && (scenario = stagePres.getFigure(scenData)) != null) {
            scenario.updateCellContents(cell);
        }
    }

    public void onValidationCellSkip(VStagePresentation stage, VScenario scenData, VTable table, VParamVariation cell) {
        VScenarioPresentation scenario = stage.getFigure(scenData);
        if (scenario != null) {
            scenario.updateCellContents(cell);
        }
    }

    public void onValidationCellSkip(VStagePresentation stage, VScenario scenData, VTable table, VParamVariation cell, int lastResultIdx) {
        VScenarioPresentation scenario = stage.getFigure(scenData);
        if (scenario != null) {
            scenario.updateCellContents(cell);
        }
    }

    public void onValidationRunResults(VStage stage, VScenario scenData, VRunResult result) {
        VStagePresentation stagePres = this.getStage(stage.getName());
        if (stagePres != null) {
            VScenarioPresentation scenario = stagePres.getFigure(scenData);
            VParamVariation cell = result.getParamVariation();
            if (scenario != null) {
                scenario.updateCellContents(cell);
            }
        }
    }

    public void onValidationStart(VStagePresentation stage, VScenario scenData, VTable table, VParamVariation cell) {
        VScenarioPresentation scenario = stage.getFigure(scenData);
        if (scenario != null) {
            scenario.updateCellContents(cell);
        }
    }

    public void onValidationTableFinish(VStage stage, VScenario scenData, VTable table) {
        this.onValidationTableFinish(stage, scenData, table, false, null);
    }

    public void onValidationTableFinish(VStage stage, VScenario scenData, VTable table, boolean cancelled, @Nullable VParamVariation startCell) {
        IDisplayFigure tableFig;
        VScenarioPresentation scenario;
        VStagePresentation stagePres = this.getStage(stage.getName());
        if (stagePres != null && (scenario = stagePres.getFigure(scenData)) != null && (tableFig = scenario.getTableFigure(table)) != null) {
            VParamVariation goldCell;
            if (table.getOptions().precomputeGoldenVariation() && (goldCell = table.getGoldenVariation()) != null) {
                tableFig.updateGoldenCellContents(goldCell);
            }
            if (cancelled && startCell != null) {
                tableFig.updateSkipTableContents(startCell);
            }
        }
    }

    public void onValidationTableSkip(VStage stage, VScenario scenData, VTable table, VParamVariation cell) {
        IDisplayFigure tableFig;
        VScenarioPresentation scenario;
        VStagePresentation stagePres = this.getStage(stage.getName());
        if (stagePres != null && (scenario = stagePres.getFigure(scenData)) != null && (tableFig = scenario.getTableFigure(table)) != null) {
            tableFig.updateAllCellContents();
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void removeInvalidScriptConfig(VScriptConfig scriptConfig, String paramName) {
        Set<String> paramSet = this.getInvalidParamsForScript(scriptConfig);
        if (paramSet != null && paramSet.remove(paramName)) {
            if (paramSet.isEmpty()) {
                this.invalidScriptConfigs.remove(scriptConfig);
            }
            String source = String.valueOf(scriptConfig.getScript().getName()) + ": " + paramName;
            @NonNull Collection collection = ValidationEngineFactory.getProblemsCollection();
            for (IBaseProblem problem : collection) {
                if (!((IGenericProblem)problem).getSource().equals(source)) continue;
                ValidationEngineFactory.deleteProblem((IBaseProblem)problem);
                break;
            }
        }
    }

    public void resetView() {
        if (this.highlightRunnable != null) {
            this.highlightRunnable.refreshCanvas();
        } else {
            LOGGER.severe("reserView: highlightRunnable is null");
        }
    }

    public void runOnCancelValidationJobUpdater() {
        this.validationJob.runOnCancelUpdater();
    }

    public void scheduleJob(VStagePresentation stage, ARunResultsUpdaterListener handler, boolean resume) {
        if (resume) {
            this.validationJob.setReuseSession(true);
        }
        this.validationJob.setRunResultsUpdaterListener(handler);
        this.validationJob.schedule();
    }

    public void setActiveToolType(SelectionToolType _activeToolType) {
        this.activeToolType = _activeToolType;
        final MainView view = this.parent.getView();
        if (this.parent.isViewDisposed()) {
            ValidationPresentationModel.trace("Attempting to operate with an invalid UI");
            return;
        }
        if (Display.getCurrent() != null) {
            this.applyToolCursor();
        }
        UIJob wjob = new UIJob(Display.getDefault(), "Updating mouse cursor..."){

            public IStatus runInUIThread(@Nullable IProgressMonitor monitor) {
                if (!view.isDisposed()) {
                    ValidationPresentationModel.this.applyToolCursor();
                }
                return Objects.requireNonNull(Status.OK_STATUS);
            }
        };
        wjob.setSystem(true);
        wjob.schedule();
    }

    public void setChangedEnabled(boolean _changeEnabled) {
        this.changeEnabled = _changeEnabled;
    }

    public void setConfigErrors(boolean _configErrors) {
        this.configErrors = _configErrors;
    }

    public boolean setSelectedScenario(IScenarioElement elem, boolean updateChecked, boolean isChecked) {
        if (updateChecked && !this.changeEnabled) {
            return false;
        }
        if (this.selectedStage == null) {
            return false;
        }
        if (updateChecked) {
            this.updateCheckStateCascadeDown(elem, isChecked);
            IScenarioElement elParent = elem.getParent();
            if (elParent != null) {
                this.updateCheckStateCascadeUp(elParent);
            }
        }
        if (Objects.requireNonNull(this.selectedStage).isAutoSelected()) {
            Objects.requireNonNull(this.selectedStage).setScenarioAutoSelected(false);
            return false;
        }
        Objects.requireNonNull(this.selectedStage).setSelectedScenarioElement(elem);
        return true;
    }

    public void setSelectedStage(VStagePresentation _selectedStage) {
        if (this.autoSelected) {
            this.autoSelected = false;
            return;
        }
        this.selectedStage = _selectedStage;
    }

    public void setStageAutoSelected(boolean _autoSelected) {
        this.autoSelected = _autoSelected;
    }

    public void setStages(VStagePresentation[] stages) {
        this.stages = (VStagePresentation[])stages.clone();
        VStagePresentation[] vStagePresentationArray = stages;
        int n = stages.length;
        int n2 = 0;
        while (n2 < n) {
            VStagePresentation stage = vStagePresentationArray[n2];
            stage.setParent(this);
            if (stage.isVisible()) {
                this.selectedStage = stage;
                this.autoSelected = false;
                break;
            }
            ++n2;
        }
    }

    public void setUserScriptsChanged(boolean userScriptsChanged) {
        this.userScriptsChanged = userScriptsChanged;
    }

    public void startHighlight() {
        RunningCellHighlightRunnable highlightRunnableLoc = this.highlightRunnable;
        if (highlightRunnableLoc != null) {
            if (!highlightRunnableLoc.isRunning()) {
                highlightRunnableLoc.setRunning(true);
                Display.getDefault().asyncExec((Runnable)highlightRunnableLoc);
            }
        } else {
            LOGGER.severe("startHighlight: highlightRunnable is null");
        }
    }

    public void stopHighlight() {
        RunningCellHighlightRunnable highlightRunnableLoc = this.highlightRunnable;
        if (highlightRunnableLoc != null) {
            if (highlightRunnableLoc.isRunning()) {
                highlightRunnableLoc.setRunning(false);
            }
        } else {
            LOGGER.severe("stopHighlight: highlightRunnable is null");
        }
    }

    public void unpauseJob() {
        this.validationJob.setProperty(null, null);
    }

    private void updateCheckStateCascadeDown(IScenarioElement elem, boolean isChecked) {
        boolean prevChecked = elem.isSelected();
        elem.setSelected(isChecked);
        this.updateNumSelections(prevChecked, isChecked);
        IScenarioElement[] iScenarioElementArray = elem.getChildren();
        int n = iScenarioElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement child = iScenarioElementArray[n2];
            if (!(child instanceof VScenario) || ((VScenario)child).isVisible()) {
                this.updateCheckStateCascadeDown(child, isChecked);
            }
            ++n2;
        }
    }

    private void updateCheckStateCascadeUp(IScenarioElement elem) {
        boolean allChildrenSelected = true;
        IScenarioElement[] iScenarioElementArray = elem.getChildren();
        int n = iScenarioElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IScenarioElement child = iScenarioElementArray[n2];
            if (child instanceof VScenario) {
                if (((VScenario)child).isVisible()) {
                    allChildrenSelected = allChildrenSelected && child.isSelected();
                }
            } else {
                allChildrenSelected = allChildrenSelected && child.isSelected();
            }
            ++n2;
        }
        boolean prevChecked = elem.isSelected();
        elem.setSelected(allChildrenSelected);
        this.updateNumSelections(prevChecked, allChildrenSelected);
        IScenarioElement elParent = elem.getParent();
        if (elParent != null) {
            this.updateCheckStateCascadeUp(elParent);
        }
    }

    public void updateHighlight() {
        this.highlight = !this.highlight;
    }

    private void updateNumSelections(boolean prevCheck, boolean crtCheck) {
        if (this.selectedStage == null) {
            return;
        }
        if (prevCheck != crtCheck) {
            if (crtCheck) {
                Objects.requireNonNull(this.selectedStage).incrementNumSelections();
            } else {
                Objects.requireNonNull(this.selectedStage).decrementNumSelections();
            }
        }
    }

    public void updateSelectCellTool() {
        VParamVariation cell;
        VScenarioPresentation scenFig;
        if (this.selectedStage != null && (scenFig = this.selectedStage.getSelectedScenario()) != null && (cell = scenFig.getSelectedCell()) != null) {
            IDisplayFigure tableFig = scenFig.getTableFigure(cell.getParent());
            SelectCellDrawTool selCellTool = (SelectCellDrawTool)this.toolMap.get((Object)SelectionToolType.SELECT_CELL);
            if (selCellTool != null && tableFig != null) {
                Point cellPos = tableFig.getCellBoxPos(cell.getPos());
                Point cellSize = tableFig.getCellBoxSize(cell.getPos());
                if (cellPos != null && cellSize != null) {
                    selCellTool.setCellPos(cellPos);
                    selCellTool.setCellSize(cellSize);
                }
            }
        }
    }

    public void waitForAnyJobToFinish() {
        this.waitForJobToFinish();
    }

    private void waitForJobToFinish() {
        try {
            while (this.validationJob.getState() == 4) {
                Thread.sleep(100L);
            }
        }
        catch (Exception e) {
            LOGGER.severe("Exception while waiting for the validation job to finish!" + e.getMessage());
        }
    }

    public static enum SelectionToolType {
        SELECT_REGION,
        SELECT_CELL;

    }
}

