/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Tables {
    private List<VTable> tableList = new ArrayList<VTable>();
    private Map<String, VTable> tableMap = new HashMap<String, VTable>();

    public Tables(List<VTable> _tableList) {
        this.tableList.addAll(_tableList);
        for (VTable table : this.tableList) {
            this.tableMap.put(table.getId(), table);
        }
    }

    public Tables(Tables model, Scripts scripts, ValidationContext vContext) {
        for (VTable protoTable : model.getTables()) {
            VTable table = new VTable(protoTable, null, scripts, vContext);
            this.tableList.add(table);
            this.tableMap.put(table.getId(), table);
        }
    }

    public VTable getTable(String tableName) {
        return Objects.requireNonNull(this.tableMap.get(tableName));
    }

    public List<VTable> getTables() {
        return this.tableList;
    }

    public VTable[] getTables(String idSubstr) {
        ArrayList<VTable> myTables = new ArrayList<VTable>();
        for (VTable table : this.tableList) {
            if (!table.getId().contains(idSubstr)) continue;
            myTables.add(table);
        }
        return myTables.toArray(new VTable[myTables.size()]);
    }

    public void populate(ValidationContext vContext) {
        for (VTable table : this.tableList) {
            table.populate(vContext);
        }
    }

    public void update(ValidationContext vContext) {
        for (VTable table : this.tableList) {
            table.setVisible(true);
        }
        for (VTable table : this.tableList) {
            table.update(vContext);
        }
    }
}

