/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.ParserUtility;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.Tables;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VScenarioGroup;
import com.nxp.swtools.mem.validation.model.scenarios.VStage;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VScenarioParser {
    protected static final Logger LOGGER = LogManager.getLogger(VScenarioParser.class);
    public static final String TAG_VALIDATION_STAGE = "validation-stage";
    public static final String TAG_VALIDATION_ELEMENT = "validation-element";
    public static final String ATTRIB_TYPE = "type";
    public static final String ATTRIB_NAME = "name";
    public static final String ATTRIB_ID = "id";
    public static final String ATTRIB_VISIBLE = "visible";
    public static final String TYPE_VALIDATION_STAGE = "validation-stage";
    public static final String TYPE_SCENARIO_GROUP = "scenario-group";
    public static final String TYPE_SCENARIO = "scenario";
    public static final String TYPE_TABLE_GROUP = "table-group";
    public static final String TYPE_TABLE = "table";
    @Nullable
    private static Tables tables;
    private static Map<String, String[]> typeMap;

    static {
        typeMap = new HashMap<String, String[]>();
        typeMap.put("validation-stage", new String[]{TYPE_SCENARIO_GROUP, TYPE_SCENARIO});
        typeMap.put(TYPE_SCENARIO_GROUP, new String[]{TYPE_SCENARIO_GROUP, TYPE_SCENARIO});
        typeMap.put(TYPE_SCENARIO, new String[]{TYPE_TABLE, TYPE_TABLE_GROUP});
        typeMap.put(TYPE_TABLE_GROUP, new String[]{TYPE_TABLE});
        typeMap.put(TYPE_TABLE, new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable IScenarioElement parseScenarioElement(@Nullable IScenarioElement parent, Node node, String[] validTypes) {
        String type = null;
        String name = null;
        String id = null;
        IScenarioElement[] children = null;
        try {
            type = ParserUtility.getAttribValue(node, ATTRIB_TYPE);
            name = ParserUtility.getAttribValue(node, ATTRIB_NAME, false);
            id = ParserUtility.getAttribValue(node, ATTRIB_ID, false);
            if (name == null && id != null) {
                name = id;
            }
            if (id == null && name != null) {
                id = name;
            }
            if (type == null) return null;
            if (name == null) return null;
            if (id == null) {
                return null;
            }
            if (TYPE_SCENARIO_GROUP.equalsIgnoreCase(type)) {
                VScenarioGroup scenGroup = new VScenarioGroup(id, name, parent, new IScenarioElement[0]);
                String[] typeScenarioGroupValue = Objects.requireNonNull(typeMap.get(TYPE_SCENARIO_GROUP));
                children = VScenarioParser.parseScenarioElements(scenGroup, node.getChildNodes(), typeScenarioGroupValue);
                if (children == null) {
                    return null;
                }
                if (!VScenarioParser.typeIsValid(TYPE_SCENARIO_GROUP, validTypes)) {
                    return null;
                }
                scenGroup.children = children;
                return scenGroup;
            }
            if (TYPE_SCENARIO.equalsIgnoreCase(type)) {
                VScenario scenario = new VScenario(id, name, parent);
                String[] typeScenarioValue = Objects.requireNonNull(typeMap.get(TYPE_SCENARIO));
                children = VScenarioParser.parseScenarioElements(scenario, node.getChildNodes(), typeScenarioValue);
                if (!VScenarioParser.typeIsValid(TYPE_SCENARIO, validTypes)) {
                    return null;
                }
                scenario.setChildren(children);
                String visibleCond = ParserUtility.getAttribValue(node, ATTRIB_VISIBLE, false);
                if (visibleCond == null) return scenario;
                scenario.setVisibleCondition(visibleCond);
                return scenario;
            }
            if (!TYPE_TABLE_GROUP.equalsIgnoreCase(type)) {
                if (!TYPE_TABLE.equalsIgnoreCase(type)) return null;
                if (tables == null) return null;
                VTable table = tables.getTable(name);
                if (!(parent instanceof VTableGroup)) return table;
                table.parent = (VTableGroup)parent;
                return table;
            }
            VTableGroup tableGroup = new VTableGroup(id, name, (VScenario)parent);
            String[] typeTableGroupValue = Objects.requireNonNull(typeMap.get(TYPE_TABLE_GROUP));
            children = VScenarioParser.parseScenarioElements(tableGroup, node.getChildNodes(), typeTableGroupValue);
            if (children == null) {
                return null;
            }
            if (!VScenarioParser.typeIsValid(TYPE_TABLE_GROUP, validTypes)) {
                return null;
            }
            VTable[] tableChildren = new VTable[children.length];
            int i = 0;
            while (true) {
                if (i >= children.length) {
                    tableGroup.setChildren(tableChildren);
                    return tableGroup;
                }
                tableChildren[i] = (VTable)children[i];
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, String.format("Exception on <%s> parsing.", node.getNodeName()), e);
            return null;
        }
    }

    private static IScenarioElement[] parseScenarioElements(@Nullable IScenarioElement parent, NodeList nodes, String[] validTypes) {
        ArrayList<IScenarioElement> elemList = new ArrayList<IScenarioElement>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            if (node != null && TAG_VALIDATION_ELEMENT.equalsIgnoreCase(node.getNodeName())) {
                IScenarioElement elem = VScenarioParser.parseScenarioElement(parent, node, validTypes);
                if (elem == null) {
                    return new IScenarioElement[0];
                }
                elemList.add(elem);
            }
            ++i;
        }
        if (elemList.size() == 0) {
            return new IScenarioElement[0];
        }
        return elemList.toArray(new IScenarioElement[elemList.size()]);
    }

    private static @Nullable VStage parseValidationStage(Node node) {
        String name = null;
        IScenarioElement[] children = null;
        String visibleCondition = null;
        try {
            name = ParserUtility.getAttribValue(node, ATTRIB_NAME);
            visibleCondition = ParserUtility.getAttribValue(node, ATTRIB_VISIBLE, false);
            String[] typeValidationStageValue = Objects.requireNonNull(typeMap.get("validation-stage"));
            children = VScenarioParser.parseScenarioElements(null, node.getChildNodes(), typeValidationStageValue);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception on <validation-stage> parsing.", e);
            return null;
        }
        if (name == null || children == null) {
            return null;
        }
        return new VStage(name, children, visibleCondition);
    }

    public static VStage[] parseValidationStages(String configFile, Tables _tables) {
        tables = _tables;
        ArrayList<VStage> stageList = new ArrayList<VStage>();
        try {
            Node rootNode = ParserUtility.extractRootXmlNode(configFile);
            NodeList childNodes = rootNode.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                VStage stage;
                Node childNode = childNodes.item(i);
                if (childNode != null && "validation-stage".equalsIgnoreCase(childNode.getNodeName()) && (stage = VScenarioParser.parseValidationStage(childNode)) != null) {
                    stageList.add(stage);
                }
                ++i;
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Exception when parsing XML configuration file: " + configFile, e);
            return new VStage[0];
        }
        return stageList.toArray(new VStage[stageList.size()]);
    }

    private static boolean typeIsValid(String type, String[] validTypes) {
        String[] stringArray = validTypes;
        int n = validTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String validType = stringArray[n2];
            if (validType.equalsIgnoreCase(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

