/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.ui.MainView;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;

public class RunningCellHighlightRunnable
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(RunningCellHighlightRunnable.class);
    public static final int HIGHLIGHT_DELAY_MS = 300;
    private ValidationPresentationModel vData;
    @Nullable
    private Canvas canvas;
    private AtomicBoolean isRunning = new AtomicBoolean(false);

    public RunningCellHighlightRunnable(ValidationPresentationModel _vData) {
        this.vData = _vData;
        MainView view = this.vData.getParent().getView();
        this.canvas = !view.isDisposed() ? view.getScenarioView().getCanvas() : null;
    }

    public boolean isRunning() {
        return this.isRunning.get();
    }

    public void refreshCanvas() {
        this.canvas = Objects.requireNonNull(this.vData.getParent().getView().getScenarioView().getCanvas());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        Canvas canvasLoc = this.canvas;
        if (this.isRunning.get()) {
            this.vData.updateHighlight();
            try {
                if (canvasLoc == null || canvasLoc.isDisposed()) return;
                canvasLoc.redraw();
                return;
            }
            finally {
                Display current = Display.getCurrent();
                if (current != null) {
                    current.timerExec(300, (Runnable)this);
                }
            }
        } else {
            if (!this.vData.isHighlight()) {
                this.vData.updateHighlight();
            }
            if (canvasLoc == null || canvasLoc.isDisposed()) return;
            canvasLoc.redraw();
        }
    }

    public void setRunning(boolean running) {
        this.isRunning.set(running);
    }

    public boolean waitToFinish() {
        int count = 0;
        int max = 20;
        while (this.isRunning()) {
            if (++count >= max && this.isRunning()) {
                return false;
            }
            try {
                Thread.sleep(200L);
            }
            catch (Exception e) {
                LOGGER.info(e.getMessage());
                return false;
            }
        }
        return true;
    }
}

