/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class TimeoutReachedUiUpdater
extends AUIRunnable {
    private VPresentationModel data;
    @Nullable
    private String errorMessage;

    public TimeoutReachedUiUpdater(VPresentationModel data, @Nullable String message) {
        this.data = data;
        this.errorMessage = message;
    }

    @Override
    public void run() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            if (this.errorMessage != null && this.errorMessage.equals(Messages.CloseExecTimeoutMsg)) {
                Shell[] shells;
                Shell[] shellArray = shells = this.data.getView().getDisplay().getShells();
                int n = shells.length;
                int n2 = 0;
                while (n2 < n) {
                    Shell shell = shellArray[n2];
                    if (shell.getText().equals(Messages.ExecTimeoutMsg)) {
                        shell.dispose();
                    }
                    ++n2;
                }
            } else {
                boolean answer = MessageDialog.openQuestion((Shell)window.getShell(), (String)Messages.ExecTimeoutMsg, (String)this.errorMessage);
                ExecutionPresentationModel exec = this.data.getExecution();
                ValidationPresentationModel validation = this.data.getValidationModel();
                if (validation != null && exec != null && validation.isAnyJobRunning()) {
                    exec.setIgnoreTimeout(answer);
                }
            }
        }
    }
}

