/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class CellScriptsView
extends Composite {
    private Combo comScripts;
    private Button btnOpenInEditor;
    private StyledText txtScriptContent;
    private transient ComboViewer comScriptViewer;

    public CellScriptsView(Composite parentView) {
        super(parentView, 0);
        this.setLayout((Layout)new GridLayout(3, false));
        Label lblScripts = new Label((Composite)this, 0);
        lblScripts.setLayoutData((Object)new GridData(131072, 0x1000000, false, false, 1, 1));
        lblScripts.setText(Messages.ScriptLabel);
        this.comScripts = new Combo((Composite)this, 8);
        this.comScripts.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.btnOpenInEditor = new Button((Composite)this, 0);
        this.btnOpenInEditor.setText(Messages.OpenInEditorLabel);
        this.txtScriptContent = new StyledText((Composite)this, 2824);
        Display current = Display.getCurrent();
        if (current != null) {
            this.txtScriptContent.setBackground(current.getSystemColor(15));
        }
        this.txtScriptContent.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.txtScriptContent.getVerticalBar().setIncrement(10);
        this.comScriptViewer = new ComboViewer(this.comScripts);
    }

    protected void checkSubclass() {
    }

    public void defaultFocus() {
        this.txtScriptContent.setFocus();
    }

    public void makeDefaultSelection() {
        if (this.comScriptViewer.getElementAt(0) != null) {
            this.comScriptViewer.setSelection((ISelection)new StructuredSelection(this.comScriptViewer.getElementAt(0)));
        }
    }

    public void refreshViewers() {
        this.comScriptViewer.refresh();
    }

    public void setInput(VParamVariation cell) {
        this.comScriptViewer.setInput((Object)cell);
        VScriptConfig[] prevSelConfigs = cell.getParent().getPrevSelectedScriptConfigs(cell);
        if (prevSelConfigs.length > 0) {
            VScriptConfig selConfig = prevSelConfigs[0];
            this.comScriptViewer.setSelection((ISelection)new StructuredSelection((Object)selConfig), true);
        }
    }

    public void setOpenInEditorEnabled(boolean enabled) {
        this.btnOpenInEditor.setEnabled(enabled);
    }

    public void setOpenInEditorSelectionListener(SelectionListener selListener) {
        this.btnOpenInEditor.addSelectionListener(selListener);
    }

    public void setScriptComboContentProvider(IStructuredContentProvider contentProvider) {
        this.comScriptViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setScriptComboLabelProvider(ILabelProvider labelProvider) {
        this.comScriptViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    public void setScriptContent(String scriptContent) {
        this.txtScriptContent.setText(scriptContent);
        this.txtScriptContent.setFocus();
    }

    public void setScriptsComboEnabled(boolean enabled) {
        this.comScripts.setEnabled(enabled);
    }

    public void setScriptsSelectionListener(ISelectionChangedListener selChangedListener) {
        this.comScriptViewer.addSelectionChangedListener(selChangedListener);
    }
}

