/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.annotation.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentLazyProvider;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentProvider;
import com.nxp.swtools.mem.validation.lproviders.SerdesResLabelProvider;
import com.nxp.swtools.mem.validation.model.HintsHandler;
import com.nxp.swtools.mem.validation.model.SerdesResultsHandler;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Tree;

public class CellSummaryView
extends ScrolledComposite {
    private static final boolean showRegistersInfoInSummary = false;
    private transient HintsHandler hintsSupport = new HintsHandler();
    private Composite mainPanel;
    private final transient SerdesResultsHandler srdsResultsHandler = new SerdesResultsHandler();
    @Nullable
    private Table tblUpdatedRegs;
    @Nullable
    private Tree tblErrCaptRegs;
    private Table tblTestResults;
    @Nullable
    private TableColumn tblColUpdatedRegsName;
    @Nullable
    private TableColumn tblColUpdatedRegsValue;
    private TableColumn tblColTestResultsScript;
    private TableColumn tblColTestResultsRun;
    private TableColumn tblColTestResultsElapsed;
    private TableColumn tblColTestResultsStatus;
    private TableColumn tblColTestResultsFailReason;
    @Nullable
    private Group groupHints;
    @Nullable
    private Table hintsTbl;
    @Nullable
    private transient TableViewer hintsTblViewer;
    @Nullable
    private TableColumn symptomTblCol;
    @Nullable
    private transient TableViewerColumn symptomTblColViewer;
    @Nullable
    private TableColumn causeTblCol;
    @Nullable
    private transient TableViewerColumn causeTblColViewer;
    @Nullable
    private Table srdsTestResults;
    @Nullable
    private transient TableViewer srdsTblViewer;
    @Nullable
    private transient TableViewerColumn srdrCol1;
    @Nullable
    private transient TableViewerColumn srdrCol2;
    @Nullable
    private TableColumn srdsCol1TestResultsScript;
    @Nullable
    private TableColumn srdsCol2TestResultsScript;
    private transient TableViewer testResultsTblViewer;
    private transient TableViewerColumn testResultsScriptViewer;
    private transient TableViewerColumn testResultsRunViewer;
    private transient TableViewerColumn testResultsElapsedViewer;
    private transient TableViewerColumn testResultsStatusViewer;
    private transient TableViewerColumn testResultsFailReasonViewer;
    @Nullable
    private Label lblErrorCaptureRegsTestName;
    @Nullable
    private Label lblErrorCaptureRegsIteration;
    private Label testsPassedLabel;
    private Label testsFailedLabel;
    private Label testsQueuedLabel;
    private Label testsSkippedLabel;
    private GridData gd_grpTestResults;
    private GridData gd_tblTestResults;
    @Nullable
    private GridData gd_tblUpdatedRegs;
    @Nullable
    private GridData gd_tblErrCaptRegs;

    public CellSummaryView(Composite parentView) {
        super(parentView, 2816);
        this.setMinWidth(327);
        this.setMinHeight(200);
        this.setAlwaysShowScrollBars(true);
        this.setLayoutData(new GridData(4, 4, true, true, 3, 1));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.getVerticalBar().setIncrement(this.getVerticalBar().getIncrement() * 6);
        this.mainPanel = new Composite((Composite)this, 0);
        this.setContent((Control)this.mainPanel);
        this.mainPanel.setLayout((Layout)new GridLayout(1, false));
        SashForm summaryViewSashForm = new SashForm(this.mainPanel, 0);
        summaryViewSashForm.setLayout((Layout)new GridLayout(2, false));
        summaryViewSashForm.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        summaryViewSashForm.setOrientation(256);
        summaryViewSashForm.setSashWidth(1);
        SashForm summaryViewLeft = new SashForm((Composite)summaryViewSashForm, 0);
        summaryViewLeft.setLayout((Layout)new GridLayout(2, false));
        summaryViewLeft.setOrientation(256);
        summaryViewLeft.setSashWidth(1);
        Group grpTestResults = new Group((Composite)summaryViewLeft, 0);
        grpTestResults.setLayout((Layout)new GridLayout(4, false));
        this.gd_grpTestResults = new GridData(4, 4, true, true, 1, 1);
        this.gd_grpTestResults.minimumHeight = 110;
        grpTestResults.setLayoutData((Object)this.gd_grpTestResults);
        grpTestResults.setText(Messages.TestResultsTitle);
        this.testsPassedLabel = new Label((Composite)grpTestResults, 0);
        this.testsPassedLabel.setText(Messages.NonePassedLabel);
        this.testsPassedLabel.setForeground(this.getDisplay().getSystemColor(6));
        this.testsPassedLabel.setVisible(true);
        this.testsFailedLabel = new Label((Composite)grpTestResults, 0);
        this.testsFailedLabel.setText(Messages.NoneFailedLabel);
        this.testsFailedLabel.setForeground(this.getDisplay().getSystemColor(4));
        this.testsFailedLabel.setVisible(true);
        this.testsQueuedLabel = new Label((Composite)grpTestResults, 0);
        this.testsQueuedLabel.setText(Messages.NoneQueuedLabel);
        this.testsQueuedLabel.setForeground(this.getDisplay().getSystemColor(16));
        this.testsQueuedLabel.setVisible(true);
        this.testsSkippedLabel = new Label((Composite)grpTestResults, 0);
        this.testsSkippedLabel.setText(Messages.NoneSkippedLabel);
        this.testsSkippedLabel.setForeground(this.getDisplay().getSystemColor(15));
        this.testsSkippedLabel.setVisible(true);
        this.tblTestResults = new Table((Composite)grpTestResults, 0x10010B00);
        this.gd_tblTestResults = new GridData(4, 4, true, true, 4, 1);
        this.gd_tblTestResults.minimumHeight = 150;
        this.gd_tblTestResults.heightHint = 150;
        this.tblTestResults.setLayoutData((Object)this.gd_tblTestResults);
        this.tblTestResults.setHeaderVisible(true);
        this.tblTestResults.setLinesVisible(true);
        this.tblColTestResultsScript = new TableColumn(this.tblTestResults, 0);
        this.tblColTestResultsScript.setWidth(100);
        this.tblColTestResultsScript.setText(Messages.ScriptLabel);
        this.tblColTestResultsRun = new TableColumn(this.tblTestResults, 0);
        this.tblColTestResultsRun.setWidth(45);
        this.tblColTestResultsRun.setText(Messages.RunLabel);
        this.tblColTestResultsElapsed = new TableColumn(this.tblTestResults, 0);
        this.tblColTestResultsElapsed.setWidth(100);
        this.tblColTestResultsElapsed.setText(Messages.ElapsedTimeLabel);
        this.tblColTestResultsStatus = new TableColumn(this.tblTestResults, 0);
        this.tblColTestResultsStatus.setWidth(72);
        this.tblColTestResultsStatus.setText(Messages.ResultLabel);
        this.tblColTestResultsFailReason = new TableColumn(this.tblTestResults, 0);
        this.tblColTestResultsFailReason.setWidth(200);
        this.tblColTestResultsFailReason.setText(Messages.FailReasonLabel);
        if (this.hintsSupport.isAvailable()) {
            Group crtGroupHints = this.groupHints = new Group((Composite)summaryViewLeft, 0);
            crtGroupHints.setLayout((Layout)new GridLayout(2, false));
            GridData gdGroupHints = new GridData(4, 4, true, true, 1, 1);
            crtGroupHints.setLayoutData((Object)gdGroupHints);
            crtGroupHints.setText(Messages.HintsLabel);
            Table crtTableHints = this.hintsTbl = new Table((Composite)crtGroupHints, 268503810);
            crtTableHints.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
            crtTableHints.setHeaderVisible(true);
            crtTableHints.setLinesVisible(true);
            TableColumn crtColumnSymptom = this.symptomTblCol = new TableColumn(this.hintsTbl, 0);
            crtColumnSymptom.setWidth(110);
            crtColumnSymptom.setText(Messages.SymptomLabel);
            TableColumn crtColumnCause = this.causeTblCol = new TableColumn(this.hintsTbl, 0);
            crtColumnCause.setWidth(400);
            crtColumnCause.setText(Messages.PossibleCausesLabel);
        }
        if (this.srdsResultsHandler.showSerDesResults()) {
            Group grpSerDesResults = new Group((Composite)summaryViewLeft, 0);
            grpSerDesResults.setLayout((Layout)new GridLayout(1, false));
            grpSerDesResults.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
            grpSerDesResults.setText("Scenario details");
            Table tbl = this.srdsTestResults = new Table((Composite)grpSerDesResults, 0x10010B00);
            GridData srds_gdTestResults = new GridData(4, 4, true, true, 2, 1);
            srds_gdTestResults.minimumHeight = 150;
            srds_gdTestResults.heightHint = 150;
            tbl.setLayoutData((Object)srds_gdTestResults);
            tbl.setHeaderVisible(false);
            tbl.setLinesVisible(true);
            TableColumn crt = this.srdsCol1TestResultsScript = new TableColumn(this.srdsTestResults, 0);
            crt.setWidth(180);
            crt = this.srdsCol2TestResultsScript = new TableColumn(this.srdsTestResults, 0);
            crt.setWidth(134);
        }
        this.setMinSize(this.mainPanel.computeSize(-1, -1));
        this.testResultsTblViewer = new TableViewer(this.tblTestResults);
        this.testResultsScriptViewer = new TableViewerColumn(this.testResultsTblViewer, this.tblColTestResultsScript);
        this.testResultsRunViewer = new TableViewerColumn(this.testResultsTblViewer, this.tblColTestResultsRun);
        this.testResultsElapsedViewer = new TableViewerColumn(this.testResultsTblViewer, this.tblColTestResultsElapsed);
        this.testResultsStatusViewer = new TableViewerColumn(this.testResultsTblViewer, this.tblColTestResultsStatus);
        this.testResultsFailReasonViewer = new TableViewerColumn(this.testResultsTblViewer, this.tblColTestResultsFailReason);
        if (this.hintsSupport.isAvailable()) {
            if (this.hintsTbl != null) {
                this.hintsTblViewer = new TableViewer(this.hintsTbl);
            }
            if (this.symptomTblCol != null) {
                this.symptomTblColViewer = new TableViewerColumn(this.hintsTblViewer, this.symptomTblCol);
            }
            if (this.causeTblCol != null) {
                this.causeTblColViewer = new TableViewerColumn(this.hintsTblViewer, this.causeTblCol);
            }
        }
        if (this.srdsResultsHandler.showSerDesResults() && this.srdsTestResults != null) {
            this.srdsTblViewer = new TableViewer(this.srdsTestResults);
            this.srdsTblViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
            this.srdrCol1 = new TableViewerColumn(this.srdsTblViewer, this.srdsCol1TestResultsScript);
            this.srdrCol1.setLabelProvider((CellLabelProvider)new SerdesResLabelProvider());
            this.srdrCol2 = new TableViewerColumn(this.srdsTblViewer, this.srdsCol2TestResultsScript);
            this.srdrCol2.setLabelProvider((CellLabelProvider)new SerdesResLabelProvider());
        }
    }

    protected void checkSubclass() {
    }

    public void makeDefaultSelection() {
        if (this.testResultsTblViewer.getElementAt(0) != null) {
            this.testResultsTblViewer.setSelection((ISelection)new StructuredSelection(this.testResultsTblViewer.getElementAt(0)));
        }
    }

    public void refreshViewers() {
        this.testResultsTblViewer.refresh();
    }

    public void resizeColumns() {
        TableColumn tc;
        TableColumn[] tableColumnArray = this.tblTestResults.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            tc = tableColumnArray[n2];
            tc.pack();
            ++n2;
        }
        if (this.hintsSupport.isAvailable() && this.hintsTbl != null) {
            tableColumnArray = this.hintsTbl.getColumns();
            n = tableColumnArray.length;
            n2 = 0;
            while (n2 < n) {
                tc = tableColumnArray[n2];
                tc.pack();
                ++n2;
            }
        }
        if (this.srdsResultsHandler.showSerDesResults() && this.srdsTestResults != null) {
            tableColumnArray = this.srdsTestResults.getColumns();
            n = tableColumnArray.length;
            n2 = 0;
            while (n2 < n) {
                tc = tableColumnArray[n2];
                tc.pack();
                ++n2;
            }
        }
    }

    public void setInput(VParamVariation cell) {
        this.updateStatLabels(cell);
        this.testResultsTblViewer.setInput((Object)cell);
        VRunResult[] res = cell.getResults();
        if (res != null) {
            this.testResultsTblViewer.getTable().setItemCount(res.length);
            if (res.length > 0) {
                VRunResult selRunResult = res[0];
                this.testResultsTblViewer.setSelection((ISelection)new StructuredSelection((Object)selRunResult), true);
            }
        }
    }

    public void setTestResultsContentProvider(TestRunResultContentLazyProvider contentProvider) {
        contentProvider.setViewer(this.testResultsTblViewer);
        this.testResultsTblViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setTestResultsContentProvider(TestRunResultContentProvider contentProvider) {
        this.testResultsTblViewer.setContentProvider((IContentProvider)contentProvider);
    }

    public void setTestResultsFailReasonProvider(ColumnLabelProvider labelProvider) {
        this.testResultsFailReasonViewer.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public void setTestResultsRunLabelProvider(ColumnLabelProvider labelProvider) {
        this.testResultsRunViewer.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public void setTestResultsElapsedLabelProvider(ColumnLabelProvider labelProvider) {
        this.testResultsElapsedViewer.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public void setTestResultsScriptLabelProvider(ColumnLabelProvider labelProvider) {
        this.testResultsScriptViewer.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public void setTestResultsSelectionListener(ISelectionChangedListener selChangeListener) {
        this.testResultsTblViewer.addSelectionChangedListener(selChangeListener);
    }

    public void setTestResultsStatusLabelProvider(ColumnLabelProvider labelProvider) {
        this.testResultsStatusViewer.setLabelProvider((CellLabelProvider)labelProvider);
    }

    public void setHintContentProvider(ArrayContentProvider contentProvider) {
        if (this.hintsTblViewer != null) {
            this.hintsTblViewer.setContentProvider((IContentProvider)contentProvider);
        }
    }

    public void setHintSymptomLabelProvider(ColumnLabelProvider labelProvider) {
        if (this.symptomTblColViewer != null) {
            this.symptomTblColViewer.setLabelProvider((CellLabelProvider)labelProvider);
        }
    }

    public void setHintCauseLabelProvider(ColumnLabelProvider labelProvider) {
        if (this.causeTblColViewer != null) {
            this.causeTblColViewer.setLabelProvider((CellLabelProvider)labelProvider);
        }
    }

    public void updateErrorCaptureRegisterValues(VRunResult runResult) {
    }

    public void updateAdvisorTable(VRunResult runResult) {
        if (this.hintsSupport.isAvailable() && this.hintsTblViewer != null) {
            TableViewer crtHintsTblViewer = this.hintsTblViewer;
            if (runResult.getType() != VRunResult.ResultType.FAILED) {
                crtHintsTblViewer.setInput(new ArrayList());
                return;
            }
            crtHintsTblViewer.setInput(this.hintsSupport.getHints(runResult));
        }
    }

    public void updateSerDesResults(VRunResult runResult) {
        if (this.srdsResultsHandler.showSerDesResults() && this.srdsTblViewer != null) {
            TableViewer crtSrdsTblViewer = this.srdsTblViewer;
            List<String> results = null;
            results = runResult.getExtraData().isEmpty() ? this.srdsResultsHandler.getResults(runResult.getErrorMessage()) : this.srdsResultsHandler.getResults(runResult.getExtraData());
            crtSrdsTblViewer.setInput(results);
            crtSrdsTblViewer.setSelection((ISelection)new StructuredSelection(results), true);
        }
    }

    private void updateStatLabels(VParamVariation cell) {
        VRunResult[] res = cell.getResults();
        if (res == null) {
            return;
        }
        int numTests = res.length;
        int numPassed = cell.getNumPasses();
        int numFailed = cell.getNumFails();
        int numSkips = cell.getNumSkips();
        int numQueued = numTests - (numPassed + numFailed + numSkips);
        this.testsPassedLabel.setText(String.format(Messages.PassedMsg, new Integer(numPassed), new Double((double)(100 * numPassed) / (double)numTests)));
        this.testsFailedLabel.setText(String.format(Messages.FailedMsg, new Integer(numFailed), new Double((double)(100 * numFailed) / (double)numTests)));
        this.testsQueuedLabel.setText(String.format(Messages.QueuedMsg, new Integer(numQueued), new Double((double)(100 * numQueued) / (double)numTests)));
        this.testsSkippedLabel.setText(String.format(Messages.SkippedMsg, new Integer(numSkips), new Double((double)(100 * numSkips) / (double)numTests)));
    }
}

