/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;

class EnableEnumeration {
    private String[] allValues;
    private Vector<String> allValuesVec;
    private boolean @Nullable [] enabledValues;
    private int currentIndex;
    private String defaultValue;

    public EnableEnumeration(@NonNull String[] allValues, String defaultValue) {
        this.allValues = allValues;
        this.allValuesVec = new Vector<String>(Arrays.asList(allValues));
        boolean[] enabledValuesLoc = this.enabledValues = new boolean[allValues.length];
        int i = 0;
        while (i < enabledValuesLoc.length) {
            enabledValuesLoc[i] = true;
            ++i;
        }
        this.defaultValue = defaultValue;
        this.setCurrentValue(defaultValue);
    }

    public int getCurrentIndex() {
        return this.currentIndex;
    }

    public @Nullable String getCurrentValue() {
        return this.currentIndex == -1 ? null : this.allValues[this.currentIndex];
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getEnabledValues() {
        ArrayList<String> list = new ArrayList<String>();
        int a = 0;
        while (a < this.allValues.length) {
            if (this.enabledValues != null && this.enabledValues[a]) {
                String enVal = this.allValues[a];
                list.add(enVal);
            }
            ++a;
        }
        return list.toArray(new String[0]);
    }

    public boolean isEnabled() {
        if (this.enabledValues == null) {
            return false;
        }
        boolean result = false;
        boolean[] enabledValuesLoc = this.enabledValues;
        if (enabledValuesLoc != null) {
            int i = 0;
            while (i < enabledValuesLoc.length && !result) {
                result = enabledValuesLoc[i];
                ++i;
            }
        }
        return result;
    }

    public int nextValue() {
        if (!this.isEnabled()) {
            return -1;
        }
        int i = this.currentIndex + 1;
        boolean[] enabledValuesLoc = this.enabledValues;
        if (enabledValuesLoc != null) {
            int disableLoopCntr = enabledValuesLoc.length;
            if (i == enabledValuesLoc.length) {
                i = 0;
            }
            while (!enabledValuesLoc[i] && disableLoopCntr > 0) {
                --disableLoopCntr;
                if (++i != enabledValuesLoc.length) continue;
                i = 0;
            }
            this.currentIndex = i;
        }
        return this.currentIndex;
    }

    public void setCurrentIndex(int currentIndex) {
        this.currentIndex = currentIndex != -1 && this.enabledValues != null && this.enabledValues[currentIndex] ? currentIndex : -1;
    }

    public void setCurrentValue(String newValue) {
        int index = this.allValuesVec.indexOf(newValue);
        this.currentIndex = index == -1 ? -1 : (this.enabledValues != null && this.enabledValues[index] ? index : -1);
    }

    public void setEnabledValues(String @Nullable [] enabledValues) {
        if (enabledValues == null) {
            this.enabledValues = null;
            return;
        }
        boolean[] enabledValuesLoc = this.enabledValues = new boolean[this.allValues.length];
        int a = 0;
        while (a < this.allValues.length) {
            enabledValuesLoc[a] = false;
            int i = 0;
            while (i < enabledValues.length) {
                if (this.allValues[a].equals(enabledValues[i])) {
                    enabledValuesLoc[a] = true;
                    break;
                }
                ++i;
            }
            ++a;
        }
    }
}

