/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellCustomView;
import com.nxp.swtools.mem.validation.ui.CellLogsView;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.CellSummaryView;
import com.nxp.swtools.mem.validation.ui.ExecutionView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import com.nxp.swtools.mem.validation.views.VStagesView;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MainView
extends Composite {
    private VStagesView stagesView;
    private VScenarioView scenarioView;
    private ExecutionView execView;
    private ConnectionView connView;

    public MainView(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        SashForm mainSash = new SashForm((Composite)this, 0);
        mainSash.setLayout((Layout)new GridLayout(2, false));
        mainSash.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        mainSash.setOrientation(256);
        mainSash.setSashWidth(3);
        ScrolledComposite scrollbar = new ScrolledComposite((Composite)mainSash, 768);
        scrollbar.setLayoutData((Object)new GridData(4, 4, true, true));
        scrollbar.setExpandVertical(true);
        scrollbar.setExpandHorizontal(true);
        Composite mainComp = new Composite((Composite)scrollbar, 0);
        mainComp.setLayout((Layout)new GridLayout(1, false));
        mainComp.setLayoutData((Object)new GridData(4, 4, true, true));
        scrollbar.setContent((Control)mainComp);
        Composite comp1 = new Composite(mainComp, 0);
        comp1.setLayout((Layout)new GridLayout(1, false));
        comp1.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        Composite comp2 = new Composite(mainComp, 0);
        comp2.setLayout((Layout)new GridLayout(1, false));
        comp2.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.stagesView = new VStagesView(comp1);
        this.scenarioView = new VScenarioView((Composite)mainSash);
        this.execView = new ExecutionView(comp1);
        this.connView = new ConnectionView(comp2);
        mainSash.setWeights(new int[]{1, 2});
    }

    protected void checkSubclass() {
    }

    public @Nullable CellCustomView getCellCustomView() {
        CellResultsMainView cellResultsmainView = this.getCellResultsMainView();
        return cellResultsmainView != null ? cellResultsmainView.getCustomView() : null;
    }

    public @Nullable CellLogsView getCellLogsView() {
        CellResultsMainView cellResultsmainView = this.getCellResultsMainView();
        return cellResultsmainView != null ? cellResultsmainView.getLogsView() : null;
    }

    public @Nullable CellResultsMainView getCellResultsMainView() {
        return this.scenarioView.getCellResultsMainView();
    }

    public @Nullable CellSummaryView getCellSummaryView() {
        CellResultsMainView cellResultsmainView = this.getCellResultsMainView();
        return cellResultsmainView != null ? cellResultsmainView.getSummaryView() : null;
    }

    public ExecutionView getExecutionView() {
        return this.execView;
    }

    public @Nullable VScenarioOptionsView getScenarioOptionsView() {
        return this.scenarioView.getScenarioOptionsView();
    }

    public VScenarioView getScenarioView() {
        return this.scenarioView;
    }

    public VStagesView getStagesView() {
        return this.stagesView;
    }

    public ConnectionView getConnView() {
        return this.connView;
    }

    public void setInput(VPresentationModel presModel) {
        VStagePresentation selStage;
        ValidationPresentationModel vPresModel = presModel.getValidationModel();
        if (vPresModel != null && (selStage = vPresModel.getSelectedStage()) != null) {
            ExecutionPresentationModel execModel;
            VScenarioOptionsView scenarioOptsView;
            VScenarioPresentation selScenario = selStage.getSelectedScenario();
            this.stagesView.setInput(vPresModel);
            this.scenarioView.setInput(selStage, false);
            if (selScenario != null && (scenarioOptsView = this.scenarioView.getScenarioOptionsView()) != null) {
                scenarioOptsView.setInput(selScenario);
            }
            if ((execModel = presModel.getExecution()) != null) {
                this.execView.setInput(execModel);
                this.connView.setInput(execModel);
            }
            VParamVariation selCell = presModel.getSelectedCell();
            CellResultsMainView cellResultsmainView = this.getCellResultsMainView();
            if (selCell != null && cellResultsmainView != null) {
                String logLvl;
                cellResultsmainView.setInput(selCell, presModel.getModel(), false);
                VModel vModel = presModel.getModel();
                if (vModel != null && (logLvl = vModel.getCustomOption("defaultLogLevel")) != null) {
                    cellResultsmainView.getLogsView().setLogLevel(logLvl);
                }
            }
        }
    }
}

