/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.utils.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.IFileSystem;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;

public final class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger(FileUtils.class);

    public static void appendToFile(IFile iFile, String content) throws CoreException {
        String contents = FileUtils.readTextFile(iFile, false);
        contents = String.valueOf(contents) + content;
        FileUtils.writeTextFile(iFile, contents);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final boolean compareContent(String filepath, byte[] compBytes) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream in2 = new FileInputStream(filepath);){
                boolean bl;
                int i;
                int readTotal = 0;
                int readCount = 0;
                byte[] buf = new byte[1024];
                do {
                    if ((readCount = ((InputStream)in2).read(buf)) <= 0) {
                        if (compBytes.length == readTotal) {
                            bl = true;
                            return bl;
                        }
                        break;
                    }
                    int handled = readTotal;
                    readTotal += readCount;
                    if (readCount <= compBytes.length) continue;
                    return false;
                } while ((i = 0) >= readCount);
                bl = false;
                return bl;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
            return false;
        }
    }

    public static void copyDirectory(File sourceDir, File destDir) throws IOException {
        if (!sourceDir.exists()) {
            throw new IOException(String.valueOf(Messages.CopyFromInexistentDir) + sourceDir.getAbsolutePath());
        }
        if (!sourceDir.isDirectory()) {
            throw new IOException(String.valueOf(sourceDir.getAbsolutePath()) + " does not denote a directory");
        }
        if (!destDir.exists() && !destDir.mkdirs()) {
            throw new IOException(String.valueOf(Messages.CreateDirFailed) + destDir.getAbsolutePath());
        }
        String[] children = sourceDir.list();
        if (children != null) {
            String[] stringArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                String child = stringArray[n2];
                File source = new File(sourceDir, child);
                File dest = new File(destDir, child);
                if (source.isDirectory()) {
                    FileUtils.copyDirectory(source, dest);
                } else {
                    FileUtils.copyfile(source, dest);
                }
                ++n2;
            }
        }
    }

    public static void copyfile(File fSource, File fDest) throws IOException {
        FileUtils.copyfile(fSource.getAbsolutePath(), fDest.getAbsolutePath());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void copyfile(String srcFilePath, String dstFilePath) throws IOException {
        if (srcFilePath.equals(dstFilePath)) {
            return;
        }
        if (!new File(srcFilePath).exists()) {
            throw new IOException("The source file does not exist.");
        }
        File srcFile = new File(srcFilePath);
        File destFile = new File(dstFilePath);
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try {
                InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(srcFile), StandardCharsets.UTF_8);
                try {
                    block29: {
                        BufferedReader in = new BufferedReader(reader);
                        try {
                            block28: {
                                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(destFile), StandardCharsets.UTF_8);
                                try {
                                    try (BufferedWriter out = new BufferedWriter(writer);){
                                        int len;
                                        char[] buf = new char[1024];
                                        while ((len = in.read(buf)) > 0) {
                                            out.write(buf, 0, len);
                                        }
                                    }
                                    if (writer == null) break block28;
                                }
                                catch (Throwable throwable2) {
                                    if (throwable == null) {
                                        throwable = throwable2;
                                    } else if (throwable != throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                    if (writer == null) throw throwable;
                                    ((Writer)writer).close();
                                    throw throwable;
                                }
                                ((Writer)writer).close();
                            }
                            if (in == null) break block29;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            if (in == null) throw throwable;
                            in.close();
                            throw throwable;
                        }
                        in.close();
                    }
                    if (reader == null) return;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (reader == null) throw throwable;
                    ((Reader)reader).close();
                    throw throwable;
                }
                ((Reader)reader).close();
                return;
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    public static boolean createDirectory(String path) {
        return FileUtils.createDirectory(path, false);
    }

    public static boolean createDirectory(String path, boolean forcePathCreation) {
        File f = new File(path);
        return f.exists() || !(forcePathCreation ? !f.mkdirs() : !f.mkdir());
    }

    public static boolean deleteDirectory(File path) {
        File[] fileList;
        if (path.exists() && path.isDirectory() && (fileList = path.listFiles()) != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtils.deleteDirectory(file);
                } else {
                    boolean success = file.delete();
                    assert (success) : String.valueOf(Messages.DeleteFailed) + file.getAbsolutePath();
                }
                ++n2;
            }
        }
        return path.delete();
    }

    public static boolean deleteDirectory(String path) {
        assert (path != null);
        return FileUtils.deleteDirectory(new File(path));
    }

    public static boolean existsLocally(IFile file) {
        IFileSystem fileSystem = EFS.getLocalFileSystem();
        IFileStore store = fileSystem.getStore(file.getLocation());
        IFileInfo info = store.fetchInfo();
        return info.exists();
    }

    public static @Nullable File getLocalFile(IFile iFile) {
        assert (FileUtils.existsLocally(iFile));
        IPath loc = iFile.getLocation();
        return loc != null ? loc.toFile() : null;
    }

    public static @Nullable IFile getWorkspaceFile(File file) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(file.getAbsolutePath()));
    }

    public static @Nullable IFile getWorkspaceFile(String ... wspacePath) {
        if (wspacePath.length < 2) {
            throw new IllegalArgumentException(Messages.InvalidPathStructure);
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(wspacePath[0]);
        IFolder folder = null;
        if (wspacePath.length > 2) {
            folder = proj.getFolder(wspacePath[1]);
            int i = 2;
            while (i < wspacePath.length - 1) {
                folder = folder.getFolder(wspacePath[i]);
                ++i;
            }
        }
        if (folder != null) {
            return folder.getFile(wspacePath[wspacePath.length - 1]);
        }
        return proj.getFile(wspacePath[wspacePath.length - 1]);
    }

    public static @Nullable IFolder getWorkspaceFolder(String ... wspacePath) {
        if (wspacePath.length < 2) {
            throw new IllegalArgumentException(Messages.InvalidPathStructure);
        }
        IProject proj = ResourcesPlugin.getWorkspace().getRoot().getProject(wspacePath[0]);
        IFolder folder = null;
        if (wspacePath.length > 2) {
            folder = proj.getFolder(wspacePath[1]);
            int i = 2;
            while (i < wspacePath.length - 1) {
                folder = folder.getFolder(wspacePath[i]);
                ++i;
            }
        }
        if (folder != null) {
            return folder.getFolder(wspacePath[wspacePath.length - 1]);
        }
        return proj.getFolder(wspacePath[wspacePath.length - 1]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAscii(@Nullable String filepath, int byteCount) throws IOException {
        if (filepath == null) throw new IllegalArgumentException();
        if (byteCount < 0) {
            throw new IllegalArgumentException();
        }
        File file = new File(filepath);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileInputStream inStream2 = new FileInputStream(file);){
            long size = Math.min(file.length(), (long)byteCount);
            int CHUNK_SIZE = Math.min(4096, (int)size);
            byte[] buf = new byte[CHUNK_SIZE];
            Arrays.fill(buf, (byte)97);
            int count = 0;
            int totalCount = 0;
            count = inStream2.read(buf);
            if (count != -1) {
            }
            if (totalCount != 0) return true;
            return false;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    public static boolean isDirectory(String path) {
        assert (path != null);
        return new File(path).isDirectory();
    }

    public static boolean isEmptyFile(IFile iFile) throws CoreException {
        InputStream is1;
        block13: {
            boolean bl;
            block14: {
                Throwable throwable = null;
                Object var2_4 = null;
                is1 = iFile.getContents();
                try {
                    byte[] buf = new byte[1024];
                    if (is1 == null) break block13;
                    int len = is1.read(buf);
                    bl = len == -1;
                    if (is1 == null) break block14;
                }
                catch (Throwable throwable2) {
                    try {
                        try {
                            if (is1 != null) {
                                is1.close();
                            }
                            throw throwable2;
                        }
                        catch (Throwable throwable3) {
                            if (throwable == null) {
                                throwable = throwable3;
                            } else if (throwable != throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        LOGGER.warning(e.getMessage());
                        return true;
                    }
                }
                is1.close();
            }
            return bl;
        }
        if (is1 != null) {
            is1.close();
        }
        return true;
    }

    public static boolean isEmptyFolder(String path) {
        assert (path != null) : Messages.InvalidPath;
        assert (FileUtils.isDirectory(path)) : Messages.NotFolderType;
        File dir = new File(path);
        assert (dir.exists()) : Messages.FolderNotExists;
        File[] files = dir.listFiles();
        if (files != null) {
            return files.length == 0;
        }
        return false;
    }

    public static @Nullable String joinMultiplePaths(String ... paths) {
        File file = null;
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            file = new File(file, path);
            ++n2;
        }
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    public static String joinPaths(String optDir, String cddeRelativePathToOptimizationDir) {
        String path = FileUtils.joinMultiplePaths(optDir, cddeRelativePathToOptimizationDir);
        if (path != null) {
            return path;
        }
        return optDir;
    }

    public static File[] listFiles(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils.listFiles(dir, files);
        return files.toArray(new File[files.size()]);
    }

    private static void listFiles(File dir, List<File> result) {
        File[] files = dir.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    FileUtils.listFiles(file, result);
                } else {
                    result.add(file);
                }
                ++n2;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public static String readTextFile(IFile iFile, boolean convertNewlines) throws CoreException {
        buff = new StringBuilder();
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                inputStream = iFile.getContents();
                try {
                    fileReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
                    try {
                        block29: {
                            buffReader = new BufferedReader(fileReader);
                            try {
                                if (convertNewlines) {
                                    line = null;
                                    while ((line = buffReader.readLine()) != null) {
                                        buff.append(line).append(StringUtils.EOL);
                                    }
                                    break block29;
                                }
                                buf = new byte[1024];
                                while (inputStream != null) {
                                    len = inputStream.read(buf);
                                    if (len == -1) {
                                        break;
                                    }
                                    buff.append(new String(buf, 0, len, StandardCharsets.UTF_8));
                                }
                            }
                            finally {
                                if (buffReader != null) {
                                    buffReader.close();
                                }
                            }
                        }
                        ** if (fileReader == null) goto lbl-1000
                    }
                    catch (Throwable var4_7) {
                        if (var3_3 == null) {
                            var3_3 = var4_7;
                        } else if (var3_3 != var4_7) {
                            var3_3.addSuppressed(var4_7);
                        }
                        if (fileReader != null) {
                            fileReader.close();
                        }
                        throw var3_3;
                    }
lbl-1000:
                    // 1 sources

                    {
                        fileReader.close();
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                    ** if (inputStream == null) goto lbl-1000
                }
                catch (Throwable var4_8) {
                    if (var3_3 == null) {
                        var3_3 = var4_8;
                    } else if (var3_3 != var4_8) {
                        var3_3.addSuppressed(var4_8);
                    }
                    if (inputStream != null) {
                        inputStream.close();
                    }
                    throw var3_3;
                }
lbl-1000:
                // 1 sources

                {
                    inputStream.close();
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var4_9) {
                if (var3_3 == null) {
                    var3_3 = var4_9;
                } else if (var3_3 != var4_9) {
                    var3_3.addSuppressed(var4_9);
                }
                throw var3_3;
            }
        }
        catch (IOException e) {
            FileUtils.LOGGER.warning(e.getMessage());
        }
        return buff.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readTextFile(String filePath) {
        StringBuilder buff = new StringBuilder();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileInputStream inputStream = new FileInputStream(filePath);
                try {
                    block21: {
                        InputStreamReader fileReader = new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8);
                        try {
                            try (BufferedReader buffReader = new BufferedReader(fileReader);){
                                String line = null;
                                while ((line = buffReader.readLine()) != null) {
                                    buff.append(line).append(StringUtils.EOL);
                                }
                            }
                            if (fileReader == null) break block21;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (fileReader == null) throw throwable;
                            ((Reader)fileReader).close();
                            throw throwable;
                        }
                        ((Reader)fileReader).close();
                    }
                    if (inputStream == null) return buff.toString();
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (inputStream == null) throw throwable;
                    ((InputStream)inputStream).close();
                    throw throwable;
                }
                ((InputStream)inputStream).close();
                return buff.toString();
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
        return buff.toString();
    }

    public static boolean writeBinaryFile(IFile iFile, byte[] data, boolean overwrite) throws CoreException {
        return FileUtils.writeBinaryFile(iFile, data, overwrite, null);
    }

    public static boolean writeBinaryFile(IFile iFile, byte[] data, boolean overwrite, @Nullable IProgressMonitor monitor) throws CoreException {
        if (iFile.exists()) {
            if (overwrite) {
                iFile.delete(true, null);
            } else {
                return false;
            }
        }
        ByteArrayInputStream sourceStream = new ByteArrayInputStream(data);
        iFile.create((InputStream)sourceStream, 1, monitor);
        return true;
    }

    public static void writeTextFile(IFile iFile, String contents) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (ByteArrayInputStream is = new ByteArrayInputStream(contents.toString().getBytes(StandardCharsets.UTF_8));){
                if (iFile.exists()) {
                    iFile.setContents((InputStream)is, true, false, null);
                } else {
                    iFile.create((InputStream)is, true, null);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void writeTextFile(String filePath, String contents) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(filePath), StandardCharsets.UTF_8);
                try {
                    try (BufferedWriter out = new BufferedWriter(writer);){
                        writer.write(contents);
                        ((Writer)writer).flush();
                    }
                    if (writer == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (writer == null) throw throwable;
                    ((Writer)writer).close();
                    throw throwable;
                }
                ((Writer)writer).close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.warning(e.getMessage());
        }
    }

    private FileUtils() {
    }
}

