/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.utils;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.codgen.CgenManager;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.FileUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.graphics.Point;

public class TestResultsLogger {
    public static final char HEADER_PATTERN = '#';
    public static final int HEADER_LINE_SIZE = 100;
    public static final int HEADER_STARTSPACE_SIZE = 20;
    public static final int HEADER_MIDSPACE_SIZE = 6;
    public static final String PY_EXTENSION = ".py";
    public static final String TEST_PREFIX = "test_";
    public static final int headerTemplSize = 20 + Messages.ResultHeader.length() + 3 + 6 + Messages.RunHeader.length();
    @Nullable
    private static PrintWriter pw;
    private static final Logger LOGGER;

    static {
        LOGGER = LogManager.getLogger(TestResultsLogger.class);
    }

    public static void appendResultsToFile(@Nullable String dirPath, @Nullable String fileName, @Nullable String results, @Nullable String scriptId, int iteration) {
        try {
            if (dirPath == null || fileName == null || scriptId == null) {
                return;
            }
            String logFilePath = String.valueOf(dirPath) + File.separator + fileName;
            File logFile = new File(logFilePath);
            if (!logFile.exists() && !logFile.createNewFile()) {
                throw new Exception("Can't create new log file at: [" + logFilePath + "]");
            }
            pw = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)new FileOutputStream(new File(logFilePath), true), StandardCharsets.UTF_8), true);
            String logPartHeader = TestResultsLogger.buildHeaderLine(scriptId, ++iteration);
            PrintWriter pwLoc = pw;
            if (pwLoc != null) {
                pwLoc.write(logPartHeader);
                pwLoc.write(CgenManager.LINE_SEPARATOR);
                pwLoc.write(CgenManager.LINE_SEPARATOR);
                pwLoc.write(results);
                pwLoc.write(CgenManager.LINE_SEPARATOR);
                pwLoc.flush();
                pwLoc.close();
            }
        }
        catch (Exception e) {
            LOGGER.info(e.getMessage());
        }
    }

    public static String buildHeaderLine(String scriptName, int numRun) {
        StringBuilder buffer = new StringBuilder();
        char[] startSpace = new char[20];
        Arrays.fill(startSpace, '#');
        char[] midSpace = new char[6];
        Arrays.fill(midSpace, '#');
        buffer.append(startSpace);
        buffer.append(Messages.ResultHeader);
        buffer.append(scriptName);
        buffer.append(" ");
        buffer.append(midSpace);
        buffer.append(Messages.RunHeader);
        buffer.append(" ");
        buffer.append("" + numRun);
        buffer.append(" ");
        int headerLinePartSize = headerTemplSize + scriptName.length() + ("" + numRun).length();
        int headerLineSizeToFill = 100 - headerLinePartSize;
        char[] endSpace = new char[headerLineSizeToFill];
        Arrays.fill(endSpace, '#');
        buffer.append(endSpace);
        return buffer.toString();
    }

    public static String getPhyTrainingLogFile(VParamVariation cell) {
        Point cellPos = cell.getPos();
        String cellPosStr = TestResultsLogger.getPosStr(new Point(cellPos.x, cellPos.y - cell.getParent().getColumnOffset()));
        String tableId = cell.getParent().getId();
        return "phy_training_" + tableId + cellPosStr + ".log";
    }

    public static String getPhyTrainingLogFilePath(VParamVariation cell) {
        String logDir = Activator.getDefault().getConfigManager().getLogsFolder();
        String logFileName = TestResultsLogger.getPhyTrainingLogFile(cell);
        return String.valueOf(logDir) + File.separator + logFileName;
    }

    public static String getFigureLogFile(VParamVariation cell) {
        Point cellPos = cell.getPos();
        String cellPosStr = TestResultsLogger.getPosStr(new Point(cellPos.x, cellPos.y - cell.getParent().getColumnOffset()));
        String tableId = cell.getParent().getId();
        return "figure_" + tableId + cellPosStr + ".png";
    }

    public static String getFigureLogFilePath(VParamVariation cell) {
        String logDir = Activator.getDefault().getConfigManager().getLogsFolder();
        String logFileName = TestResultsLogger.getFigureLogFile(cell);
        return String.valueOf(logDir) + File.separator + logFileName;
    }

    public static String getLogFile(VRunResult runResult) {
        Point cellPos = runResult.getParamVariation().getPos();
        String cellPosStr = TestResultsLogger.getPosStr(new Point(cellPos.x, cellPos.y - runResult.getParamVariation().getParent().getColumnOffset()));
        String tableId = runResult.getParamVariation().getParent().getId();
        return TEST_PREFIX + tableId + cellPosStr + ".log";
    }

    public static String getLogFile(VTable table, VParamVariation cell) {
        String cellPosStr = TestResultsLogger.getPosStr(Objects.requireNonNull(cell.getPos()));
        return TEST_PREFIX + table.getId() + cellPosStr + ".log";
    }

    public static String getLogFilePath(VTable table, VParamVariation cell) {
        String logDir = Activator.getDefault().getConfigManager().getLogsFolder();
        String logFileName = TestResultsLogger.getLogFile(table, cell);
        return String.valueOf(logDir) + File.separator + logFileName;
    }

    public static String getLogFilePath(VRunResult runResult) {
        String logDir = Activator.getDefault().getConfigManager().getLogsFolder();
        String logFileName = TestResultsLogger.getLogFile(runResult);
        return String.valueOf(logDir) + File.separator + logFileName;
    }

    /*
     * Exception decompiling
     */
    public static @Nullable String getLogPart(File logFile, VRunResult runResult) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String getPosStr(Point pos) {
        if (pos.y < 0) {
            return "_" + pos.x + "_" + Math.abs(pos.y) + "i_";
        }
        return "_" + pos.x + "_" + pos.y + "_";
    }

    public static String getScriptFileName(VParamVariation cell, VScript script) {
        String posStr = TestResultsLogger.getPosStr(Objects.requireNonNull(cell.getPos()));
        return TEST_PREFIX + cell.getParent().getId() + "_" + script.getId() + posStr + PY_EXTENSION;
    }

    public static String getScriptFilePath(VParamVariation cell, VScript script) {
        String scriptDir = Activator.getDefault().getConfigManager().getScriptsFolder();
        String scriptFileName = TestResultsLogger.getScriptFileName(cell, script);
        return String.valueOf(scriptDir) + File.separator + scriptFileName;
    }

    public static boolean lineIsHeader(String line) {
        char[] startSpace = new char[20];
        Arrays.fill(startSpace, '#');
        char[] midSpace = new char[6];
        Arrays.fill(midSpace, '#');
        StringBuilder patternBuffer = new StringBuilder();
        patternBuffer.append(startSpace);
        patternBuffer.append(Messages.ResultHeader);
        Pattern p = Pattern.compile(patternBuffer.toString());
        Matcher m = p.matcher(line);
        return m.find();
    }

    /*
     * Exception decompiling
     */
    public static @Nullable String loadFile(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public static @Nullable String loadTestScript(VParamVariation cell, VScript script) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static boolean saveTestScript(VScript script, VParamVariation cell, String contents) {
        String scriptDir = Activator.getDefault().getConfigManager().getScriptsFolder();
        String scriptFileName = TestResultsLogger.getScriptFileName(cell, script);
        String scriptFilePath = String.valueOf(scriptDir) + File.separator + scriptFileName;
        FileUtils.writeTextFile(scriptFilePath, contents);
        return true;
    }
}

