/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.views;

import com.nxp.swtools.common.ui.utils.progress.UIJobHelper;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.IDiagsProvider;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ConfigManager;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.preferences.KEPreferences;
import com.nxp.swtools.utils.view.ToolView;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IGenericProblem;
import com.nxp.swtools.validation.engine.ValidationEngineFactory;
import java.util.Collection;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class ValidationView
extends ToolView {
    public static final String ID = "com.nxp.swtools.mem.validation.views.ValidationView";
    public static final String EXT_POINT_VALIDATION_VIEW = "com.nxp.swtools.mem.validation.views";
    public static final String TAG_ID = "id";
    public static final String TAG_VIEW = "view";
    @Nullable
    private VPresentationModel presentationModel;
    @Nullable
    private IConfigProvider controller;
    ValidationContext vContext;
    private IEventListener dataModelChangeListener = event -> {
        UIJob uIJob = UIJobHelper.runUIJob(() -> this.updateData(), (String)Messages.UpdateDataModel_JobName, (boolean)false);
    };

    public ValidationView() {
        IPerspectiveDescriptor currentPerspective;
        this.vContext = ValidationContext.getInstance();
        String activePerspectiveId = "";
        IWorkbenchPage wp = ValidationView.getActiveWorkbenchPage();
        if (wp != null && (currentPerspective = wp.getPerspective()) != null) {
            activePerspectiveId = currentPerspective.getId();
        }
        IConfigurationElement[] config = IConfigProvider.getConfigProviders();
        try {
            IConfigurationElement[] iConfigurationElementArray = config;
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IConfigProvider) {
                    boolean setConfigProvider;
                    IConfigProvider crtController = (IConfigProvider)o;
                    crtController.setDataChangeListener(this.dataModelChangeListener);
                    boolean bl = setConfigProvider = config.length == 1 || activePerspectiveId.equals(crtController.getPerspectiveId());
                    if (setConfigProvider) {
                        this.controller = crtController;
                        this.vContext.setConfigController(this.controller);
                    }
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            LOGGER.warning(ex.getLocalizedMessage());
        }
    }

    public void createPartControl(@Nullable Composite parent) {
        if (parent != null) {
            this.setToolMainControl((Control)parent);
            Composite container = new Composite(parent, 2048);
            FillLayout grl = new FillLayout();
            container.setLayout((Layout)grl);
            try {
                IConfigProvider controllerLoc = ValidationContext.getInstance().getConfigController();
                if (controllerLoc != null) {
                    this.loadDiagsProvider();
                    ConfigManager configManager = Activator.getDefault().updateConfigManager(controllerLoc.getConfigDataPath());
                    VPresentationModel presentationModelLoc = this.presentationModel = VPresentationModel.newInstance(container);
                    if (controllerLoc.isEnabled()) {
                        presentationModelLoc.setInput(configManager, this.vContext);
                        CellResultsMainView cellView = presentationModelLoc.getView().getCellResultsMainView();
                        if (cellView != null) {
                            cellView.createPhyDebugView();
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.severe("Error while creating ValidationView: " + e.getMessage());
            }
        }
    }

    public void dispose() {
        super.dispose();
        this.deleteValidationProblems();
        if (this.controller != null) {
            this.controller.removeDataChangeListener();
        }
    }

    private static @Nullable IWorkbenchPage getActiveWorkbenchPage() {
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (activeWorkbenchWindow != null) {
            return activeWorkbenchWindow.getActivePage();
        }
        return null;
    }

    public void loadDiagsProvider() {
        IConfigurationElement[] configs = IDiagsProvider.getConfigProviders();
        try {
            IConfigurationElement[] iConfigurationElementArray = configs;
            int n = configs.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                Object o = e.createExecutableExtension("class");
                if (o instanceof IDiagsProvider) {
                    this.vContext.setDiagsProvider((IDiagsProvider)o);
                    break;
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            LOGGER.info(ex.getLocalizedMessage());
        }
    }

    public void updateData() {
        VPresentationModel presentationModelLoc = this.presentationModel;
        if (presentationModelLoc != null) {
            IConfigProvider controllerLoc = ValidationContext.getInstance().getConfigController();
            IWorkbenchPage wp = ValidationView.getActiveWorkbenchPage();
            if (wp != null) {
                Composite viewParent;
                if (controllerLoc != null && controllerLoc.isEnabled()) {
                    this.firePropertyChange(260);
                    ConfigManager configManager = Activator.getDefault().updateConfigManager(controllerLoc.getConfigDataPath());
                    configManager.createValidationSpecificFolders();
                    configManager.cleanValidationFilesByExtension(".log");
                    presentationModelLoc.setInput(configManager, this.vContext);
                } else {
                    presentationModelLoc.setInput(null, this.vContext);
                    if (KEPreferences.hideValidationViewAutomatically()) {
                        wp.hideView((IViewPart)this);
                        if (this.controller != null) {
                            this.controller.removeDataChangeListener();
                        }
                    }
                }
                if (!presentationModelLoc.getView().isDisposed() && (viewParent = presentationModelLoc.getView().getParent()) != null) {
                    presentationModelLoc.resetView(viewParent);
                }
                this.deleteValidationProblems();
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void deleteValidationProblems() {
        String validationResource = ValidationPresentationModel.getValidationProblemResourceName();
        @NonNull Collection collection = ValidationEngineFactory.getProblemsCollection();
        for (IBaseProblem problem : collection) {
            if (!(problem instanceof IGenericProblem) || !validationResource.equals(((IGenericProblem)problem).getResource()) || !"DDR".equals(((IGenericProblem)problem).getToolId())) continue;
            ValidationEngineFactory.deleteProblem((IBaseProblem)problem);
        }
    }

    public void resetPresentationModel() {
        Composite viewParent;
        VPresentationModel presentationModelLoc = this.presentationModel;
        if (presentationModelLoc != null && !presentationModelLoc.getView().isDisposed() && (viewParent = presentationModelLoc.getView().getParent()) != null) {
            presentationModelLoc.resetView(viewParent);
            presentationModelLoc.setInput(Activator.getDefault().getConfigManager(), this.vContext);
        }
    }
}

