/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.dsf;

import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.dsf.GetExpressionValueQuery;
import java.util.concurrent.ExecutionException;
import org.eclipse.cdt.dsf.debug.service.IFormattedValues;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.IMemoryBlockRetrieval;
import org.eclipse.debug.core.model.IMemoryBlockRetrievalExtension;
import org.eclipse.debug.core.model.MemoryByte;

public class DSFInterface {
    private static final DSFInterface XDSF_INTERFACE = new DSFInterface();

    public static DSFInterface getDefault() {
        return XDSF_INTERFACE;
    }

    public int iEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws NumberFormatException {
        try {
            String sResult = this.sEvaluateExpression(context, expression);
            if (sResult != null && !sResult.isEmpty()) {
                sResult = sResult.split(" ")[0];
                try {
                    return Integer.decode(sResult);
                }
                catch (NumberFormatException e) {
                    throw new ExecutionException("Exception decoding Integer " + sResult, e);
                }
            }
        }
        catch (ExecutionException e) {
            throw new NumberFormatException(e.getMessage());
        }
        return 0;
    }

    public long lEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws NumberFormatException {
        try {
            String sResult = this.sEvaluateExpression(context, expression);
            if (sResult != null) {
                sResult = sResult.split(" ")[0];
                try {
                    return Long.decode(sResult);
                }
                catch (NumberFormatException e) {
                    throw new ExecutionException("Exception decoding Long " + sResult, e);
                }
            }
        }
        catch (ExecutionException e) {
            throw new NumberFormatException(e.getMessage());
        }
        return 0L;
    }

    public String sEvaluateExpression(IRunControl.IExecutionDMContext context, String expression) throws ExecutionException {
        String result;
        block7: {
            if (context == null) {
                throw new ExecutionException("The ExecutionDMContext is undefined", null);
            }
            result = null;
            String sessionId = context.getSessionId();
            DsfServicesTracker dsfServicesTracker = new DsfServicesTracker(KAPluginActivator.getBundleContext(), sessionId);
            try {
                DsfSession session = DsfSession.getSession((String)sessionId);
                String queryString = expression.replaceAll("\\$\\{.*?\\}", "");
                GetExpressionValueQuery query = new GetExpressionValueQuery(context, queryString, dsfServicesTracker);
                if (session == null) break block7;
                session.getExecutor().execute((Runnable)((Object)query));
                try {
                    IFormattedValues.FormattedValueDMData data = (IFormattedValues.FormattedValueDMData)query.get();
                    if (data != null && (result = data.getFormattedValue()) == null) {
                        throw new ExecutionException("Cannot evaluate data", null);
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                dsfServicesTracker.dispose();
            }
        }
        return result;
    }

    public String sGetMemory(IRunControl.IExecutionDMContext context, long lAddress, int iLength) throws ExecutionException {
        IMemoryBlockRetrieval retrieval = (IMemoryBlockRetrieval)context.getAdapter(IMemoryBlockRetrieval.class);
        MemoryByte[] bytes = null;
        try {
            IMemoryBlockExtension block = ((IMemoryBlockRetrievalExtension)retrieval).getExtendedMemoryBlock(Long.toString(lAddress), (Object)context);
            bytes = block.getBytesFromAddress(block.getBigBaseAddress(), (long)iLength);
        }
        catch (DebugException e1) {
            e1.printStackTrace();
        }
        if (bytes == null) {
            return "";
        }
        StringBuilder sResult = new StringBuilder();
        int n = 0;
        while (n < bytes.length) {
            sResult = sResult.append(String.format("0x%02x%02x%02x%02x,", bytes[n].getValue(), bytes[n + 1].getValue(), bytes[n + 2].getValue(), bytes[n + 3].getValue()));
            n += 4;
        }
        return sResult.substring(0, sResult.length() - 1);
    }
}

