/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.debug.ka.model;

import com.freescale.s32ds.debug.ka.KAPluginActivator;
import com.freescale.s32ds.debug.ka.dsf.DSFInterface;
import com.freescale.s32ds.debug.ka.model.OSAbstractData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class OSDataStructure {
    protected static final int INVALID_OFFSET = -1;
    protected long lAddress = 0L;
    protected boolean bValid = false;
    protected String sRawBytes = "";
    protected Map<String, OSAbstractData> data = new HashMap<String, OSAbstractData>();
    protected String sStructureStartQueryString;
    protected String sStructureSizeQueryString;
    protected String sStructureMemberQueryString;
    protected int iStructSizeBytes = -1;

    public void prvObtainStructure(IRunControl.IExecutionDMContext context, List<String> invalidIndexes) {
        long lCurrentStructAddress = 0L;
        try {
            lCurrentStructAddress = DSFInterface.getDefault().lEvaluateExpression(context, this.sStructureStartQueryString);
            this.iStructSizeBytes = DSFInterface.getDefault().iEvaluateExpression(context, this.sStructureSizeQueryString);
            for (String key : this.data.keySet()) {
                OSAbstractData abstractOSData = this.data.get(key);
                if (invalidIndexes.contains(key)) {
                    abstractOSData.setOffset(-1);
                    continue;
                }
                try {
                    String sNameInStruct = abstractOSData.getDataItemName();
                    if (sNameInStruct.length() == 0) {
                        abstractOSData.setOffset(-1);
                        invalidIndexes.add(key);
                        continue;
                    }
                    long lReturned = DSFInterface.getDefault().lEvaluateExpression(context, String.valueOf(this.sStructureMemberQueryString) + sNameInStruct + ")");
                    long lOffset = lReturned - lCurrentStructAddress;
                    abstractOSData.setOffset((int)lOffset);
                }
                catch (NumberFormatException numberFormatException) {
                    abstractOSData.setOffset(-1);
                    invalidIndexes.add(key);
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            KAPluginActivator.log((IStatus)new Status(4, KAPluginActivator.getPluginId(), "Unable to establish OSDataStructure."));
        }
    }

    public long getAddress() {
        return this.lAddress;
    }

    public long getSize() {
        return this.iStructSizeBytes;
    }

    public void vSetValid(boolean bValue) {
        this.bValid = bValue;
    }

    public boolean getIsValid() {
        return this.bValid;
    }

    public void setMemberValues(String sData) {
        if (!sData.equals(this.sRawBytes)) {
            this.sRawBytes = sData;
            for (OSAbstractData value : this.data.values()) {
                value.setValue(sData);
            }
        }
    }
}

