/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core;

import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHolder;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectLocalSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ConflictingSdksHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ProjectLocalSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkEnvironmentUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;

public class ProjectChangeListener
implements IResourceChangeListener {
    public void resourceChanged(IResourceChangeEvent event) {
        if (1 == event.getType()) {
            IResourceDelta delta = event.getDelta();
            if (delta == null) {
                return;
            }
            int deltasLength = 0;
            IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
            if (resourceDeltas == null || (deltasLength = resourceDeltas.length) == 0) {
                return;
            }
            int i = 0;
            while (i < deltasLength) {
                IResource target = resourceDeltas[i].getResource();
                if (target instanceof IProject) {
                    IResourceDelta rd = resourceDeltas[i];
                    IProject prj = (IProject)target;
                    if (2 == rd.getKind()) {
                        ProjectChangeListener.removeProjectLocalSDKs(prj);
                    } else if (1 == rd.getKind()) {
                        ProjectChangeListener.reloadProjectLocalSDKs(prj, prj);
                    } else if (4 == rd.getKind() && 16384 == rd.getFlags()) {
                        if (prj.isOpen()) {
                            ProjectChangeListener.loadProjectLocalSDKs(prj, false);
                        } else {
                            ProjectChangeListener.removeProjectLocalSDKs(prj);
                        }
                    }
                }
                ++i;
            }
        }
    }

    private static void reloadProjectLocalSDKs(final IProject source, final IProject target) {
        WorkspaceJob wj = new WorkspaceJob("Reload project local SDK"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                SdkProjectResourcesUtils.refreshProjectResources((IProject)target);
                for (SdkDescriptor sdk : SdkManagementUtils.getFilteredSdks(new ProjectLocalSdksFilter(source))) {
                    SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdk.getId());
                }
                ProjectLocalSdkLoader.loadProjectLocalSdks(target);
                ConflictingSdksHandler.INSTANCE.handleConflictedSDKs(target);
                SdkAttachDataHelper.checkStatusOfSdksAttachedToProject(target);
                return Status.OK_STATUS;
            }
        };
        wj.setRule((ISchedulingRule)target);
        wj.schedule();
    }

    private static void removeProjectLocalSDKs(final IProject project) {
        WorkspaceJob wj = new WorkspaceJob("Delete project local SDKs"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                for (SdkDescriptor sdk : SdkManagementUtils.getFilteredSdks(new ProjectLocalSdksFilter(project))) {
                    SdkDescriptorsRegitsrationHelper.unregisterSdkDescriptors((String)sdk.getId());
                }
                SdkAttachDataHolder.cleanupProjectAttachData(project);
                ConflictingSdksHandler.INSTANCE.cleanupConflictedSdks(project);
                SdkEnvironmentUtils.cleanEnvironments();
                return Status.OK_STATUS;
            }
        };
        wj.setRule((ISchedulingRule)project);
        wj.schedule();
    }

    private static void loadProjectLocalSDKs(final IProject project, boolean isForceReload) {
        WorkspaceJob wj = new WorkspaceJob("Load project local SDKs"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectLocalSdkLoader.loadProjectLocalSdks(project);
                ConflictingSdksHandler.INSTANCE.handleConflictedSDKs(project);
                SdkAttachDataHelper.checkStatusOfSdksAttachedToProject(project);
                return Status.OK_STATUS;
            }
        };
        wj.setRule((ISchedulingRule)project);
        wj.schedule();
    }
}

