/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.UpdateStatus;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkAttachData {
    public static final String SDKS_PROJECT_PROPERTY_KEY = "com.freescale.s32ds.cross.sdk.support.attachedSDKs";
    public static final String SDKS_ATTACHED_DATA_KEY = "com.nxp.s32ds.cle.ide.sdk.attached.sdks.data";
    public static final String SDK_IDS_SEPARATOR = ":";
    public static final String SDK_GROUP_SEPARATOR = "|";
    public static final String PROJECT_ATTACH_DATA_QUALIFIER = "com.nxp.s32ds.cle.ide.sdk.attached.sdks.data";
    public static final String ATTACH_DATA_ELEMENT = "attachData";
    public static final String ATTACHED_SDK_DATA_TARGET_FOLDER_ELEMENT = "targetFolder";
    public static final String ATTACHED_SDK_DATA_TARGET_FOLDER_PATH_ATTRIBUTE = "path";
    public static final String ATTACHED_SDK_DATA_CONFIG_ELEMENT = "config";
    public static final String ATTACHED_SDK_DATA_CONFIG_NAME_ATTRIBUTE = "name";
    private String sdkId;
    private String sdkTargetFolder;
    private List<String> configurations;
    private boolean isSdkMissed;
    private Map<String, List<UpdateStatus>> attachData;

    public SdkAttachData(String sdkId) {
        this.sdkId = Objects.requireNonNull(sdkId);
        this.configurations = new ArrayList<String>();
        this.attachData = new LinkedHashMap<String, List<UpdateStatus>>();
    }

    public SdkAttachData(String sdkId, List<String> configurations) {
        this.sdkId = Objects.requireNonNull(sdkId);
        this.configurations = Objects.requireNonNull(configurations);
        this.attachData = new LinkedHashMap<String, List<UpdateStatus>>();
    }

    public String toString() {
        return "[AttachData: " + this.sdkId + SDK_GROUP_SEPARATOR + this.configurations + (this.isSdkMissed ? " (missed)" : "") + " ]";
    }

    public String getSdkId() {
        return this.sdkId;
    }

    public void setSdkTargetFolder(String sdkTargetFolder) {
        this.sdkTargetFolder = sdkTargetFolder;
    }

    public String getSdkTargetFolder() {
        return this.sdkTargetFolder;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(List<String> configurations) {
        this.configurations = Objects.requireNonNull(configurations);
    }

    public void addConfiguration(String configuration) {
        this.configurations.add(configuration);
    }

    public boolean isSdkMissed() {
        return this.isSdkMissed;
    }

    public void setIsSdkMissed(boolean isSdkMissed) {
        this.isSdkMissed = isSdkMissed;
    }

    public void setAttachData(Map<String, List<UpdateStatus>> attachData) {
        this.attachData = Objects.requireNonNull(attachData);
    }

    public Map<String, List<UpdateStatus>> getAttachData() {
        return this.attachData;
    }

    public String toRecord() {
        StringBuilder sb = new StringBuilder(this.sdkId);
        for (String configurationName : this.configurations) {
            if (sb.length() > 0) {
                sb.append(SDK_GROUP_SEPARATOR);
            }
            sb.append(configurationName);
        }
        return sb.toString();
    }

    public String convertToXml() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
            Element rootElement = document.createElement(ATTACH_DATA_ELEMENT);
            document.appendChild(rootElement);
            this.convertToXml(document, rootElement);
            Throwable throwable = null;
            Object var5_7 = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
                TransformerFactory factory = TransformerFactory.newInstance();
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
                factory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
                factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                Transformer transformer = factory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("indent", "yes");
                transformer.transform(new DOMSource(document), new StreamResult(baos));
                return baos.toString(StandardCharsets.UTF_8.toString());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | ParserConfigurationException | TransformerException e) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)"Unable transform SDK {0} attach data to XML.", (Object)this.getSdkId()), e);
            return "";
        }
    }

    private void convertToXml(Document document, Element rootElement) {
        Element targetFolderElement = document.createElement(ATTACHED_SDK_DATA_TARGET_FOLDER_ELEMENT);
        targetFolderElement.setAttribute(ATTACHED_SDK_DATA_TARGET_FOLDER_PATH_ATTRIBUTE, this.sdkTargetFolder);
        rootElement.appendChild(targetFolderElement);
        for (Map.Entry<String, List<UpdateStatus>> e : this.attachData.entrySet()) {
            Element configElement = document.createElement(ATTACHED_SDK_DATA_CONFIG_ELEMENT);
            configElement.setAttribute(ATTACHED_SDK_DATA_CONFIG_NAME_ATTRIBUTE, e.getKey());
            e.getValue().forEach(attachDataElement -> {
                Element element2 = attachDataElement.convertToXml(document, configElement);
            });
            rootElement.appendChild(configElement);
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.sdkId == null ? 0 : this.sdkId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SdkAttachData)) {
            return false;
        }
        SdkAttachData other = (SdkAttachData)obj;
        return !(this.sdkId == null ? other.sdkId != null : !this.sdkId.equals(other.sdkId));
    }
}

