/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatuses;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachStatusesResolver;
import com.nxp.s32ds.cle.cdt.sdk.core.filtering.ProjectCompatibleSdksFilter;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;

public class SdkAttachStatusesHolder {
    public static final SdkAttachStatusesHolder INSTANCE = new SdkAttachStatusesHolder();
    private Map<String, List<IStatus>> actualSDKsAttachStates = new LinkedHashMap<String, List<IStatus>>();
    private Map<String, List<IStatus>> backupSDKsAttachStates = new LinkedHashMap<String, List<IStatus>>();

    public void loadAvailableSDKsAttachStates(IProject project) {
        this.actualSDKsAttachStates = SdkAttachStatusesHolder.getResolvedAttachStates(project);
        this.backupSDKsAttachStates = SdkAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    public List<SdkDescriptor> getSDKsByStatus(IProject project, IStatus status) {
        ArrayList<SdkDescriptor> unavailableSDKs = new ArrayList<SdkDescriptor>();
        for (Map.Entry<String, List<IStatus>> e : this.actualSDKsAttachStates.entrySet()) {
            List<IStatus> sdkStatuses = e.getValue();
            if (!sdkStatuses.get(0).equals(status)) continue;
            unavailableSDKs.add(SdkDescriptors.getSdkDescriptor((String)e.getKey()));
        }
        return unavailableSDKs;
    }

    public Map<String, List<IStatus>> getActualSDKsAttachStates() {
        return this.actualSDKsAttachStates;
    }

    public Map<String, List<IStatus>> getActualSDKsAttachStatesCopy() {
        return SdkAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    public Map<String, List<IStatus>> getActualSdksAttachStatesCopy(IProject project) {
        Map<String, List<IStatus>> data = SdkAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
        ProjectCompatibleSdksFilter sdkFilter = new ProjectCompatibleSdksFilter(project);
        Collection filteredSdksIds = SdkManagementUtils.getFilteredSdks((SdkFilter)sdkFilter).stream().map(EntityDescriptor::getId).collect(Collectors.toSet());
        return data.entrySet().stream().filter(e -> filteredSdksIds.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Map<String, List<IStatus>> getBackupSDKsAttachStates() {
        return this.backupSDKsAttachStates;
    }

    public void addSDKAttachStates(String sdkId, List<IStatus> statuses) {
        this.actualSDKsAttachStates.put(sdkId, statuses);
    }

    public void addSdkAttachStates(SdkDescriptor sdkDescriptor, IProject project) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        List configurations = ProjectConfigurationUtils.getProjectConfigurations((IProject)project);
        for (IConfiguration configuration : configurations) {
            statuses.add(SdkAttachStatusesResolver.resolveAttachStatus(sdkDescriptor, project, configuration));
        }
        this.addSDKAttachStates(sdkDescriptor.getId(), statuses);
    }

    public List<IStatus> getSDKAttachStates(String sdkId) {
        return this.actualSDKsAttachStates.get(sdkId);
    }

    public void removeSDKAttachStates(Collection<SdkDescriptor> removedSdks, IProject project) {
        removedSdks.stream().map(EntityDescriptor::getId).forEach(sdkId -> {
            this.actualSDKsAttachStates.remove(sdkId);
            this.backupSDKsAttachStates.remove(sdkId);
        });
        SdkAttachStatusesHolder.getResolvedAttachStates(project).entrySet().stream().filter(e -> ((List)e.getValue()).contains(SdkAttachStatuses.ERROR_SDK_LOCATION)).map(e -> SdkDescriptors.getSdkDescriptor((String)((String)e.getKey()))).forEach(sdk -> this.addSdkAttachStates((SdkDescriptor)sdk, project));
    }

    public List<IStatus> getSDKAttachStates(SdkDescriptor sdkDescriptor, IProject project) {
        return ProjectConfigurationUtils.getProjectConfigurations((IProject)project).stream().map(config -> SdkAttachStatusesResolver.resolveAttachStatus(sdkDescriptor, project, config)).collect(Collectors.toList());
    }

    public void commitSDKsAttachStates() {
        this.backupSDKsAttachStates = SdkAttachStatusesHolder.copyData(this.actualSDKsAttachStates);
    }

    public boolean isSdkAttachable(SdkDescriptor sdkDescriptor) {
        List<IStatus> sdkAttachStates = this.getSDKAttachStates(sdkDescriptor.getId());
        return sdkAttachStates != null && sdkAttachStates.stream().anyMatch(IStatus::isOK);
    }

    private static Map<String, List<IStatus>> copyData(Map<String, List<IStatus>> map) {
        LinkedHashMap<String, List<IStatus>> data = new LinkedHashMap<String, List<IStatus>>();
        for (Map.Entry<String, List<IStatus>> entry : map.entrySet()) {
            String sdkId = entry.getKey();
            ArrayList<IStatus> copyStatuses = new ArrayList<IStatus>();
            for (IStatus status : entry.getValue()) {
                copyStatuses.add(status);
            }
            data.put(sdkId, copyStatuses);
        }
        return data;
    }

    private static Map<String, List<IStatus>> getResolvedAttachStates(IProject project) {
        return SdkAttachStatusesResolver.resolveAttachStatuses(project, SdkManagementUtils.getFilteredSdks((SdkFilter)ProjectCompatibleSdksFilter.getNoOptionsFilter(project)));
    }
}

