/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.exports;

import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.osgi.util.NLS;

public class SdkExporter {
    public IStatus exportSDK(String path, SdkDescriptor sdkDescriptor, boolean isExportDescriptorOnly) {
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (ZipOutputStream zip = new ZipOutputStream(new FileOutputStream(path));){
                EnvironmentSdkDescriptor environment;
                String descriptorContent = SdkManagementUtils.getSdksString(Collections.singletonList(sdkDescriptor));
                ZipEntry descriptorEntry = new ZipEntry("sources.xml");
                zip.putNextEntry(descriptorEntry);
                zip.write(descriptorContent.getBytes(StandardCharsets.UTF_8));
                zip.closeEntry();
                if (!isExportDescriptorOnly && (environment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkDescriptor.getId())) != null) {
                    SdkExporter.compressContent(zip, Paths.get(environment.getValue(), new String[0]), path);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | CoreException e) {
            IStatus errorStatus = SdkCoreActivator.getInstance().createError(Messages.SdkExporter_error_export, e);
            SdkCoreActivator.getInstance().log(errorStatus);
            return errorStatus;
        }
        return SdkCoreActivator.getInstance().createStatus(0, NLS.bind((String)Messages.SdkExporter_message_sdk_successfully_exported, (Object)SdkManagementUtils.getSdkBriefInfo(sdkDescriptor), (Object)path));
    }

    private static void compressContent(final ZipOutputStream zip, Path sdkPathIn, final String zipPath) throws IOException, CoreException {
        final Path sdkPath = Paths.get(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkPathIn.toString()), new String[0]);
        Files.walkFileTree(sdkPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Path f = sdkPath.relativize(file);
                if (f.toString().equals("sources.xml") || zipPath.equals(file.toFile().getPath())) {
                    return FileVisitResult.CONTINUE;
                }
                Throwable throwable = null;
                Object var5_6 = null;
                try (BufferedInputStream origin = new BufferedInputStream(new FileInputStream(file.toFile()), 2048);){
                    int count;
                    ZipEntry entry = new ZipEntry(f.toString());
                    zip.putNextEntry(entry);
                    byte[] data = new byte[2048];
                    while ((count = origin.read(data, 0, 2048)) != -1) {
                        zip.write(data, 0, count);
                    }
                    zip.closeEntry();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

