/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.filtering;

import com.nxp.s32ds.cle.cdt.sdk.core.filtering.FilterOptionsUtils;
import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilteringParameters;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.CoreDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.DeviceDescriptors;
import com.nxp.s32ds.cle.runtime.hardware.registry.core.FamilyDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.lang.LangSdkKind;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IBuildObject;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.runtime.Platform;

public class FilterOptionsImplementation
implements FilterOptions {
    public static final FilterOptions EMPTY_FILTER = new FilterOptionsImplementation(LangSdkKind.UNKNOWN, Collections.emptyList(), FilterOptionsUtils.emptyHardwareParams());
    private LangSdkKind lang;
    private List<IToolChain> toolChains;
    private Map<String, Set<String>> hardwareParams;
    private String platformTarget;
    private String platformHost;
    private boolean isCheckAvailability;

    public FilterOptionsImplementation(LangSdkKind lang, Collection<IToolChain> toolChains, Map<String, Set<String>> hardwareParams) {
        this.lang = lang;
        this.toolChains = toolChains.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.hardwareParams = hardwareParams;
        this.isCheckAvailability = true;
    }

    public FilterOptionsImplementation(LangSdkKind lang, Collection<IToolChain> toolChains, Map<String, Set<String>> hardwareParams, String platformTarget, String platformHost) {
        this(lang, toolChains, hardwareParams);
        this.platformTarget = platformTarget;
        this.platformHost = platformHost;
    }

    public FilterOptionsImplementation(LangSdkKind lang, Collection<IToolChain> toolChains, String hardwareParamsString, String deviceRevisionId) {
        this(lang, toolChains, FilterOptionsUtils.createHardwareParams(hardwareParamsString, deviceRevisionId));
    }

    public LangSdkKind getLang() {
        return this.lang;
    }

    public List<IToolChain> getToolChains() {
        return this.toolChains;
    }

    public Map<String, Set<String>> getHardwareParams() {
        return this.hardwareParams;
    }

    public String getToolChainsIdsString() {
        if (this.toolChains == null || this.toolChains.isEmpty()) {
            return "";
        }
        return String.join((CharSequence)",", this.toolChains.stream().map(tc -> tc.getId().trim()).collect(Collectors.toList()));
    }

    public String getPlatform() {
        return this.platformTarget != null ? this.platformTarget.toLowerCase() : "";
    }

    public String getHost() {
        return this.platformHost != null ? this.platformHost.toLowerCase() : "";
    }

    public static FilterOptions createFilter(SdkFilteringParameters filterInfo) {
        if (filterInfo == null) {
            return EMPTY_FILTER;
        }
        LangSdkKind langOption = LangSdkKind.getByValue((String)filterInfo.getLangId());
        Collection toolChainsOption = filterInfo.getToolChains();
        Map<String, Set<String>> hardwareOption = FilterOptionsImplementation.getHardwareParameters(filterInfo);
        String platformTargetOption = filterInfo.getTargetPlatform();
        String platformHostOption = Platform.getOS();
        return new FilterOptionsImplementation(langOption, toolChainsOption, hardwareOption, platformTargetOption, platformHostOption);
    }

    private static Map<String, Set<String>> getHardwareParameters(SdkFilteringParameters sdkFilterInfo) {
        String deviceRevisionId = sdkFilterInfo.getDeviceRevisionId();
        String coreNatureId = sdkFilterInfo.getDeviceCoreId();
        DeviceCoreDescriptor deviceCore = DeviceDescriptors.getDeviceCoreDescriptor((String)coreNatureId);
        if (deviceCore == null) {
            String coreId = sdkFilterInfo.getCoreId();
            if (coreId != null && !coreId.isEmpty()) {
                if (sdkFilterInfo.isLibrary()) {
                    List deviceDescriptorsByFamily = FamilyDescriptors.getDeviceDescriptors((String)sdkFilterInfo.getFamilyId());
                    HashMap<String, Set<String>> hardwareParams = new HashMap<String, Set<String>>();
                    for (DeviceDescriptor deviceDescriptor : deviceDescriptorsByFamily) {
                        FilterOptionsUtils.collectHardwareParams(DeviceDescriptors.getDeviceCoreDescriptors((String)deviceDescriptor.getId(), (String)coreId), deviceRevisionId, hardwareParams);
                    }
                    hardwareParams.put("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id", !deviceRevisionId.isEmpty() ? Collections.singleton(deviceRevisionId) : Collections.emptySet());
                    return hardwareParams;
                }
                return FilterOptionsUtils.createHardwareParams(sdkFilterInfo.getDeviceId(), null, coreId, deviceRevisionId);
            }
            return FilterOptionsUtils.createHardwareParams(sdkFilterInfo.getDeviceId(), coreNatureId, null, deviceRevisionId);
        }
        return FilterOptionsUtils.createHardwareParams(deviceCore.getDeviceId(), deviceCore.getId(), null, deviceRevisionId);
    }

    public boolean isCheckAvailability() {
        return this.isCheckAvailability;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.hardwareParams == null ? 0 : this.hardwareParams.hashCode());
        result = 31 * result + (this.isCheckAvailability ? 1231 : 1237);
        result = 31 * result + (this.lang == null ? 0 : this.lang.hashCode());
        result = 31 * result + (this.platformTarget == null ? 0 : this.platformTarget.hashCode());
        result = 31 * result + (this.platformHost == null ? 0 : this.platformHost.hashCode());
        result = 31 * result + this.toolChains.stream().map(IBuildObject::getId).collect(Collectors.toList()).hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        List otherTcIds;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FilterOptionsImplementation other = (FilterOptionsImplementation)obj;
        if (!this.hardwareParams.equals(other.hardwareParams)) {
            return false;
        }
        if (this.isCheckAvailability != other.isCheckAvailability) {
            return false;
        }
        if (this.lang != other.lang) {
            return false;
        }
        if (!this.getPlatform().equals(other.getPlatform())) {
            return false;
        }
        if (!this.getHost().equals(other.getHost())) {
            return false;
        }
        List<IToolChain> otherToolChains = other.getToolChains();
        if (this.toolChains.size() != otherToolChains.size()) {
            return false;
        }
        List thisTcIds = this.toolChains.stream().map(IBuildObject::getId).collect(Collectors.toList());
        return thisTcIds.containsAll(otherTcIds = otherToolChains.stream().map(IBuildObject::getId).collect(Collectors.toList()));
    }

    public String getHardwareIdsString() {
        if (this.hardwareParams.isEmpty()) {
            return "";
        }
        Set<String> result = this.getHardwareIdsByDeviceIds();
        if (result.isEmpty() && (result = this.getHardwareIdsStringByDeviceCoreIds()).isEmpty()) {
            result = this.getHardwareIdsStringByCoreIds();
        }
        return !result.isEmpty() ? String.join((CharSequence)",", result.toArray(new String[0])) : "";
    }

    public String getDeviceRevisionId() {
        Set<String> deviceRevisionIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.revision.id");
        return !deviceRevisionIds.isEmpty() ? deviceRevisionIds.iterator().next() : "";
    }

    private Set<String> getHardwareIdsByDeviceIds() {
        Set<String> deviceIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.device.id");
        if (deviceIds == null || deviceIds.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Set<String> deviceCoreIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        Set<String> coreIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        for (String deviceId : deviceIds) {
            List deviceCores = DeviceDescriptors.getDeviceCoreDescriptors((String)deviceId);
            for (DeviceCoreDescriptor dcd : deviceCores) {
                String deviceCoreId = dcd.getId();
                String coreId = dcd.getCoreId();
                if (!deviceCoreIds.contains(deviceCoreId) || !coreIds.contains(coreId)) continue;
                result.add(String.format("%s:%s:%s", deviceId, deviceCoreId, coreId));
            }
        }
        return result;
    }

    private Set<String> getHardwareIdsStringByDeviceCoreIds() {
        Set<String> deviceCoreIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id");
        if (deviceCoreIds == null || deviceCoreIds.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Set<String> allCoreIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        for (String deviceCoreId : deviceCoreIds) {
            String coreId;
            DeviceCoreDescriptor dcd = DeviceDescriptors.getDeviceCoreDescriptor((String)deviceCoreId);
            String string = coreId = dcd != null ? dcd.getCoreId() : null;
            if (coreId == null || !allCoreIds.contains(coreId)) continue;
            result.add(String.format(":%s:%s", deviceCoreId, coreId));
        }
        return result;
    }

    private Set<String> getHardwareIdsStringByCoreIds() {
        Set<String> coreIds = this.hardwareParams.get("com.nxp.s32ds.cle.runtime.hardware.registry.core.id");
        if (coreIds == null || coreIds.isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String coreId : coreIds) {
            if (CoreDescriptors.getCoreDescriptor((String)coreId) == null) continue;
            result.add(String.format("::%s", coreId));
        }
        return result;
    }
}

