/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.imports;

import com.nxp.s32ds.cle.cdt.sdk.core.imports.ImportSdkHandler;
import com.nxp.s32ds.cle.cdt.sdk.core.load.ImportedSdkLoader;
import com.nxp.s32ds.cle.cdt.sdk.core.load.LoadSdkException;
import com.nxp.s32ds.cle.cdt.sdk.core.load.parsers.SdkDescriptorParser;
import com.nxp.s32ds.cle.cdt.sdk.core.utils.SdkManagementUtils;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkHeaderValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkValidator;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.ext.rcp.statushandlers.RcpStatusHandler;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.statushandlers.StatusManager;

public class SdksImporter {
    private ImportSdkHandler handler;

    public Collection<SdkDescriptor> importSdks(String destinationPath, String locationPath) {
        File destinationLocation = new File(destinationPath);
        File sourceLocation = new File(locationPath);
        try {
            if (sourceLocation.isDirectory()) {
                Files.copy(sourceLocation.toPath(), destinationLocation.toPath(), new CopyOption[0]);
            } else {
                SdksImporter.unzipContent(sourceLocation, destinationLocation, new String[0]);
            }
            return this.importSdks(destinationLocation, true);
        }
        catch (IOException ioe) {
            SdkCoreActivator.getInstance().log(new LoadSdkException(ioe.getMessage(), ioe.getCause()).getStatus());
            return Collections.emptyList();
        }
    }

    public Collection<SdkDescriptor> importSdkFromDirectory(String directoryPath) {
        File sdkLocalFolder = new File(directoryPath);
        return this.importSdks(sdkLocalFolder, false);
    }

    public void setSdkImportHandler(ImportSdkHandler ch) {
        this.handler = ch;
    }

    private Collection<SdkDescriptor> importSdks(File dir, boolean isImportFromArchive) {
        Collection<SdkDescriptor> importedSdks = this.importFromDir(dir, isImportFromArchive);
        ImportedSdkLoader.updatePersistedImportedSdks();
        return importedSdks;
    }

    private Collection<SdkDescriptor> importFromDir(File dir, boolean isImportFromArchive) {
        ArrayList<SdkDescriptor> importedSdks = new ArrayList<SdkDescriptor>();
        MultiStatus importStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)dir.getAbsolutePath()));
        SdkValidator sdkValidator = new SdkValidator();
        try {
            String sourceXml = SdksImporter.loadSourcesXml(dir);
            SdkDescriptorParser parser = new SdkDescriptorParser();
            Map<String, SdkDescriptor> sdkDescriptors = SdksImporter.validateLoadedSdksHeaders(parser.loadSdksHeaders(sourceXml), dir.getAbsolutePath());
            for (Map.Entry<String, SdkDescriptor> e : sdkDescriptors.entrySet()) {
                SdkDescriptor loadedSdkDescriptor;
                IStatus validationStatus;
                String sourceHeaderId = e.getKey();
                SdkDescriptor sdkDescriptor = e.getValue();
                Map<String, String> sdkAttributes = new HashMap<String, String>();
                sdkAttributes.put("name", sdkDescriptor.getName());
                sdkAttributes.put("version", sdkDescriptor.getVersion());
                if (SdkManagementUtils.isSdkExists(sdkDescriptor.getName(), sdkDescriptor.getVersion()) && (sdkAttributes = this.requestRename(sdkAttributes, null)) == null) {
                    SdksImporter.deleteSdkExtractionFolder(dir, isImportFromArchive);
                    continue;
                }
                sdkAttributes.put("basePath", sdkDescriptor.getBasePath());
                String selectedLocation = this.requestSourceLocation(sdkAttributes, dir);
                if (selectedLocation == null) continue;
                if (selectedLocation.equals(sdkDescriptor.getBasePath())) {
                    SdksImporter.deleteSdkExtractionFolder(dir, isImportFromArchive);
                }
                if ((validationStatus = sdkValidator.validate(loadedSdkDescriptor = parser.loadImportingSdk(sourceXml, sourceHeaderId, null, selectedLocation, sdkAttributes))).isOK()) {
                    importedSdks.add(loadedSdkDescriptor);
                    continue;
                }
                importStatuses.addAll(validationStatus);
            }
            if (!importStatuses.isOK()) {
                SdksImporter.handleSdkImportingErrors(importStatuses);
            }
        }
        catch (LoadSdkException lse) {
            importStatuses.add(SdkCoreActivator.getInstance().createError(lse.getMessage()));
            SdksImporter.handleSdkImportingErrors(importStatuses);
        }
        return importedSdks;
    }

    public Map<String, SdkDescriptor> loadSdkHeaders(String zipFilePath, String destinationFolderPath) {
        return this.loadSdkHeaders(zipFilePath, destinationFolderPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public Map<String, SdkDescriptor> loadSdkHeaders(String zipFilePath, String destinationFolderPath, IProgressMonitor progressMonitor) {
        File zipFile = new File(zipFilePath);
        File destinationFolder = new File(destinationFolderPath);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
        MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)zipFile.getAbsolutePath()));
        try {
            SdksImporter.unzipContent(zipFile, destinationFolder, (IProgressMonitor)subMonitor.split(ProgressCounter.Unzip.getValue()), new String[0]);
            String sourceXml = SdksImporter.loadSourcesXml(destinationFolder);
            SdkDescriptorParser parser = new SdkDescriptorParser();
            subMonitor.done();
            return SdksImporter.validateLoadedSdksHeaders(parser.loadSdksHeaders(sourceXml), zipFile.getAbsolutePath());
        }
        catch (LoadSdkException | IOException e) {
            resultStatus.add(SdkCoreActivator.getInstance().createError(((Throwable)e).getMessage()));
            SdksImporter.handleSdkImportingErrors(resultStatus);
            subMonitor.done();
            return Collections.emptyMap();
        }
    }

    public Map<String, SdkDescriptor> loadSdkHeaders(String destinationFolderPath) {
        File destinationFolder = new File(destinationFolderPath);
        String sourceXml = SdksImporter.loadSourcesXml(destinationFolder);
        SdkDescriptorParser parser = new SdkDescriptorParser();
        MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)destinationFolder.getAbsolutePath()));
        try {
            return SdksImporter.validateLoadedSdksHeaders(parser.loadSdksHeaders(sourceXml), destinationFolder.getAbsolutePath());
        }
        catch (LoadSdkException e) {
            resultStatus.add(SdkCoreActivator.getInstance().createError(e.getMessage()));
            SdksImporter.handleSdkImportingErrors(resultStatus);
            return Collections.emptyMap();
        }
    }

    public Collection<SdkDescriptor> performImport(Map<String, Map<String, String>> sdksChangedAttributes, String zipLocation, String destinationPath) {
        return this.performImport(sdksChangedAttributes, zipLocation, destinationPath, (IProgressMonitor)new NullProgressMonitor());
    }

    public Collection<SdkDescriptor> performImport(Map<String, Map<String, String>> sdksChangedAttributes, String zipLocation, String destinationPath, IProgressMonitor progressMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)ProgressCounter.TotalWork.getValue());
        SdkDescriptorParser parser = new SdkDescriptorParser();
        SdkValidator sdkValidator = new SdkValidator();
        subMonitor.worked(ProgressCounter.ImportInitialization.getValue());
        ArrayList<SdkDescriptor> importedSdks = new ArrayList<SdkDescriptor>();
        MultiStatus importStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)new File(zipLocation).getAbsolutePath()));
        File destinationFolder = new File(destinationPath);
        try {
            try {
                String sourceXml = SdksImporter.loadSourcesXml(destinationFolder);
                subMonitor.worked(ProgressCounter.LoadSourceXML.getValue());
                int len = sdksChangedAttributes.size();
                for (Map.Entry<String, Map<String, String>> e : sdksChangedAttributes.entrySet()) {
                    String sourceHeaderId = e.getKey();
                    Map<String, String> sdkAttributes = e.getValue();
                    String selectedLocation = sdkAttributes.get("basePath");
                    subMonitor.worked(ProgressCounter.GetSelectedLocation.getValue() / len);
                    SdkDescriptor loadedSdk = parser.loadImportingSdk(sourceXml, sourceHeaderId, null, selectedLocation, sdkAttributes);
                    subMonitor.worked(ProgressCounter.GetSDKDescriptor.getValue() / len);
                    IStatus validationStatus = sdkValidator.validate(loadedSdk);
                    subMonitor.worked(ProgressCounter.ValidateStatus.getValue() / len);
                    if (validationStatus.isOK()) {
                        importedSdks.add(loadedSdk);
                    } else {
                        importStatuses.addAll(validationStatus);
                    }
                    subMonitor.worked(ProgressCounter.AddImportedSDK.getValue() / len);
                }
                if (!importStatuses.isOK()) {
                    SdksImporter.handleSdkImportingErrors(importStatuses);
                }
                ImportedSdkLoader.updatePersistedImportedSdks();
            }
            catch (LoadSdkException lse) {
                importStatuses.add(SdkCoreActivator.getInstance().createError(lse.getMessage()));
                SdksImporter.handleSdkImportingErrors(importStatuses);
                subMonitor.done();
            }
        }
        finally {
            subMonitor.done();
        }
        return importedSdks;
    }

    public boolean isValidDestinationPath(String destinationFolderPath) {
        boolean returnValue = false;
        try {
            if (destinationFolderPath.isEmpty()) {
                throw new IOException(NLS.bind((String)Messages.ImportSdkHandler_exception_emptystring, (Object)destinationFolderPath));
            }
            if (Files.notExists(Paths.get(destinationFolderPath, new String[0]), new LinkOption[0])) {
                throw new IOException(NLS.bind((String)Messages.ImportSdkHandler_exception_nonexistent_directory, (Object)destinationFolderPath));
            }
            if (!Files.isWritable(Paths.get(destinationFolderPath, new String[0]))) {
                throw new IOException(NLS.bind((String)Messages.ImportSdkHandler_exception_access_denied, (Object)destinationFolderPath));
            }
            returnValue = true;
        }
        catch (NullPointerException npe) {
            NullPointerException newNpe = new NullPointerException(NLS.bind((String)Messages.ImportSdkHandler_exception_nullpointer, (Object)destinationFolderPath));
            newNpe.setStackTrace(npe.getStackTrace());
            this.handleDestinationPathException(newNpe, destinationFolderPath);
        }
        catch (IOException | InvalidPathException ex) {
            this.handleDestinationPathException(ex, destinationFolderPath);
        }
        return returnValue;
    }

    private void handleDestinationPathException(Exception ex, String path) {
        SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.ImportSdkHandler_error_extraction_directory, (Object)path), ex);
        MultiStatus resultStatus = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_extraction_directory, (Object)path));
        resultStatus.add(SdkCoreActivator.getInstance().createError(ex.getMessage()));
        SdksImporter.handleSdkImportingErrors(resultStatus);
    }

    private static Map<String, SdkDescriptor> validateLoadedSdksHeaders(Map<String, SdkDescriptor> loadedSdksHeaders, String path) {
        MultiStatus importStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)path));
        SdkHeaderValidator sdkHeaderValidator = new SdkHeaderValidator();
        HashMap<String, SdkDescriptor> validSdksHeaders = new HashMap<String, SdkDescriptor>(loadedSdksHeaders);
        for (Map.Entry<String, SdkDescriptor> e : loadedSdksHeaders.entrySet()) {
            IStatus validationStatus = sdkHeaderValidator.validate(e.getValue());
            if (validationStatus.isOK()) continue;
            importStatuses.addAll(validationStatus);
            validSdksHeaders.remove(e.getKey());
        }
        if (!importStatuses.isOK()) {
            SdksImporter.handleSdkImportingErrors(importStatuses);
        }
        return validSdksHeaders;
    }

    private static String loadSourcesXml(File dir) {
        Object errorStatus;
        MultiStatus importStatuses = SdkCoreActivator.getInstance().createMultiStatus(0, NLS.bind((String)Messages.ImportSdkHandler_error_import, (Object)dir.getAbsolutePath()));
        File sdkXmlEntry = null;
        try {
            sdkXmlEntry = SdksImporter.getSourceXmlFile(dir);
        }
        catch (LoadSdkException lse) {
            errorStatus = SdkCoreActivator.getInstance().createError(lse.getMessage(), null);
            importStatuses.add((IStatus)errorStatus);
            SdkCoreActivator.getInstance().log((IStatus)errorStatus);
        }
        String sourceXml = null;
        if (sdkXmlEntry != null) {
            try {
                errorStatus = null;
                Object var5_8 = null;
                try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(sdkXmlEntry));){
                    sourceXml = SdkManagementUtils.getSdksManifestXml(bis);
                }
                catch (Throwable throwable) {
                    if (errorStatus == null) {
                        errorStatus = throwable;
                    } else if (errorStatus != throwable) {
                        ((Throwable)errorStatus).addSuppressed(throwable);
                    }
                    throw errorStatus;
                }
            }
            catch (IOException ioe) {
                IStatus errorStatus2 = SdkCoreActivator.getInstance().createError(NLS.bind((String)Messages.ImportSdkHandler_error_read_source_xml, (Object)sdkXmlEntry.getAbsolutePath()), ioe);
                importStatuses.add(errorStatus2);
                SdkCoreActivator.getInstance().log(errorStatus2);
            }
        }
        if (!importStatuses.isOK()) {
            SdksImporter.handleSdkImportingErrors(importStatuses);
        }
        return sourceXml;
    }

    private static void handleSdkImportingErrors(MultiStatus errorStatuses) {
        try {
            SdksImporter.getImportSdkStatusHandler().handleStatus((IStatus)errorStatuses, null);
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().logError("Unable to handle error status: " + errorStatuses, ce);
        }
    }

    private static void unzipContent(File zipPath, File destinationFolder, String ... skipEntries) throws IOException {
        SdksImporter.unzipContent(zipPath, destinationFolder, (IProgressMonitor)new NullProgressMonitor(), skipEntries);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void unzipContent(File zipPath, File destinationFolder, IProgressMonitor progressMonitor, String ... skipEntries) throws IOException {
        String destinationFolderPath = destinationFolder.getAbsolutePath();
        try {
            Throwable throwable = null;
            Object var6_8 = null;
            try (ZipFile zipFile = new ZipFile(zipPath);){
                SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)progressMonitor, (int)zipFile.size());
                Enumeration<? extends ZipEntry> e = zipFile.entries();
                int bufferSize = 2048;
                List<String> skip = Arrays.asList(skipEntries);
                while (true) {
                    block26: {
                        if (!e.hasMoreElements()) {
                            subMonitor.done();
                            return;
                        }
                        ZipEntry entry = e.nextElement();
                        if (skip.contains(entry.getName())) continue;
                        byte[] data = new byte[bufferSize];
                        File destFile = new File(Paths.get(destinationFolderPath, entry.getName()).toString());
                        destFile.getParentFile().mkdirs();
                        Throwable throwable2 = null;
                        Object var17_21 = null;
                        try {
                            BufferedInputStream is = new BufferedInputStream(zipFile.getInputStream(entry));
                            try {
                                try (BufferedOutputStream dest = new BufferedOutputStream(new FileOutputStream(destFile), bufferSize);){
                                    while (true) {
                                        int count;
                                        if ((count = is.read(data, 0, bufferSize)) == -1) {
                                            dest.flush();
                                            break;
                                        }
                                        dest.write(data, 0, count);
                                    }
                                }
                                if (is == null) break block26;
                            }
                            catch (Throwable throwable3) {
                                if (throwable2 == null) {
                                    throwable2 = throwable3;
                                } else if (throwable2 != throwable3) {
                                    throwable2.addSuppressed(throwable3);
                                }
                                if (is == null) throw throwable2;
                                is.close();
                                throw throwable2;
                            }
                            is.close();
                        }
                        catch (Throwable throwable4) {
                            if (throwable2 == null) {
                                throwable2 = throwable4;
                                throw throwable2;
                            }
                            if (throwable2 == throwable4) throw throwable2;
                            throwable2.addSuppressed(throwable4);
                            throw throwable2;
                        }
                    }
                    subMonitor.worked(ProgressCounter.ProcessedUnit.getValue());
                }
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        catch (IOException ioe) {
            SdkCoreActivator.getInstance().logError(NLS.bind((String)Messages.ImportSdkHandler_error_extract_archive, (Object)zipPath.getAbsoluteFile(), (Object)destinationFolderPath), ioe);
            throw ioe;
        }
    }

    private static File getSourceXmlFile(File dir) throws LoadSdkException {
        File sdkXmlEntry = new File(dir, "sources.xml");
        if (!sdkXmlEntry.exists() || !sdkXmlEntry.canRead()) {
            throw new LoadSdkException(String.format(Messages.ImportSdkHandler_error_read_source_xml, "sources.xml", dir));
        }
        return sdkXmlEntry;
    }

    private static void deleteSdkExtractionFolder(File dir, boolean isImportFromArchive) {
        if (isImportFromArchive && dir.exists() && dir.isDirectory()) {
            SdkManagementUtils.deleteFolder(dir);
        }
    }

    private Map<String, String> requestRename(Map<String, String> sdkAttributes, String errorMessage) {
        return this.handler != null ? this.handler.handleRename(sdkAttributes, errorMessage) : sdkAttributes;
    }

    private String requestSourceLocation(Map<String, String> sdkAttributes, File defaultLocation) {
        return this.handler != null ? this.handler.handleChangeSourceLocation(sdkAttributes, defaultLocation) : defaultLocation.toString();
    }

    private static RcpStatusHandler getImportSdkStatusHandler() {
        return new RcpStatusHandler(){

            public Object handleStatus(IStatus status, Object source) throws CoreException {
                if (!status.isOK() && status.isMultiStatus() && ((MultiStatus)status).getChildren().length > 0) {
                    StatusManager.getManager().handle(status, 4);
                }
                SdkCoreActivator.getInstance().log(status);
                return source;
            }
        };
    }

    private static enum ProgressCounter {
        TotalWork(100),
        Unzip(80),
        ImportInitialization(5),
        LoadSourceXML(10),
        GetSelectedLocation(5),
        GetSDKDescriptor(20),
        ValidateStatus(20),
        AddImportedSDK(40),
        ProcessedUnit(1);

        private final int value;

        private ProgressCounter(int work) {
            this.value = work;
        }

        public int getValue() {
            return this.value;
        }
    }
}

