/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.module;

import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkFilter;
import com.nxp.s32ds.cle.cdt.sdk.filtering.SdkSmartFilter;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.module.ModuleSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.module.ModuleSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.VariablesPlugin;

public class SdkModulesHelper {
    private SdkModulesHelper() {
    }

    public static Collection<SdkDescriptor> getReferringModuleSdks(String sdkId) {
        if (sdkId == null || sdkId.isEmpty()) {
            return Collections.emptyList();
        }
        return ModuleSdkDescriptors.getModuleSdkDescriptors().stream().filter(moduleSdkDescriptor -> moduleSdkDescriptor.getModuleSdkId().equals(sdkId)).map(moduleSdkDescriptor -> SdkDescriptors.getSdkDescriptor((String)moduleSdkDescriptor.getSdkId())).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static boolean hasReferringModuleSdks(String sdkId) {
        return !SdkModulesHelper.getReferringModuleSdks(sdkId).isEmpty();
    }

    public static List<SdkDescriptor> getRefModulesSdksDescriptors(String sdkId) {
        return SdkModulesHelper.getRefModulesSdksDescriptors(sdkId, sdk -> true);
    }

    public static List<SdkDescriptor> getRefModulesSdksDescriptors(String sdkId, SdkFilter filter) {
        ArrayList<SdkDescriptor> result = new ArrayList<SdkDescriptor>();
        for (ModuleSdkDescriptor refModule : ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId)) {
            SdkDescriptor refSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)refModule.getModuleSdkId());
            if (refSdkDescriptor == null) continue;
            boolean isAccepted = filter.accept(refSdkDescriptor);
            if (isAccepted && filter instanceof SdkSmartFilter) {
                isAccepted &= ((SdkSmartFilter)filter).acceptOptions(refSdkDescriptor);
            }
            if (!isAccepted) continue;
            result.add(refSdkDescriptor);
        }
        return result;
    }

    public static Collection<String> getRefModulesSdksDescriptorsIds(String sdkId) {
        return SdkModulesHelper.getRefModulesSdksDescriptors(sdkId).stream().filter(Objects::nonNull).map(EntityDescriptor::getId).collect(Collectors.toList());
    }

    public static List<ModuleSdkDescriptor> getRefModulesDescriptors(String sdkId, SdkFilter filter) {
        ArrayList<ModuleSdkDescriptor> result = new ArrayList<ModuleSdkDescriptor>();
        for (ModuleSdkDescriptor refModule : ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId)) {
            SdkDescriptor refSdkDescriptor = SdkDescriptors.getSdkDescriptor((String)refModule.getModuleSdkId());
            if (refSdkDescriptor == null) continue;
            boolean isAccepted = filter.accept(refSdkDescriptor);
            if (isAccepted && filter instanceof SdkSmartFilter) {
                isAccepted &= ((SdkSmartFilter)filter).acceptOptions(refSdkDescriptor);
            }
            if (!isAccepted || !result.stream().map(ModuleSdkDescriptor::getModuleId).filter(Objects::nonNull).noneMatch(moduleId -> moduleId.equals(refModule.getModuleId()))) continue;
            result.add(refModule);
        }
        return result;
    }

    public static Map<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> getResourcesGrouppedByEnvironment(String sdkId, List<ResourceSdkDescriptor> resources) throws CoreException {
        EnvironmentSdkDescriptor rootSdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkId);
        if (rootSdkEnvironment == null) {
            return Collections.emptyMap();
        }
        ArrayList<EnvironmentSdkDescriptor> environmentSdkDescriptors = new ArrayList<EnvironmentSdkDescriptor>();
        environmentSdkDescriptors.add(rootSdkEnvironment);
        environmentSdkDescriptors.addAll(SdkModulesHelper.getRefModulesSdksDescriptors(sdkId).stream().map(sdk -> EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdk.getId())).filter(Objects::nonNull).collect(Collectors.toList()));
        HashMap<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>> result = new HashMap<EnvironmentSdkDescriptor, Set<ResourceSdkDescriptor>>();
        for (EnvironmentSdkDescriptor sdkEnvironment : environmentSdkDescriptors) {
            IPath environmentPath = Path.fromOSString((String)VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(sdkEnvironment.getValue()));
            resources.stream().filter(resource -> environmentPath.isPrefixOf(Path.fromOSString((String)resource.getPath()))).forEach(resource -> {
                boolean bl = result.computeIfAbsent(sdkEnvironment, s -> new LinkedHashSet()).add(resource);
            });
        }
        return result;
    }

    public static boolean isSdkAggregated(String sdkId) {
        return !ModuleSdkDescriptors.getModuleSdkDescriptorsBySdkId((String)sdkId).isEmpty();
    }

    public static boolean isSdkContainsRefModuleSdk(String sdkId, String refSdkId) {
        return SdkModulesHelper.isSdkAggregated(sdkId) && SdkModulesHelper.getRefModulesSdksDescriptorsIds(sdkId).contains(refSdkId);
    }
}

