/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.utils;

import com.nxp.s32ds.cle.cdt.sdk.filtering.FilterOptions;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.utils.register.SdkDescriptorsRegitsrationHelper;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorImplementation;
import com.nxp.s32ds.cle.runtime.sdk.internal.registry.core.SdkDescriptorUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkType;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.SdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkKind;
import com.nxp.s32ds.cle.runtime.sdk.registry.symbol.SymbolSdkKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SdkDescriptorBuilder {
    private Header header;
    private Environment environment;
    private List<Resource> resources = new ArrayList<Resource>();
    private List<Symbol> symbols = new ArrayList<Symbol>();
    private List<Module> modules = new ArrayList<Module>();
    private String projectName;

    public SdkDescriptorBuilder createHeader(String name, String version, String basePath, SdkType type, String description, String targetFolderName) {
        this.header = new Header(name, version, basePath, type, description, targetFolderName);
        return this;
    }

    public SdkDescriptorBuilder createHeader(Map<String, String> headerAttributes, SdkType type) {
        this.header = new Header(headerAttributes, type);
        return this;
    }

    public SdkDescriptorBuilder setFilterOptions(FilterOptions filterOptions) {
        Objects.requireNonNull(this.header);
        this.header.setFilterOptions(filterOptions);
        return this;
    }

    public SdkDescriptorBuilder setEnvironment(String name, String value, boolean isSystem) {
        this.environment = new Environment(name, value, isSystem);
        return this;
    }

    public SdkDescriptorBuilder addResource(String path, ResourceSdkKind kind, boolean isCopy) {
        this.resources.add(new Resource(path, kind, isCopy));
        return this;
    }

    public SdkDescriptorBuilder addSymbol(String value, SymbolSdkKind kind) {
        this.symbols.add(new Symbol(value, kind));
        return this;
    }

    public SdkDescriptorBuilder addModule(String moduleId, String moduleName, String moduleSdkId, String moduleDescription) {
        this.modules.add(new Module(moduleId, moduleName, moduleSdkId, moduleDescription));
        return this;
    }

    public SdkDescriptorBuilder setProjectName(String projectName) {
        Objects.requireNonNull(this.header);
        if (SdkType.PROJECT_LOCAL == this.header.type) {
            this.projectName = projectName;
        }
        return this;
    }

    public SdkDescriptor build() {
        return this.build(false);
    }

    public SdkDescriptor buildAndRegister() {
        return this.build(true);
    }

    private SdkDescriptor build(boolean isRegisterDescriptor) {
        Objects.requireNonNull(this.header);
        try {
            Element sdkElement = this.createSdkElement();
            if (!isRegisterDescriptor) {
                return new SdkDescriptorImplementation(sdkElement, this.header.type);
            }
            String sdkId = SdkDescriptorUtils.makeId((Element)sdkElement);
            if (SdkDescriptorsRegitsrationHelper.registerSdkDescriptors((Element)sdkElement, (SdkType)this.header.type, (String)this.projectName).isOK()) {
                return SdkDescriptors.getSdkDescriptor((String)sdkId);
            }
        }
        catch (ParserConfigurationException pce) {
            SdkCoreActivator.getInstance().logError("Unable create SDK due to exception", pce);
        }
        return null;
    }

    private Element createSdkElement() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
        documentBuilderFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element sdkElement = document.createElement("sdk");
        this.header.convertToXml(sdkElement);
        if (this.environment != null) {
            Element envElement = document.createElement("env");
            envElement.setAttribute("name", this.environment.name);
            envElement.setAttribute("value", this.environment.value);
            envElement.setAttribute("isSystem", String.valueOf(this.environment.isSystem));
            sdkElement.appendChild(envElement);
        }
        if (!this.resources.isEmpty()) {
            for (Resource resource : this.resources) {
                Element resourceElement = document.createElement(resource.kind.getXmlElementName());
                resourceElement.setAttribute("path", resource.path);
                resourceElement.setAttribute("copy", String.valueOf(resource.isCopy));
                sdkElement.appendChild(resourceElement);
            }
        }
        if (!this.symbols.isEmpty()) {
            Element symbolsElement = document.createElement("symbols");
            for (Symbol symbol : this.symbols) {
                Element symbolElement = document.createElement("symbol");
                symbolElement.setAttribute("name", symbol.value);
                symbolElement.setAttribute("type", symbol.kind.getXmlTypeAttribueValue());
                symbolsElement.appendChild(symbol.getElement(document));
            }
            sdkElement.appendChild(symbolsElement);
        }
        if (!this.modules.isEmpty()) {
            Element modulesElement = document.createElement("modules");
            for (Module module : this.modules) {
                Element moduleElement = document.createElement("module");
                moduleElement.setAttribute("id", module.id);
                moduleElement.setAttribute("name", module.name);
                moduleElement.setAttribute("sdkId", module.sdkId);
                moduleElement.setAttribute("description", module.description);
                modulesElement.appendChild(moduleElement);
            }
            sdkElement.appendChild(modulesElement);
        }
        return sdkElement;
    }

    private static class Environment {
        private String name;
        private String value;
        private boolean isSystem;

        private Environment(String name, String value, boolean isSystem) {
            this.name = Objects.requireNonNull(name);
            this.value = Objects.requireNonNull(value);
            this.isSystem = isSystem;
        }
    }

    private static class Header {
        private String name;
        private String version;
        private String basePath;
        private SdkType type;
        private String description;
        private String targetFolderName;
        private FilterOptions filterOptions;
        private Map<String, String> attributes;

        private Header(String name, String version, String basePath, SdkType type, String description, String targetFolderName) {
            this.name = Objects.requireNonNull(name);
            this.version = Objects.requireNonNull(version);
            this.basePath = Objects.requireNonNull(basePath);
            this.type = type;
            this.description = Objects.toString(description, "");
            this.targetFolderName = targetFolderName;
        }

        private Header(Map<String, String> attributes, SdkType type) {
            this.attributes = attributes;
            this.type = type;
        }

        private void setFilterOptions(FilterOptions filterOptions) {
            this.filterOptions = filterOptions;
        }

        private void convertToXml(Element sdkElement) {
            if (this.attributes != null && !this.attributes.isEmpty()) {
                this.attributes.entrySet().forEach(e -> sdkElement.setAttribute((String)e.getKey(), (String)e.getValue()));
            } else {
                sdkElement.setAttribute("name", this.name);
                sdkElement.setAttribute("version", this.version);
                sdkElement.setAttribute("basePath", this.basePath);
                sdkElement.setAttribute("description", this.description);
                sdkElement.setAttribute("targetFolderName", this.targetFolderName);
            }
            if (this.filterOptions != null) {
                sdkElement.setAttribute("langs", this.filterOptions.getLang().getLang());
                sdkElement.setAttribute("cores", this.filterOptions.getHardwareIdsString());
                sdkElement.setAttribute("deviceRevisionId", this.filterOptions.getDeviceRevisionId());
                sdkElement.setAttribute("toolchains", this.filterOptions.getToolChainsIdsString());
            }
        }
    }

    private static class Module {
        private String id;
        private String name;
        private String sdkId;
        private String description;

        private Module(String id, String name, String sdkId, String description) {
            this.id = id;
            this.name = name;
            this.sdkId = sdkId;
            this.description = description;
        }
    }

    private static class Resource {
        private String path;
        private ResourceSdkKind kind;
        private boolean isCopy;

        private Resource(String path, ResourceSdkKind kind, boolean isCopy) {
            this.path = path;
            this.kind = kind;
            this.isCopy = isCopy;
        }
    }

    private static class Symbol {
        private String value;
        private SymbolSdkKind kind;

        private Symbol(String value, SymbolSdkKind kind) {
            this.value = value;
            this.kind = kind;
        }

        private Element getElement(Document document) {
            Element symbolElement = document.createElement("symbol");
            symbolElement.setAttribute("name", this.value);
            symbolElement.setAttribute("type", this.kind.getXmlTypeAttribueValue());
            return symbolElement;
        }
    }
}

