/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkBasePathValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkEnvironmentValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkTargetFolderNameValidator;
import com.nxp.s32ds.cle.cdt.sdk.core.validators.SdkVersionValidator;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.environment.EnvironmentSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.environment.EnvironmentSdkDescriptor;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;

public class SdkHeaderValidator
implements IValidator<SdkDescriptor> {
    public IStatus validate(SdkDescriptor sdkDescriptor) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, null, null);
        String sdkName = sdkDescriptor.getName();
        IStatus validateNameStatus = new SdkNameValidator().validate(sdkName);
        SdkHeaderValidator.addErrorStatus(validateNameStatus, result);
        String targetFolderName = sdkDescriptor.getTargetFolderName();
        if (validateNameStatus.isOK() || !sdkName.equals(targetFolderName)) {
            SdkHeaderValidator.addErrorStatus(new SdkTargetFolderNameValidator().validate(targetFolderName), result);
        }
        SdkHeaderValidator.addErrorStatus(new SdkVersionValidator().validate(sdkDescriptor.getVersion()), result);
        IStatus validateBasePathStatus = new SdkBasePathValidator().validate(sdkDescriptor.getBasePath());
        SdkHeaderValidator.addErrorStatus(validateBasePathStatus, result);
        EnvironmentSdkDescriptor sdkEnvironment = EnvironmentSdkDescriptors.getEnvironmentSdkDescriptorBySdkId((String)sdkDescriptor.getId());
        if (sdkEnvironment != null && validateBasePathStatus.isOK()) {
            SdkHeaderValidator.addErrorStatus(new SdkEnvironmentValidator().validate(sdkEnvironment), result);
        }
        return result;
    }

    private static void addErrorStatus(IStatus status, MultiStatus result) {
        if (!status.isOK()) {
            if (status.isMultiStatus()) {
                result.addAll((IStatus)((MultiStatus)status));
            } else {
                result.add(status);
            }
        }
    }
}

