/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SdkNameValidator
implements IValidator<String> {
    private static final String SDK_NAME_PATTERN = "^[a-zA-Z0-9_]*$";
    private static final int SDK_NAME_MAX_LENGTH = 240;

    public IStatus validate(String name) {
        if (Objects.toString(name, "").isEmpty()) {
            return ValidationStatus.error((String)Messages.SdkNameValidator_error_name_is_empty);
        }
        if (!Character.isLetter(name.charAt(0))) {
            return ValidationStatus.error((String)Messages.SdkNameValidator_error_name_start_symbol);
        }
        if (name.length() > 240) {
            return ValidationStatus.error((String)Messages.SdkNameValidator_erorr_name_length);
        }
        if (!name.matches(SDK_NAME_PATTERN)) {
            return ValidationStatus.error((String)Messages.SdkNameValidator_erorr_name_characters);
        }
        return Status.OK_STATUS;
    }
}

