/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.core.validators;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import java.util.Objects;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class SdkTargetFolderNameValidator
implements IValidator<String> {
    private static final String SDK_TARGET_FOLDER_NAME_PATTERN = "^[a-zA-Z0-9_]*$";
    private static final int SDK_TARGET_FOLDER_NAME_MAX_LENGTH = 250;

    public IStatus validate(String name) {
        if (Objects.toString(name, "").isEmpty()) {
            return Status.OK_STATUS;
        }
        if (!Character.isLetter(name.charAt(0))) {
            return ValidationStatus.error((String)Messages.SdkTargetFolderNameValidator_error_target_folder_name_start_symbol);
        }
        if (name.length() > 250) {
            return ValidationStatus.error((String)NLS.bind((String)Messages.SdkTargetFolderNameValidator_error_target_folder_name_length, (Object)250));
        }
        if (!name.matches(SDK_TARGET_FOLDER_NAME_PATTERN)) {
            return ValidationStatus.error((String)Messages.SdkTargetFolderNameValidator_error_target_folder_name_characters);
        }
        return Status.OK_STATUS;
    }
}

