/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;

public class SdkVersion
implements Comparable<SdkVersion> {
    private static final String SEPARATOR = ".";
    private static final List<String> VERSION_PATTERNS = new ArrayList<String>();
    private int major = -1;
    private int minor = -1;
    private int micro = -1;
    private String qualifier = null;

    static {
        VERSION_PATTERNS.add("^(\\d+)$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))$");
        VERSION_PATTERNS.add("^(\\d+)(?:\\.(\\d+))(?:\\.(\\d+))(?:\\.([a-zA-Z0-9_]+))$");
    }

    private SdkVersion(List<String> versionParts) {
        this.major = Integer.parseInt(versionParts.get(0));
        if (versionParts.size() > 1) {
            this.minor = Integer.parseInt(versionParts.get(1));
        }
        if (versionParts.size() > 2) {
            this.micro = Integer.parseInt(versionParts.get(2));
        }
        if (versionParts.size() > 3) {
            this.qualifier = versionParts.get(3);
        }
    }

    public static SdkVersion createVersion(String version) {
        List<String> parsedVersion = null;
        try {
            parsedVersion = SdkVersion.parseVersion(version);
        }
        catch (IllegalArgumentException iae) {
            SdkCoreActivator.getInstance().logError(iae.getMessage());
            throw iae;
        }
        return new SdkVersion(parsedVersion);
    }

    public static List<String> parseVersion(String version) {
        int groupsCount;
        ArrayList<String> parsedVersion = new ArrayList<String>();
        boolean isMatched = false;
        Matcher matcher = VERSION_PATTERNS.stream().map(pattern -> Pattern.compile(pattern).matcher(version)).filter(Matcher::find).findFirst().orElse(null);
        if (matcher != null && (groupsCount = matcher.groupCount()) > 0 && groupsCount <= 4) {
            isMatched = true;
            int i = 1;
            while (i <= groupsCount) {
                parsedVersion.add(matcher.group(i));
                ++i;
            }
        }
        SdkVersion.validate(version, parsedVersion, isMatched);
        return parsedVersion;
    }

    @Override
    public int compareTo(SdkVersion other) {
        if (other == this) {
            return 0;
        }
        int result = this.major - other.major;
        if (result != 0) {
            return result;
        }
        result = this.minor - other.minor;
        if (result != 0) {
            return result;
        }
        result = this.micro - other.micro;
        if (result != 0) {
            return result;
        }
        if (this.qualifier == null) {
            return other.qualifier == null ? 0 : -1;
        }
        return other.qualifier == null ? 1 : this.qualifier.compareTo(other.qualifier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major);
        if (this.minor != -1) {
            sb.append(SEPARATOR).append(this.minor);
            if (this.micro != -1) {
                sb.append(SEPARATOR).append(this.micro);
                if (this.qualifier != null) {
                    sb.append(SEPARATOR).append(this.qualifier);
                }
            }
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.major;
        result = 31 * result + this.micro;
        result = 31 * result + this.minor;
        result = 31 * result + (this.qualifier == null ? 0 : this.qualifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SdkVersion other = (SdkVersion)obj;
        if (this.major != other.major) {
            return false;
        }
        if (this.micro != other.micro) {
            return false;
        }
        if (this.minor != other.minor) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    private static void validate(String version, List<String> parsedVersion, boolean isMatched) {
        if (!isMatched || parsedVersion.isEmpty()) {
            throw new IllegalArgumentException(NLS.bind((String)Messages.SdkVersion_error_sdk_version, (Object)version));
        }
        int i = 0;
        while (i < parsedVersion.size()) {
            String part = parsedVersion.get(i);
            if (i < 3) {
                if (part.length() > 1 && part.startsWith("0")) {
                    throw new IllegalArgumentException(Messages.SdkVersion_error_sdk_version_has_zeros);
                }
                try {
                    Integer.parseInt(part);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IllegalArgumentException(NLS.bind((String)Messages.SdkVersion_error_sdk_version_number_format, (Object)Integer.MAX_VALUE));
                }
            }
            ++i;
        }
    }
}

