/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action;

import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.AbstractSdkAction;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectLaunchConfigurationAction
extends AbstractSdkAction {
    public static final String ADD_LAUNCH_CONFIGURATION_VALUE_ELEMENT = "addLaunchValue";
    public static final String CLEANUP_LAUNCH_CONFIGURATION_VALUE_ELEMENT = "cleanupLaunchValue";
    public static final String REMOVE_LAUNCH_CONFIGURATION_VALUE_ELEMENT = "removeLaunchValue";
    public static final String SET_LAUNCH_CONFIGURATION_VALUE_ELEMENT = "setLaunchValue";
    public static final String LAUNCH_CONFIGURATION_ATTRIBUTE_KEY_ATTRIBUTE = "key";
    public static final String LAUNCH_CONFIGURATION_ATTRIBUTE_VALUE_ATTRIBUTE = "value";
    protected String key;
    protected String value;
    private SdkActionOperations operation;

    public ProjectLaunchConfigurationAction(Element projectLaunchActionElement) {
        super(projectLaunchActionElement);
        this.key = projectLaunchActionElement.getAttribute(LAUNCH_CONFIGURATION_ATTRIBUTE_KEY_ATTRIBUTE);
        this.value = projectLaunchActionElement.getAttribute(LAUNCH_CONFIGURATION_ATTRIBUTE_VALUE_ATTRIBUTE);
        this.operation = ProjectLaunchConfigurationAction.getUpdateOperation(projectLaunchActionElement);
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        UpdateOperation updateOperation;
        if (this.isApplicable(configuration) && (updateOperation = this.getUpdateOperation(this.operation)) != null) {
            MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
            ProjectSettingsUpdater launchConfigurationUpdater = ProjectSettingsUpdaters.getLaunchConfigurationUpdater();
            result.add(launchConfigurationUpdater.update(configuration, this.key, this.value, updateOperation));
            return result;
        }
        return Status.CANCEL_STATUS;
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public void convertToXml(Document document, Element actionsElement) {
        Element element = null;
        switch (this.operation) {
            case LAUNCH_VALUE_ADD: {
                element = document.createElement(ADD_LAUNCH_CONFIGURATION_VALUE_ELEMENT);
                break;
            }
            case LAUNCH_VALUE_REMOVE: {
                element = document.createElement(REMOVE_LAUNCH_CONFIGURATION_VALUE_ELEMENT);
                break;
            }
            case LAUNCH_VALUE_CLEANUP: {
                element = document.createElement(CLEANUP_LAUNCH_CONFIGURATION_VALUE_ELEMENT);
                break;
            }
            case LAUNCH_VALUE_SET: {
                element = document.createElement(SET_LAUNCH_CONFIGURATION_VALUE_ELEMENT);
            }
        }
        if (element != null) {
            super.convertAttributesToXml(document, element);
            element.setAttribute(LAUNCH_CONFIGURATION_ATTRIBUTE_KEY_ATTRIBUTE, this.key);
            if (this.operation != SdkActionOperations.LAUNCH_VALUE_CLEANUP) {
                element.setAttribute(LAUNCH_CONFIGURATION_ATTRIBUTE_VALUE_ATTRIBUTE, this.value);
            }
            actionsElement.appendChild(element);
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectLaunchConfigurationAction)) {
            return false;
        }
        ProjectLaunchConfigurationAction other = (ProjectLaunchConfigurationAction)obj;
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
            return false;
        }
        return this.operation == other.operation;
    }

    private static SdkActionOperations getUpdateOperation(Element element) {
        switch (element.getNodeName()) {
            case "addLaunchValue": {
                return SdkActionOperations.LAUNCH_VALUE_ADD;
            }
            case "removeLaunchValue": {
                return SdkActionOperations.LAUNCH_VALUE_REMOVE;
            }
            case "setLaunchValue": {
                return SdkActionOperations.LAUNCH_VALUE_SET;
            }
            case "cleanupLaunchValue": {
                return SdkActionOperations.LAUNCH_VALUE_CLEANUP;
            }
        }
        return SdkActionOperations.UNSUPPORTED_OPERATION;
    }
}

