/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.action.SdkActionOperations;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceAction;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Element;

public class ProjectResourceBuildPathExcludeAction
extends ProjectResourceAction {
    public static final String EXCLUDE_FILE_FROM_BUILD_PATH_ACTION_ELEMENT = "excludeProjectFileFromBuildPath";
    public static final String EXCLUDE_FOLDER_FROM_BUILD_PATH_ACTION_ELEMENT = "excludeProjectFolderFromBuildPath";
    private SdkActionOperations operation;

    public ProjectResourceBuildPathExcludeAction(Element element) {
        super(element);
        this.operation = ProjectResourceBuildPathExcludeAction.getOperation(element);
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        this.getResources(project).forEach(res -> result.add(this.excludeResourceFromBuildPath((IResource)res, configuration)));
        return result;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ProjectResourceBuildPathExcludeAction)) {
            return false;
        }
        ProjectResourceBuildPathExcludeAction other = (ProjectResourceBuildPathExcludeAction)obj;
        return this.operation == other.operation;
    }

    @Override
    protected Collection<IResource> getResources(IProject project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (String pathString : this.paths) {
            IPath path = Path.fromOSString((String)pathString);
            if ("*".equals(path.lastSegment())) {
                String parentPath = path.uptoSegment(path.segmentCount() - 1).toOSString();
                if (parentPath.isEmpty()) continue;
                result.addAll(this.collectChildResources(project, parentPath));
                continue;
            }
            IResource resource = project.findMember(pathString);
            if (resource == null) continue;
            result.add(resource);
        }
        return result;
    }

    @Override
    protected String getElementName() {
        switch (this.operation) {
            case PROJECT_FILE_EXCLUDE_FROM_BUILD_PATH: {
                return EXCLUDE_FILE_FROM_BUILD_PATH_ACTION_ELEMENT;
            }
            case PROJECT_FOLDER_EXCLUDE_FROM_BUILD_PATH: {
                return EXCLUDE_FOLDER_FROM_BUILD_PATH_ACTION_ELEMENT;
            }
        }
        throw new UnsupportedOperationException();
    }

    private static SdkActionOperations getOperation(Element element) {
        switch (element.getNodeName()) {
            case "excludeProjectFileFromBuildPath": {
                return SdkActionOperations.PROJECT_FILE_EXCLUDE_FROM_BUILD_PATH;
            }
            case "excludeProjectFolderFromBuildPath": {
                return SdkActionOperations.PROJECT_FOLDER_EXCLUDE_FROM_BUILD_PATH;
            }
        }
        return SdkActionOperations.UNSUPPORTED_OPERATION;
    }
}

