/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceFileAction;
import java.util.ArrayList;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public class ProjectResourceFileRemoveAction
extends ProjectResourceFileAction {
    public ProjectResourceFileRemoveAction(Element element) {
        super(element);
        this.isBackupResource = Boolean.parseBoolean(element.getAttribute("backup"));
    }

    public IStatus execute(IProject project, IConfiguration configuration) {
        if (!project.isAccessible()) {
            return new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceRemoveAction_error_project_not_accessible, (Object)this.pathsToString(), (Object)project));
        }
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        ArrayList<IResource> backedupResources = new ArrayList<IResource>();
        if (this.isBackupResource) {
            result.addAll(this.backupResource(project, backedupResources));
        }
        for (IResource resource : this.getResources(project)) {
            if (backedupResources.contains(resource)) continue;
            try {
                resource.delete(true, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ce) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceRemoveAction_error_execute_exception, (Object)this.pathsToString()), (Throwable)ce));
            }
        }
        return result;
    }

    @Override
    protected String getElementName() {
        return "removeProjectFile";
    }
}

