/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource;

import com.nxp.s32ds.cle.cdt.sdk.internal.core.Messages;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.action.resource.ProjectResourceAction;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Element;

public abstract class ProjectResourceFolderAction
extends ProjectResourceAction {
    public static final String CREATE_PROJECT_FOLDER_ELEMENT = "createProjectFolder";
    public static final String REMOVE_PROJECT_FOLDER_ELEMENT = "removeProjectFolder";
    public static final String CLEANUP_PROJECT_FOLDER_ELEMENT = "cleanupProjectFolder";
    public static final String BACKUP_PROJECT_FOLDER_ELEMENT = "backupProjectFolder";

    public ProjectResourceFolderAction(Element element) {
        super(element);
    }

    @Override
    protected Collection<IResource> getResources(IProject project) {
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (String pathString : this.paths) {
            IPath path = Path.fromOSString((String)pathString);
            if ("*".equals(path.lastSegment())) {
                String parentPath = path.uptoSegment(path.segmentCount() - 1).toOSString();
                if (parentPath.isEmpty()) continue;
                this.collectChildResources(project, parentPath).stream().filter(resource -> 2 == resource.getType()).forEach(result::add);
                continue;
            }
            result.add((IResource)project.getFolder(pathString));
        }
        return result;
    }

    @Override
    protected IStatus backupResource(IProject project) {
        MultiStatus result = new MultiStatus("com.nxp.s32ds.cle.cdt.sdk.core", 0, "", null);
        for (IResource resource : this.getResources(project)) {
            IFolder sourceFolder = (IFolder)resource;
            String backupFolderPath = String.valueOf(sourceFolder.getName()) + ".bak";
            IFolder backupFolder = project.getFolder(backupFolderPath);
            if (backupFolder == null || backupFolder.exists()) {
                result.add((IStatus)new Status(8, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceAction_error_resource_already_exists, (Object)backupFolderPath)));
                continue;
            }
            try {
                backupFolder.create(1, true, (IProgressMonitor)new NullProgressMonitor());
                IPath newFolderPath = backupFolder.getFullPath();
                IResource[] iResourceArray = sourceFolder.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource childResource = iResourceArray[n2];
                    IPath copyToPath = newFolderPath.append(childResource.getFullPath().lastSegment());
                    childResource.copy(copyToPath, true, (IProgressMonitor)new NullProgressMonitor());
                    ++n2;
                }
            }
            catch (CoreException ce) {
                result.add((IStatus)new Status(4, "com.nxp.s32ds.cle.cdt.sdk.core", NLS.bind((String)Messages.ProjectResourceAction_error_execute_backup_exception, (Object)backupFolderPath), (Throwable)ce));
            }
        }
        return result;
    }
}

