/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.attach;

import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdater;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.ProjectSettingsUpdaters;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.UpdateOperation;
import com.nxp.s32ds.cle.cdt.project.configuration.core.updaters.status.SourceEntriesUpdateStatus;
import com.nxp.s32ds.cle.cdt.sdk.core.attach.SdkAttachDataHelper;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourceApplicabilityChecker;
import com.nxp.s32ds.cle.cdt.sdk.core.resource.ResourcesHandler;
import com.nxp.s32ds.cle.cdt.sdk.internal.core.SdkCoreActivator;
import com.nxp.s32ds.cle.ide.sdk.core.resource.SdkProjectResourcesUtils;
import com.nxp.s32ds.cle.runtime.sdk.registry.SdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.resource.ResourceSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.core.toolchain.ToolChainSdkDescriptors;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkDescriptor;
import com.nxp.s32ds.cle.runtime.sdk.registry.resource.ResourceSdkGroup;
import com.nxp.s32ds.cle.runtime.sdk.registry.toolchain.ToolChainSdkDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.core.model.CoreModel;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.core.settings.model.ICSourceEntry;
import org.eclipse.cdt.core.settings.model.WriteAccessException;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;

public class SdkAttachSourcePathsProcessor {
    public static final String SOURCEENTRIESPATH = "/SDK/platform";

    private SdkAttachSourcePathsProcessor() {
    }

    public static void updateProjectSourceEntries(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration, MultiStatus result) {
        String configurationName = configuration.getName();
        ICConfigurationDescription initialConfigurationDescription = CoreModel.getDefault().getProjectDescription(project).getConfigurationByName(configurationName);
        List<ICSourceEntry> initialSourceEntries = Arrays.asList(initialConfigurationDescription.getSourceEntries());
        HashSet<String> sourcePaths = new HashSet<String>();
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        IPath targetFolderPath = Path.fromOSString((String)targetFolderName);
        if (targetFolderPath.segmentCount() > 0) {
            targetFolderName = targetFolderPath.uptoSegment(1).toString();
        }
        SdkAttachSourcePathsProcessor.removeSdkTargetFolderSourceEntry(project, configurationName, targetFolderPath);
        sourcePaths.add(project.getFolder(targetFolderName).getFullPath().toString());
        sourcePaths.addAll(SdkAttachSourcePathsProcessor.getSourceFolders(project, sdkDescriptor, configuration));
        Set<String> excludedPaths = SdkAttachSourcePathsProcessor.getExcludedPaths(project, sdkDescriptor, configuration);
        ProjectSettingsUpdater sourceEntriesUpdater = ProjectSettingsUpdaters.getSourceEntriesUpdater();
        sourceEntriesUpdater.update(configuration, null, sourcePaths, UpdateOperation.ADD);
        if (excludedPaths != null && !excludedPaths.isEmpty()) {
            sourceEntriesUpdater.update(configuration, null, excludedPaths, UpdateOperation.REMOVE);
        }
        ICConfigurationDescription updatedConfigurationDescription = CoreModel.getDefault().getProjectDescription(project).getConfigurationByName(configurationName);
        List<ICSourceEntry> updatedSourceEntries = Arrays.asList(updatedConfigurationDescription.getSourceEntries());
        SourceEntriesUpdateStatus sourceEntriesUpdateStatus = SdkAttachSourcePathsProcessor.getSourceEntriesUpdateStatus(configurationName, result);
        sourceEntriesUpdateStatus.setSourceEntries(updatedSourceEntries.stream().filter(sourceEntry -> !initialSourceEntries.contains(sourceEntry)).collect(Collectors.toList()).toArray(new ICSourceEntry[0]));
    }

    public static void removeSdkSourceEntries(IProject project, SdkDescriptor sdkDescriptor) {
        String targetFolderPath = SdkAttachSourcePathsProcessor.getSdkTargetPath(project, sdkDescriptor);
        for (IConfiguration configuration : ProjectConfigurationUtils.getProjectConfigurations((IProject)project)) {
            SdkAttachSourcePathsProcessor.removeSdkSourceEntries(sdkDescriptor, configuration);
            if (targetFolderPath == null) continue;
            ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, targetFolderPath, UpdateOperation.REMOVE);
        }
    }

    public static void removeSdkSourceEntries(IProject project, IConfiguration configuration, String sdkId) {
        IPath projectPath = project.getFullPath();
        String sourceEntriesPath = String.valueOf(projectPath.toOSString()) + SOURCEENTRIESPATH;
        ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, sourceEntriesPath, UpdateOperation.REMOVE);
    }

    public static void removeSdkSourceEntries(SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        String sdkId = sdkDescriptor.getId();
        SourceEntriesUpdateStatus sourceEntriesUpdateStatus = SdkAttachSourcePathsProcessor.getSourceEntriesUpdateStatus(sdkId, configuration);
        if (sourceEntriesUpdateStatus == null) {
            return;
        }
        ICSourceEntry[] sourceEntriesToRemove = sourceEntriesUpdateStatus.getSourceEntries();
        if (sourceEntriesToRemove == null) {
            return;
        }
        HashSet<String> sourcePathsToRemove = new HashSet<String>();
        IProject project = configuration.getOwner().getProject();
        String targetFolder = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        ICSourceEntry[] iCSourceEntryArray = sourceEntriesToRemove;
        int n = sourceEntriesToRemove.length;
        int n2 = 0;
        while (n2 < n) {
            IPath containerPath;
            ICSourceEntry sourceEntry = iCSourceEntryArray[n2];
            String sourceEntryPath = sourceEntry.getValue();
            if (sourceEntryPath.equals((containerPath = project.getFolder(Path.fromOSString((String)targetFolder).uptoSegment(1)).getFullPath()).toString())) {
                sourceEntryPath = SdkAttachSourcePathsProcessor.getSdkTargetPath(project, sdkDescriptor);
            }
            if (sourceEntryPath != null) {
                sourcePathsToRemove.add(sourceEntryPath);
            }
            ++n2;
        }
        ProjectSettingsUpdaters.getSourceEntriesUpdater().update(configuration, null, sourcePathsToRemove, UpdateOperation.REMOVE);
    }

    private static Set<String> getSourceFolders(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        HashSet<String> result = new HashSet<String>();
        String sdkId = sdkDescriptor.getId();
        ToolChainSdkDescriptor rootToolChainDescriptor = ToolChainSdkDescriptors.getRootToolChainSdkDescriptor((String)sdkId);
        String rootToolChainId = rootToolChainDescriptor != null ? rootToolChainDescriptor.getToolChainId() : null;
        ArrayList sourceDescriptors = new ArrayList();
        sourceDescriptors.addAll(ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)rootToolChainId));
        IToolChain toolChain = configuration.getToolChain();
        if (toolChain != null) {
            sourceDescriptors.addAll(ResourceSdkDescriptors.getResourceSdkDescriptorsBySdkIdAndToolChainId((String)sdkId, (String)toolChain.getBaseId()));
        }
        sourceDescriptors.stream().filter(resource -> ResourcesHandler.isResourceAccepted(resource, ResourceSdkGroup.SOURCE_RESOURCES, configuration)).map(resource -> SdkProjectResourcesUtils.getTargetResource((ResourceSdkDescriptor)resource, (SdkDescriptor)sdkDescriptor, (IProject)project)).forEach(resource -> SdkAttachSourcePathsProcessor.addSourceFolderPath(resource, project, result));
        return result;
    }

    private static void addSourceFolderPath(IResource resource, IProject project, Set<String> result) {
        if (resource == null || 1 == resource.getType() && resource.getParent().equals((Object)project)) {
            return;
        }
        IPath fullPath = resource.getParent().getFullPath();
        if (fullPath.segmentCount() > 1) {
            result.add(fullPath.uptoSegment(2).toString());
        }
    }

    private static Set<String> getExcludedPaths(IProject project, SdkDescriptor sdkDescriptor, IConfiguration configuration) {
        List<IResource> targetResources = ResourcesHandler.getTargetResources(project, sdkDescriptor, configuration, res -> !ResourceApplicabilityChecker.isApplicable(res, configuration));
        return targetResources.stream().map(res -> res.getFullPath().toString()).collect(Collectors.toSet());
    }

    private static SourceEntriesUpdateStatus getSourceEntriesUpdateStatus(String configurationName, MultiStatus updateStatuses) {
        Optional<SourceEntriesUpdateStatus> optional = Arrays.stream(updateStatuses.getChildren()).filter(updateStatus -> updateStatus instanceof SourceEntriesUpdateStatus).map(updateStatus -> (SourceEntriesUpdateStatus)updateStatus).filter(updateStatus -> configurationName.equals(updateStatus.getConfigurationName())).findFirst();
        if (optional.isPresent()) {
            return optional.get();
        }
        SourceEntriesUpdateStatus updateStatus2 = new SourceEntriesUpdateStatus(configurationName);
        updateStatuses.add((IStatus)updateStatus2);
        return updateStatus2;
    }

    private static SourceEntriesUpdateStatus getSourceEntriesUpdateStatus(String sdkId, IConfiguration configuration) {
        return SdkAttachDataHelper.getAttachUpdateStatuses(sdkId, configuration).stream().filter(updateStatus -> updateStatus instanceof SourceEntriesUpdateStatus).map(updateStatus -> (SourceEntriesUpdateStatus)updateStatus).findFirst().orElse(null);
    }

    private static String getSdkTargetPath(IProject project, SdkDescriptor sdkDescriptor) {
        String targetFolderName = SdkProjectResourcesUtils.getSdkTargetFolderName((SdkDescriptor)sdkDescriptor, (IProject)project);
        String containerFolder = Path.fromOSString((String)targetFolderName).uptoSegment(1).toString();
        String targetPath = project.getFolder(containerFolder).getFullPath().toString();
        try {
            if (Arrays.stream(project.getFolder(containerFolder).members()).map(resource -> resource.getProjectRelativePath().toOSString()).anyMatch(path -> !targetFolderName.equals(path))) {
                targetPath = project.getFolder(targetFolderName).getFullPath().toString();
            }
        }
        catch (CoreException ce) {
            SdkCoreActivator.getInstance().log(ce.getStatus());
            return null;
        }
        return targetPath;
    }

    private static void removeSdkTargetFolderSourceEntry(IProject project, String configurationName, IPath targetFolderPath) {
        try {
            ICProjectDescription pd = CoreModel.getDefault().getProjectDescription(project);
            ICConfigurationDescription cd = pd.getConfigurationByName(configurationName);
            ArrayList<ICSourceEntry> sourceEntries = new ArrayList<ICSourceEntry>(Arrays.asList(cd.getSourceEntries()));
            String containerFolder = project.getFolder(targetFolderPath.uptoSegment(1)).getFullPath().toString();
            IPath sdkSubFolder = Path.fromOSString((String)targetFolderPath.lastSegment());
            Optional<ICSourceEntry> optional = sourceEntries.stream().filter(sourceEntry -> containerFolder.equals(sourceEntry.getValue()) && Arrays.asList(sourceEntry.getExclusionPatterns()).contains(sdkSubFolder)).findFirst();
            if (optional.isPresent()) {
                sourceEntries.remove(optional.get());
                cd.setSourceEntries(sourceEntries.toArray(new ICSourceEntry[0]));
                CoreModel.getDefault().setProjectDescription(project, pd);
            }
        }
        catch (WriteAccessException | CoreException e) {
            SdkCoreActivator.getInstance().logError(e.getMessage());
        }
    }
}

