/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.cdt.sdk.internal.core.condition;

import com.freescale.s32ds.cross.core.ProjectContextSettings;
import com.nxp.s32ds.cle.cdt.project.configuration.core.ProjectConfigurationUtils;
import com.nxp.s32ds.cle.cdt.sdk.condition.ConditionCheck;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConditionCheckCoresEnabled
implements ConditionCheck {
    public static final String CONDITION_CHECK_CORES_ENABLED_ATTRIBUTE = "coresEnabled";
    private final Set<String> deviceCoreIds;

    ConditionCheckCoresEnabled(Element conditionCheckElement) {
        this.deviceCoreIds = Arrays.stream(conditionCheckElement.getAttribute(CONDITION_CHECK_CORES_ENABLED_ATTRIBUTE).split(",")).map(String::trim).filter(deviceCoreId -> !deviceCoreId.isEmpty()).collect(Collectors.toSet());
    }

    public boolean check(Object checkCondition) {
        if (checkCondition instanceof IConfiguration) {
            List multiCoreProjects = ProjectConfigurationUtils.getMultiCoreProjects((IConfiguration)((IConfiguration)checkCondition));
            if (multiCoreProjects.isEmpty()) {
                return false;
            }
            List refProjectsDeviceCoreIds = multiCoreProjects.stream().map(refProject -> new ProjectContextSettings(refProject).getAttributeByKey("com.nxp.s32ds.cle.runtime.hardware.registry.deviceCore.id")).map(String::trim).filter(projectDeviceCoreId -> !projectDeviceCoreId.isEmpty()).collect(Collectors.toList());
            if (!this.deviceCoreIds.isEmpty() && !refProjectsDeviceCoreIds.isEmpty()) {
                if (!this.deviceCoreIds.stream().anyMatch(refProjectsDeviceCoreIds::contains)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public void convertToXml(Document document, Element conditionElement) {
        Element checkElement = document.createElement("check");
        checkElement.setAttribute(CONDITION_CHECK_CORES_ENABLED_ATTRIBUTE, String.join((CharSequence)",", this.deviceCoreIds));
        conditionElement.appendChild(checkElement);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.deviceCoreIds == null ? 0 : this.deviceCoreIds.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionCheckCoresEnabled)) {
            return false;
        }
        ConditionCheckCoresEnabled other = (ConditionCheckCoresEnabled)obj;
        return !(this.deviceCoreIds == null ? other.deviceCoreIds != null : !this.deviceCoreIds.equals(other.deviceCoreIds));
    }
}

